/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table<T>
implements Iterable<Entry<T>> {
    private Map<T, Map<T, Number>> table = new LinkedHashMap<T, Map<T, Number>>();
    private Set<T> nameset = null;

    public void addValue(T nameX, T nameY, Number value) {
        this.nameset = null;
        Map<T, Number> valueMap = this.table.get(nameX);
        if (valueMap == null) {
            valueMap = new LinkedHashMap<T, Number>();
            this.table.put(nameX, valueMap);
        }
        valueMap.put(nameY, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Set<T> headerSet = this.getKeySet();
        for (T v : headerSet) {
            sb.append(", ").append(v);
        }
        for (T x : headerSet) {
            sb.append(System.getProperty("line.separator"));
            sb.append(x);
            for (T y : headerSet) {
                if (x == y) break;
                sb.append(", ").append(this.getValue(x, y));
            }
        }
        return new String(sb);
    }

    public Set<T> getKeySet() {
        if (this.nameset == null) {
            this.nameset = this.constructNameset();
        }
        return Collections.unmodifiableSet(this.nameset);
    }

    public T[] getKeys(T[] array) {
        if (this.nameset == null) {
            this.nameset = this.constructNameset();
        }
        return this.nameset.toArray(array);
    }

    public Object[] getKeys() {
        if (this.nameset == null) {
            this.nameset = this.constructNameset();
        }
        return this.nameset.toArray();
    }

    public int getKeySize() {
        if (this.nameset == null) {
            this.nameset = this.constructNameset();
        }
        return this.nameset.size();
    }

    public Number getValue(T nameX, T nameY) {
        return this.getValueImpl(nameX, nameY);
    }

    public boolean isValid() {
        Object[] names = this.getKeys();
        for (int i = 0; i < names.length; ++i) {
            for (int j = i + 1; j < names.length; ++j) {
                if (this.getValueImpl(names[i], names[j]) != null) continue;
                return false;
            }
        }
        return true;
    }

    public void removeValue(T nameX, T nameY) {
        Number num = this.getValueSimply(nameX, nameY);
        if (num == null) {
            T tmp = nameX;
            nameX = nameY;
            nameY = tmp;
            num = this.getValueSimply(nameX, nameY);
        }
        if (num != null) {
            this.nameset = null;
            Map<T, Number> valueMap = this.table.get(nameX);
            valueMap.remove(nameY);
            if (valueMap.size() == 0) {
                this.table.remove(nameX);
            }
        }
    }

    @Override
    public Iterator<Entry<T>> iterator() {
        return new TableIterator<T>(Collections.unmodifiableMap(this.table));
    }

    public void removeRow(T nameX) {
        this.table.remove(nameX);
        this.nameset = null;
    }

    public void removeColumn(T nameY) {
        for (Map<T, Number> valueMap : this.table.values()) {
            valueMap.remove(nameY);
        }
        this.nameset = null;
    }

    public int getRowCount() {
        return this.table.size();
    }

    public int getColumnCount(T nameX) {
        Map<T, Number> valueMap = this.table.get(nameX);
        int size = 0;
        if (valueMap != null) {
            size = valueMap.size();
        }
        return size;
    }

    public int getMaxColumnCount() {
        int size = 0;
        for (Map<T, Number> valueMap : this.table.values()) {
            if (size >= valueMap.size()) continue;
            size = valueMap.size();
        }
        return size;
    }

    private Number getValueImpl(Object nameX, Object nameY) {
        Number value = this.getValueSimply(nameX, nameY);
        if (value == null) {
            value = this.getValueSimply(nameY, nameX);
        }
        return value;
    }

    private Number getValueSimply(Object nameX, Object nameY) {
        Map<T, Number> valueMap = this.table.get(nameX);
        if (valueMap != null) {
            return valueMap.get(nameY);
        }
        return null;
    }

    private Set<T> constructNameset() {
        LinkedHashSet<T> nameset = new LinkedHashSet<T>();
        for (Map.Entry<T, Map<T, Number>> entry : this.table.entrySet()) {
            nameset.add(entry.getKey());
            for (Map.Entry<T, Number> subentry : entry.getValue().entrySet()) {
                nameset.add(subentry.getKey());
            }
        }
        return nameset;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TableIterator<T>
    implements Iterator<Entry<T>> {
        private Iterator<Map.Entry<T, Map<T, Number>>> iteratorX;
        private Iterator<Map.Entry<T, Number>> iteratorY;
        private Entry<T> next;
        private T x;

        public TableIterator(Map<T, Map<T, Number>> table) {
            this.iteratorX = table.entrySet().iterator();
            this.next = this.getNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Entry<T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Entry<T> n = this.next;
            this.next = this.getNext();
            return n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Entry<T> getNext() {
            Map.Entry<T, Object> entry;
            if (this.iteratorY == null || !this.iteratorY.hasNext()) {
                if (!this.iteratorX.hasNext()) {
                    return null;
                }
                entry = this.iteratorX.next();
                this.x = entry.getKey();
                this.iteratorY = ((Map)entry.getValue()).entrySet().iterator();
            }
            entry = this.iteratorY.next();
            return new Entry<T>(this.x, entry.getKey(), (Number)entry.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<T> {
        T x;
        T y;
        Number value;

        public Entry(T x, T y, Number value) {
            this.x = x;
            this.y = y;
            this.value = value;
        }

        public T getX() {
            return this.x;
        }

        public T getY() {
            return this.y;
        }

        public Number getValue() {
            return this.value;
        }
    }
}

