/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.ui.swing.actions;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import jp.sourceforge.talisman.mds.cluster.ClusteringAlgorithm;
import jp.sourceforge.talisman.mds.cluster.ClusteringParameter;
import jp.sourceforge.talisman.mds.cluster.HierarchicalClusteringParameter;
import jp.sourceforge.talisman.mds.cluster.NonHierarchicalClusteringParameter;
import jp.sourceforge.talisman.mds.distance.ClusterDistanceAlgorithm;
import jp.sourceforge.talisman.mds.distance.ItemDistanceAlgorithm;
import jp.sourceforge.talisman.mds.ui.swing.MdsPane;

public class ClusteringAction
extends AbstractAction {
    private static final long serialVersionUID = -4431502090699769330L;
    private MdsPane mds;

    public ClusteringAction(MdsPane mds) {
        super(mds.getMessages().get("clustering.label"));
        if (mds.getMessages().hasValue("clustering.tooltip")) {
            this.putValue("ShortDescription", mds.getMessages().get("clustering.tooltip"));
        }
        if (mds.getMessages().hasValue("clustering.icon")) {
            Icon icon = mds.getMessages().getIcon("clustering.icon");
            this.putValue("SmallIcon", icon);
        }
        this.mds = mds;
    }

    public void actionPerformed(ActionEvent e) {
        ClusteringSettingPane pane = new ClusteringSettingPane(this.mds);
        int flag = JOptionPane.showConfirmDialog(this.mds, pane, this.mds.getMessages().get("clustering.setting.title"), 2, 1);
        if (flag == 0) {
            ClusteringParameter param = null;
            try {
                param = this.createParameter(pane);
            }
            catch (IllegalArgumentException exception) {
                JOptionPane.showMessageDialog(pane, exception.getMessage(), this.mds.getMessages().get("title.illegal.argument"), 0);
            }
            if (param != null) {
                this.mds.clustering(pane.getClusteringAlgorithm(), param);
            }
        }
    }

    private ClusteringParameter createParameter(ClusteringSettingPane pane) {
        ClusteringAlgorithm algorithm = pane.getClusteringAlgorithm();
        ClusteringParameter param = null;
        switch (algorithm) {
            case EXCHANGE_METHOD: 
            case PARALLEL_HCM: 
            case SEQUENTIAL_HCM: {
                param = new NonHierarchicalClusteringParameter(pane.getClusterSize());
                param.setDistanceCalculator(pane.getItemDistanceCalculatorAlgorithm());
                break;
            }
            case HIERARCHICAL_METHOD: 
            case LANCE_AND_WILLIAMS_METHOD: {
                HierarchicalClusteringParameter hcParam = new HierarchicalClusteringParameter(pane.getClusterSize());
                hcParam.setDistanceCalculator(pane.getItemDistanceCalculatorAlgorithm());
                hcParam.setClusterDistanceCalculator(pane.getClusterDistanceCalculatorAlgorithm());
                param = hcParam;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown algorithm: " + (Object)((Object)algorithm));
            }
        }
        return param;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClusteringSettingPane
    extends JPanel {
        private static final long serialVersionUID = 4661816651445878479L;
        private MdsPane mds;
        private JFormattedTextField text;
        private JComboBox itemDistanceCombo;
        private JComboBox clusteringMethodCombo;
        private JComboBox clusterDistanceCombo;
        private Map<ClusteringAlgorithm, String> cAlgorithms = new HashMap<ClusteringAlgorithm, String>();
        private Map<ItemDistanceAlgorithm, String> idAlgorithms = new HashMap<ItemDistanceAlgorithm, String>();
        private Map<ClusterDistanceAlgorithm, String> cdAlgorithms = new HashMap<ClusterDistanceAlgorithm, String>();

        public ClusteringSettingPane(MdsPane mds) {
            this.mds = mds;
            this.clusteringMethodCombo = this.createCombo(ClusteringAlgorithm.values(), "ca.label.", this.cAlgorithms);
            this.clusteringMethodCombo.setBorder(new TitledBorder(mds.getMessages().get("clusteringalgorithm.label")));
            this.itemDistanceCombo = this.createCombo(ItemDistanceAlgorithm.values(), "ida.label.", this.idAlgorithms);
            this.itemDistanceCombo.setBorder(new TitledBorder(mds.getMessages().get("itemdistancecalculator.label")));
            this.clusterDistanceCombo = this.createCombo(ClusterDistanceAlgorithm.values(), "cda.label.", this.cdAlgorithms);
            this.clusterDistanceCombo.setBorder(new TitledBorder(mds.getMessages().get("clusterdistancecalculator.label")));
            this.text = new JFormattedTextField();
            this.text.setBorder(new TitledBorder(mds.getMessages().get("clustering.cluster.size")));
            this.text.setValue(new Integer(3));
            this.setLayout(new GridLayout(4, 1));
            this.add(this.clusteringMethodCombo);
            this.add(this.itemDistanceCombo);
            this.add(this.clusterDistanceCombo);
            this.add(this.text);
        }

        public ItemDistanceAlgorithm getItemDistanceCalculatorAlgorithm() {
            return this.getAlgorithm(this.idAlgorithms, this.itemDistanceCombo);
        }

        public ClusteringAlgorithm getClusteringAlgorithm() {
            return this.getAlgorithm(this.cAlgorithms, this.clusteringMethodCombo);
        }

        public ClusterDistanceAlgorithm getClusterDistanceCalculatorAlgorithm() {
            return this.getAlgorithm(this.cdAlgorithms, this.clusterDistanceCombo);
        }

        public int getClusterSize() {
            return (Integer)this.text.getValue();
        }

        private <T> T getAlgorithm(Map<T, String> map, JComboBox combo) {
            String label = (String)combo.getSelectedItem();
            T algorithm = null;
            for (Map.Entry<T, String> entry : map.entrySet()) {
                if (!label.equals(entry.getValue())) continue;
                algorithm = entry.getKey();
                break;
            }
            return algorithm;
        }

        private <T extends Enum<?>> JComboBox createCombo(T[] algorithms, String prefix, Map<T, String> map) {
            JComboBox<String> combo = new JComboBox<String>();
            for (T algorithm : algorithms) {
                String label = this.mds.getMessages().get(prefix + ((Enum)algorithm).name());
                map.put(algorithm, label);
                combo.addItem(label);
            }
            return combo;
        }
    }
}

