/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.ui.swing;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import jp.sourceforge.talisman.i18n.Messages;
import jp.sourceforge.talisman.i18n.ResourceNotFoundException;
import jp.sourceforge.talisman.mds.CalculationFailException;
import jp.sourceforge.talisman.mds.Item;
import jp.sourceforge.talisman.mds.MdsMethod;
import jp.sourceforge.talisman.mds.Table;
import jp.sourceforge.talisman.mds.cluster.Cluster;
import jp.sourceforge.talisman.mds.cluster.ClusteringAlgorithm;
import jp.sourceforge.talisman.mds.cluster.ClusteringMethod;
import jp.sourceforge.talisman.mds.cluster.ClusteringMethodFactory;
import jp.sourceforge.talisman.mds.cluster.ClusteringParameter;
import jp.sourceforge.talisman.mds.cluster.ParameterTypeMismatchException;
import jp.sourceforge.talisman.mds.ui.ColorManager;
import jp.sourceforge.talisman.mds.ui.MdsGraphSetting;
import jp.sourceforge.talisman.mds.ui.mark.DrawerFactory;
import jp.sourceforge.talisman.mds.ui.swing.ItemsOpenEvent;
import jp.sourceforge.talisman.mds.ui.swing.ItemsOpenListener;
import jp.sourceforge.talisman.mds.ui.swing.ItemsSelectionEvent;
import jp.sourceforge.talisman.mds.ui.swing.ItemsSelectionListener;
import jp.sourceforge.talisman.mds.ui.swing.MdsItem;
import jp.sourceforge.talisman.mds.ui.swing.PaintedCluster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MdsPane
extends JTextPane
implements Scrollable {
    private static final Dimension MINIMUM_SIZE = new Dimension(100, 100);
    private static final Dimension PREFERRED_SIZE = new Dimension(300, 300);
    private static final long serialVersionUID = -7277586999609831212L;
    private MdsMethod<?> mds;
    private MdsGraphSetting setting;
    private Messages messages;
    private List<ItemsOpenListener> openListeners = new ArrayList<ItemsOpenListener>();
    private List<ItemsSelectionListener> selectionListeners = new ArrayList<ItemsSelectionListener>();
    private ColorManager colorManager = new ColorManager();
    private List<PaintedCluster> clusters = new ArrayList<PaintedCluster>();
    private List<MdsItem> plotItems = new ArrayList<MdsItem>();
    private Rectangle2D drawArea;
    private AffineTransform transform = new AffineTransform();
    private int zoomRatio = 100;
    private Dimension baseSize = PREFERRED_SIZE;
    private Rectangle2D selectedArea = null;
    private boolean selectStart = false;
    private Point2D startPoint = null;
    private PropertyChangeListener propertyChangeListener;

    public MdsPane(MdsMethod<?> mds) throws ResourceNotFoundException {
        this(mds, new MdsGraphSetting());
    }

    public MdsPane(MdsMethod<?> mds, MdsGraphSetting setting) throws ResourceNotFoundException {
        this(mds, setting, new Messages("jp.sourceforge.talisman.mds.ui.MdsViewerPane"));
    }

    public MdsPane(MdsMethod<?> mds, MdsGraphSetting setting, Messages messages) throws ResourceNotFoundException {
        this.setMessages(messages);
        this.setMdsMethod(mds);
        this.setGraphSetting(setting);
        this.initLayout();
        this.initListener();
    }

    public void setMessages(Messages messages) throws ResourceNotFoundException {
        if (messages == null) {
            throw new ResourceNotFoundException();
        }
        this.messages = messages;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public void addItemsOpenListener(ItemsOpenListener listener) {
        this.openListeners.add(listener);
    }

    public void addItemsSelectionListener(ItemsSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void clearTransform() {
        this.selectedArea = null;
        this.transform.setToIdentity();
        this.plotItems.clear();
        this.setSelection(null);
        this.zoomRatio = 100;
        this.repaint();
    }

    public Item[] getItems() {
        return this.mds.getItems();
    }

    public MdsGraphSetting getGraphSetting() {
        return this.setting;
    }

    public MdsMethod getMdsMethod() {
        return new MdsMethod(this.mds);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public Item[] getSelectedItems() {
        ArrayList<Item> list = new ArrayList<Item>();
        for (MdsItem mdsc : this.plotItems) {
            if (!mdsc.isSelected()) continue;
            list.add(this.mds.getItem(mdsc.getName()));
        }
        return list.toArray(new Item[list.size()]);
    }

    public Table getTable() {
        return this.mds.getTable();
    }

    public int getZoomRatio() {
        return this.zoomRatio;
    }

    public void clustering(ClusteringAlgorithm algorithm, ClusteringParameter parameter) {
        this.mds.setLimit(2);
        this.plotItems.clear();
        this.clusters.clear();
        try {
            ClusteringMethod method = ClusteringMethodFactory.getInstance().getAlgorithm(algorithm, parameter);
            Cluster[] clusterList = method.clustering(this.mds.getItems());
            int index = 0;
            for (Cluster c : clusterList) {
                this.clusters.add(new PaintedCluster(c, this.colorManager.get(index)));
                ++index;
            }
            this.repaint();
        }
        catch (ParameterTypeMismatchException e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
        }
        catch (CalculationFailException e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
        }
    }

    public void mirrorX() {
        this.selectedArea = null;
        this.transform.preConcatenate(new AffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        this.plotItems.clear();
        this.setSelection(null);
        this.repaint();
    }

    public void mirrorY() {
        this.selectedArea = null;
        this.transform.preConcatenate(new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f));
        this.plotItems.clear();
        this.setSelection(null);
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D g = (Graphics2D)graphics;
        MdsGraphSetting mgs = this.getGraphSetting();
        if (this.drawArea == null) {
            this.drawArea = this.calculateDrawArea(mgs);
        }
        Dimension d = this.getPreferredSize();
        Color initcolor = g.getColor();
        g.setColor(this.setting.getBackground());
        g.fillRect(0, 0, d.width, d.height);
        if (mgs.isShowGrid()) {
            this.paintGrid(g, mgs);
        }
        if (mgs.isShowSubGrid()) {
            this.paintSubGrid(g, mgs);
        }
        if (this.plotItems.size() == 0) {
            Item[] items = this.mds.getItems();
            double max = this.calculateMax(items);
            for (int i = 0; i < items.length; ++i) {
                this.plotItems.add(this.calculateItem(items[i], max));
            }
        }
        if (this.clusters.size() == 0) {
            g.setColor(this.setting.getForeground());
        }
        for (MdsItem c : this.plotItems) {
            if (this.clusters.size() > 0) {
                Item originalItem = c.getOriginal();
                for (PaintedCluster pc : this.clusters) {
                    if (!pc.isContain(originalItem)) continue;
                    g.setColor(pc.getColor());
                    break;
                }
            }
            this.paintItem(g, mgs, c);
        }
        if (this.selectedArea != null) {
            g.setColor(this.setting.getSelectedAreaColor());
            g.fill(this.selectedArea);
        }
        g.setColor(initcolor);
    }

    public void removeItemsOpenListener(ItemsOpenListener listener) {
        this.openListeners.add(listener);
    }

    public void removeItemsSelectionListener(ItemsSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void rotate(double theta) {
        this.transform.preConcatenate(AffineTransform.getRotateInstance(theta));
        this.plotItems.clear();
        this.selectedArea = null;
        this.setSelection(null);
        this.repaint();
    }

    public void setGraphSetting(MdsGraphSetting setting) {
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    MdsPane.this.repaint();
                }
            };
        }
        if (setting == null) {
            throw new NullPointerException();
        }
        if (this.setting != null) {
            this.setting.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.setting = setting;
        setting.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void setMdsMethod(MdsMethod<?> mds) {
        if (mds == null) {
            throw new NullPointerException();
        }
        this.mds = mds;
        this.transform.setToIdentity();
        this.plotItems.clear();
    }

    @Override
    public void setPreferredSize(Dimension d) {
        this.baseSize = d;
        this.setZoomRatio(this.zoomRatio);
    }

    public void setTable(Table table) {
        if (table == null) {
            throw new NullPointerException();
        }
        if (!table.isValid()) {
            throw new IllegalStateException();
        }
        this.mds.setTable(table);
    }

    public void setZoomRatio(int newZoomRatio) {
        if (newZoomRatio < 0) {
            throw new IllegalArgumentException("positive value required: " + newZoomRatio);
        }
        this.zoomRatio = newZoomRatio;
        this.selectedArea = null;
        this.drawArea = null;
        this.plotItems.clear();
        super.setPreferredSize(new Dimension((int)(this.baseSize.getWidth() / 100.0 * (double)this.zoomRatio), (int)(this.baseSize.getHeight() / 100.0 * (double)this.zoomRatio)));
        if (SwingUtilities.getRootPane(this) != null) {
            SwingUtilities.getRootPane(this).repaint();
        }
        this.updateUI();
    }

    public void transform(AffineTransform tx) {
        this.transform.preConcatenate(tx);
        this.plotItems.clear();
        this.selectedArea = null;
        this.setSelection(null);
        this.repaint();
    }

    private MdsItem calculateItem(Item c, double max) {
        double x = c.get(0).doubleValue();
        double y = c.get(1).doubleValue();
        double w = this.drawArea.getWidth();
        double h = this.drawArea.getHeight();
        Point2D point = new Point2D.Double(x * (w / 2.0 - 5.0) / max, y * (h / 2.0 - 5.0) / max);
        point = this.transform.transform(point, null);
        MdsItem newItem = new MdsItem(c);
        double ox = this.drawArea.getX() + this.drawArea.getWidth() / 2.0;
        double oy = this.drawArea.getY() + this.drawArea.getHeight() / 2.0;
        newItem.set(0, ox + point.getX());
        newItem.set(1, oy + point.getY());
        newItem.setDrawer(DrawerFactory.getInstance().create(c.getGroupId()));
        return newItem;
    }

    private Rectangle2D calculateDrawArea(MdsGraphSetting mgs) {
        double height;
        double h;
        Dimension size = this.getPreferredSize();
        double width = size.getWidth();
        double w = width;
        if (w < (h = (height = size.getHeight()))) {
            h = w;
        } else {
            w = h;
        }
        Rectangle2D.Double drawArea = new Rectangle2D.Double(width / 2.0 - w / 2.0, height / 2.0 - h / 2.0, w - 1.0, h - 1.0);
        return drawArea;
    }

    private double calculateMax(Item[] items) {
        double max = 0.0;
        for (int i = 0; i < items.length; ++i) {
            double d1 = Math.abs(items[i].get(0).doubleValue());
            double d2 = Math.abs(items[i].get(1).doubleValue());
            if (max < d1) {
                max = d1;
            }
            if (!(max < d2)) continue;
            max = d2;
        }
        return max;
    }

    private Rectangle2D calculateSelectedArea(Point2D p1, Point2D p2) {
        double x = p1.getX();
        double y = p1.getY();
        if (x > p2.getX()) {
            x = p2.getX();
        }
        if (y > p2.getY()) {
            y = p2.getY();
        }
        return new Rectangle2D.Double(x, y, Math.abs(p1.getX() - p2.getX()), Math.abs(p1.getY() - p2.getY()));
    }

    private void fireEvent(ItemsOpenEvent e) {
        for (ItemsOpenListener listener : this.openListeners) {
            listener.itemOpened(e);
        }
    }

    private void fireEvent(ItemsSelectionEvent e) {
        for (ItemsSelectionListener listener : this.selectionListeners) {
            listener.valueChanged(e);
        }
    }

    private void initLayout() {
        this.setCursor(Cursor.getDefaultCursor());
        this.setMinimumSize(MINIMUM_SIZE);
        this.setPreferredSize(PREFERRED_SIZE);
    }

    private void initListener() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                MdsPane.this.selectedArea = null;
                MdsPane.this.drawArea = null;
                MdsPane.this.plotItems.clear();
                MdsPane.this.repaint();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    Item[] c = MdsPane.this.getSelectedItems();
                    if (MdsPane.this.selectedArea != null && c.length > 0) {
                        MdsPane.this.fireEvent(new ItemsOpenEvent(MdsPane.this, c));
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Point2D.Double currentPoint = new Point2D.Double(e.getX(), e.getY());
                    ArrayList<MdsItem> items = new ArrayList<MdsItem>();
                    for (MdsItem mdsc : MdsPane.this.plotItems) {
                        Point2D.Double p = new Point2D.Double(mdsc.get(0).doubleValue(), mdsc.get(1).doubleValue());
                        mdsc.setSelected(Math.abs(((Point2D)currentPoint).getX() - ((Point2D)p).getX()) < 2.0 && Math.abs(((Point2D)currentPoint).getY() - ((Point2D)p).getY()) < 2.0);
                        if (!mdsc.isSelected()) continue;
                        items.add(mdsc);
                    }
                    MdsPane.this.fireEvent(new ItemsOpenEvent(MdsPane.this, items.toArray(new MdsItem[items.size()])));
                } else {
                    MdsPane.this.selectedArea = null;
                    MdsPane.this.setSelection(null);
                    MdsPane.this.repaint();
                }
            }

            public void mousePressed(MouseEvent e) {
                if (MdsPane.this.setting.isSelectable()) {
                    MdsPane.this.selectedArea = null;
                    MdsPane.this.selectStart = true;
                    MdsPane.this.startPoint = new Point2D.Double(e.getX(), e.getY());
                }
            }

            public void mouseReleased(MouseEvent e) {
                MdsPane.this.selectStart = false;
                MdsPane.this.setSelection(MdsPane.this.selectedArea);
                MdsPane.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                if (MdsPane.this.selectStart) {
                    Point2D.Double currentPoint = new Point2D.Double(e.getX(), e.getY());
                    MdsPane.this.selectedArea = MdsPane.this.calculateSelectedArea(MdsPane.this.startPoint, currentPoint);
                    MdsPane.this.setSelection(MdsPane.this.selectedArea);
                    MdsPane.this.repaint();
                }
            }
        });
    }

    private void paintItem(Graphics2D g, MdsGraphSetting mgs, MdsItem c) {
        double x = c.get(0).doubleValue();
        double y = c.get(1).doubleValue();
        c.paint(g);
        if (mgs.isShowLabels()) {
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D r = fm.getStringBounds(c.getName(), g);
            g.drawString(c.getName(), (float)(x - r.getWidth() / 2.0), (float)(y - r.getHeight()));
        }
    }

    private void paintGrid(Graphics2D g, MdsGraphSetting mgs) {
        g.setColor(this.setting.getGridColor());
        double x = this.drawArea.getX();
        double y = this.drawArea.getY();
        double w = this.drawArea.getWidth();
        double h = this.drawArea.getHeight();
        g.draw(this.drawArea);
        g.draw(new Line2D.Double(x, y + h / 2.0, x + w, y + h / 2.0));
        g.draw(new Line2D.Double(x + w / 2.0, y, x + w / 2.0, y + h));
    }

    private void paintSubGrid(Graphics2D g, MdsGraphSetting mgs) {
        g.setColor(this.setting.getSubGridColor());
        double x = this.drawArea.getX();
        double y = this.drawArea.getY();
        double w = this.drawArea.getWidth();
        double h = this.drawArea.getHeight();
        double stepX = w / 8.0;
        double stepY = h / 8.0;
        for (int i = 1; i < 8; ++i) {
            if (i == 4) continue;
            g.draw(new Line2D.Double(x, y + stepY * (double)i, x + w, y + stepY * (double)i));
            g.draw(new Line2D.Double(x + stepX * (double)i, y, x + stepX * (double)i, y + h));
        }
    }

    private void setSelection(Rectangle2D rect) {
        boolean eventFlag = false;
        ArrayList<Item> list = new ArrayList<Item>();
        for (MdsItem mdsc : this.plotItems) {
            boolean flag = mdsc.isSelected();
            Point2D.Double p = new Point2D.Double(mdsc.get(0).doubleValue(), mdsc.get(1).doubleValue());
            mdsc.setSelected(rect != null && rect.contains(p));
            if (mdsc.isSelected()) {
                list.add(this.mds.getItem(mdsc.getName()));
            }
            if (flag == mdsc.isSelected()) continue;
            eventFlag = true;
        }
        if (eventFlag) {
            this.fireEvent(new ItemsSelectionEvent(this, list.toArray(new Item[list.size()])));
        }
    }
}

