/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.distance;

import jp.sourceforge.talisman.mds.distance.AbstractItemDistanceCalculator;
import jp.sourceforge.talisman.mds.distance.ItemDistanceAlgorithm;

public class SquaredEuclideanItemDistanceCalculator
extends AbstractItemDistanceCalculator {
    public ItemDistanceAlgorithm getAlgorithm() {
        return ItemDistanceAlgorithm.SQUARED_EUCLIDEAN_DISTANCE;
    }

    public double calculate(double[] x, double[] y) {
        this.validateArguments(x, y);
        double value = 0.0;
        for (int i = 0; i < x.length; ++i) {
            if (Double.isNaN(x[i]) || Double.isNaN(y[i])) continue;
            value += (x[i] - y[i]) * (x[i] - y[i]);
        }
        return Math.sqrt(value);
    }
}

