/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.distance;

import jp.sourceforge.talisman.mds.Item;
import jp.sourceforge.talisman.mds.distance.ItemDistanceAlgorithm;
import jp.sourceforge.talisman.mds.distance.ItemDistanceCalculator;

abstract class AbstractItemDistanceCalculator
implements ItemDistanceCalculator {
    AbstractItemDistanceCalculator() {
    }

    public double calculate(Item x, Item y) {
        int lenX = x.getDimension();
        int lenY = y.getDimension();
        int length = lenX;
        if (lenX > lenY) {
            length = lenY;
        }
        return this.calculate(x, y, length);
    }

    public double calculate(Item x, Item y, int length) {
        double[] xarray = new double[length];
        double[] yarray = new double[length];
        for (int i = 0; i < length; ++i) {
            xarray[i] = x.get(i).doubleValue();
            yarray[i] = y.get(i).doubleValue();
        }
        return this.calculate(xarray, yarray);
    }

    public abstract double calculate(double[] var1, double[] var2);

    public abstract ItemDistanceAlgorithm getAlgorithm();

    protected boolean validateArguments(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("difference array size: " + x.length + " != " + y.length);
        }
        return true;
    }
}

