/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.cluster;

import jp.sourceforge.talisman.mds.Item;
import jp.sourceforge.talisman.mds.cluster.Cluster;
import jp.sourceforge.talisman.mds.cluster.ClusteringParameter;
import jp.sourceforge.talisman.mds.cluster.NonHierarchicalClusteringMethod;
import jp.sourceforge.talisman.mds.cluster.NonHierarchicalClusteringParameter;
import jp.sourceforge.talisman.mds.cluster.ParameterTypeMismatchException;
import jp.sourceforge.talisman.mds.distance.ItemDistanceCalculator;

class SequentialHardCMeanMethod
extends NonHierarchicalClusteringMethod {
    public SequentialHardCMeanMethod(ClusteringParameter param) throws ParameterTypeMismatchException {
        super(param);
        if (!(param instanceof NonHierarchicalClusteringParameter)) {
            throw new ParameterTypeMismatchException("NonHierarchicalClusteringParameter is required.");
        }
    }

    public SequentialHardCMeanMethod(NonHierarchicalClusteringParameter param) {
        super(param);
    }

    protected Cluster[] doClustering(Item[] items, ClusteringParameter initParam) {
        NonHierarchicalClusteringParameter param = (NonHierarchicalClusteringParameter)initParam;
        Cluster[] clusters = this.initClusters(items, param);
        ItemDistanceCalculator calculator = param.getDistanceCalculator();
        boolean flag = true;
        while (flag) {
            flag = false;
            for (int i = 0; i < items.length; ++i) {
                int current = -1;
                int target = -1;
                double length = Double.MAX_VALUE;
                for (int j = 0; j < clusters.length; ++j) {
                    double distance;
                    if (clusters[j].isContain(items[i])) {
                        current = j;
                    }
                    if (!(length > (distance = calculator.calculate(clusters[j].getMedian(), items[i])))) continue;
                    length = distance;
                    target = j;
                }
                clusters[current].removeItem(items[i]);
                clusters[target].addItem(items[i]);
                flag = flag || current != target;
            }
        }
        return clusters;
    }
}

