package jp.sourceforge.talisman.fmv.ui;

/*
 * $Id: FmvGraphSetting.java 148 2008-07-15 07:34:55Z tama3 $
 */

import java.awt.Color;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Configuration bean of memory graph.
 * 
 * @author Haruaki Tamada
 * @version $Revision: 148 $
 */
public class FmvGraphSetting implements Serializable{
    private static final long serialVersionUID = 8786669993882472344L;

    private boolean showConfigurationButton;
    private boolean showDetails;
    private boolean showGrid;
    private boolean showSubGrid;
    private boolean showGraphLabel;
    private boolean fill;
    private int interval;
    private Color stringColor;
    private Color backgroundColor;
    private Color foregroundColor;
    private Color gridColor;
    private Color subGridColor;
    private Dimension minimumSize;
    private int historyCount;
    private int stepCount;

    private List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();

    /**
     * self constructor.
     * copy data from given setting exclude listeners.
     */
    public FmvGraphSetting(FmvGraphSetting fgs){
        setShowConfigurationButton(fgs.isShowConfigurationButton());
        setShowDetails(fgs.isShowDetails());
        setShowGrid(fgs.isShowGrid());
        setShowGraphLabel(fgs.isShowGraphLabel());
        setFill(fgs.isFill());
        setHistoryCount(fgs.getHistoryCount());
        setStepCount(fgs.getStepCount());
        setInterval(fgs.getInterval());
        setStringColor(fgs.getStringColor());
        setBackgroundColor(fgs.getBackgroundColor());
        setForegroundColor(fgs.getForegroundColor());
        setGridColor(fgs.getGridColor());
        setSubGridColor(fgs.getSubGridColor());
        setMinimumSize(getMinimumSize());
    }

    /**
     * default constructor.
     */
    public FmvGraphSetting(){
        setShowConfigurationButton(true);
        setShowDetails(true);
        setShowGrid(true);
        setShowSubGrid(true);
        setShowGraphLabel(true);
        setFill(false);
        setHistoryCount(400);
        setStepCount(300);
        setInterval(300);
        setStringColor(Color.BLACK);
        setBackgroundColor(Color.WHITE);
        setForegroundColor(Color.RED);
        setGridColor(Color.GRAY);
        setSubGridColor(Color.LIGHT_GRAY);
        setMinimumSize(new Dimension(300, 300));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener){
        listeners.add(listener);
    }

    public Color getBackgroundColor(){
        return backgroundColor;
    }

    public Color getForegroundColor(){
        return foregroundColor;
    }

    public Color getGridColor(){
        return gridColor;
    }

    public int getHistoryCount(){
        return historyCount;
    }

    public int getInterval(){
        return interval;
    }

    public Dimension getMinimumSize(){
        return minimumSize;
    }

    public int getStepCount(){
        return stepCount;
    }

    public Color getStringColor(){
        return stringColor;
    }

    public Color getSubGridColor(){
        return subGridColor;
    }

    public boolean isFill(){
        return fill;
    }

    public boolean isShowConfigurationButton(){
        return showConfigurationButton;
    }

    public boolean isShowDetails(){
        return showDetails;
    }

    public boolean isShowGraphLabel(){
        return showGraphLabel;
    }

    public boolean isShowGrid(){
        return showGrid;
    }

    public boolean isShowSubGrid(){
        return showSubGrid;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener){
        listeners.remove(listener);
    }

    public void setBackgroundColor(Color backgroundColor){
        if(backgroundColor == null){
            throw new NullPointerException();
        }
        Color c = this.backgroundColor;
        this.backgroundColor = backgroundColor;
        fireEvent(new PropertyChangeEvent(this, "background_color", c, backgroundColor));
    }

    public void setFill(boolean fill){
        Boolean b = new Boolean(this.fill);
        this.fill = fill;
        fireEvent(new PropertyChangeEvent(this, "fill", b, fill));
    }

    public void setForegroundColor(Color foregroundColor){
        if(foregroundColor == null){
            throw new NullPointerException();
        }
        Color c = this.foregroundColor;
        this.foregroundColor = foregroundColor;
        fireEvent(new PropertyChangeEvent(this, "foreground_color", c, foregroundColor));
    }

    public void setGridColor(Color gridColor){
        if(gridColor == null){
            throw new NullPointerException();
        }
        Color c = this.gridColor;
        this.gridColor = gridColor;
        fireEvent(new PropertyChangeEvent(this, "grid_color", c, gridColor));
    }

    public void setHistoryCount(int historyCount){
        if(historyCount < 0){
            throw new IllegalArgumentException("positive value required: " + historyCount);
        }
        Integer i = new Integer(this.historyCount);
        this.historyCount = historyCount;
        fireEvent(new PropertyChangeEvent(this, "history_count", i, historyCount));
    }

    public void setInterval(int interval){
        if(interval < 0){
            throw new IllegalArgumentException("positve value required: " + interval);
        }
        Integer i = new Integer(interval);
        this.interval = interval;
        fireEvent(new PropertyChangeEvent(this, "interval", i, interval));
    }

    public void setMinimumSize(Dimension minimumSize){
        if(minimumSize == null){
            throw new NullPointerException();
        }
        Dimension d = this.minimumSize;
        this.minimumSize = minimumSize;
        fireEvent(new PropertyChangeEvent(this, "minimum_size", d, minimumSize));
    }

    public void setShowConfigurationButton(boolean showConfigurationButton){
        Boolean b = new Boolean(this.showConfigurationButton);
        this.showConfigurationButton = showConfigurationButton;
        fireEvent(new PropertyChangeEvent(this, "show_configuration_button", b, showConfigurationButton));
    }

    public void setShowDetails(boolean showDetails){
        Boolean b = new Boolean(this.showDetails);
        this.showDetails = showDetails;
        fireEvent(new PropertyChangeEvent(this, "show_details", b, showDetails));
    }

    public void setShowGraphLabel(boolean showGraphLabel){
        Boolean b = new Boolean(this.showGraphLabel);
        this.showGraphLabel = showGraphLabel;
        fireEvent(new PropertyChangeEvent(this, "show_label", b, showGraphLabel));
    }

    public void setShowGrid(boolean showGrid){
        Boolean b = new Boolean(this.showGrid);
        this.showGrid = showGrid;
        fireEvent(new PropertyChangeEvent(this, "show_grid", b, showGrid));
    }

    public void setShowSubGrid(boolean showSubGrid){
        Boolean b = new Boolean(this.showSubGrid);
        this.showSubGrid = showSubGrid;
        fireEvent(new PropertyChangeEvent(this, "show_subgrid", b, showSubGrid));
    }

    public void setStepCount(int stepCount){
        if(stepCount < 0){
            throw new IllegalArgumentException("positive value required: " + stepCount);
        }
        Integer i = new Integer(stepCount);
        this.stepCount = stepCount;
        fireEvent(new PropertyChangeEvent(this, "step_count", i, stepCount));
    }

    public void setStringColor(Color stringColor){
        if(stringColor == null){
            throw new NullPointerException();
        }
        Color c = this.stringColor;
        this.stringColor = stringColor;
        fireEvent(new PropertyChangeEvent(this, "string_color", c, stringColor));
    }

    public void setSubGridColor(Color subGridColor){
        if(subGridColor == null){
            throw new NullPointerException();
        }
        Color c = this.subGridColor;
        this.subGridColor = subGridColor;
        fireEvent(new PropertyChangeEvent(this, "subgrid_color", c, subGridColor));
    }

    protected void fireEvent(PropertyChangeEvent e){
        for(PropertyChangeListener listener: listeners){
            listener.propertyChange(e);
        }
    }
 }
