package jp.sourceforge.talisman.fmv;

/*
 * $Id: MemoryState.java 148 2008-07-15 07:34:55Z tama3 $
 */

/**
 * Memory status bean.
 * 
 * @author Haruaki Tamada
 * @version $Revision: 148 $
 */
public class MemoryState{
    private long free;
    private long total;
    private long max;

    public MemoryState(long free, long total, long max){
        this.free = free;
        this.total = total;
        this.max = max;
    }

    public MemoryState(){
        Runtime runtime = Runtime.getRuntime();
        this.free = runtime.freeMemory();
        this.total = runtime.totalMemory();
        this.max = runtime.maxMemory();
    }

    public boolean isMaxLimitted(){
        return max != Long.MAX_VALUE;
    }

    public long getFreeMemory(){
        return free;
    }

    public long getTotalMemory(){
        return total;
    }

    public long getMaxMemory(){
        return max;
    }

    public long getUsedMemory(){
        return getTotalMemory() - getFreeMemory();
    }

    public double getUsedMemoryRatio(){
        return (double)getUsedMemory() / getTotalMemory();
    }

    public String toString(){
        return String.format("free: %d/%d, max: %s (%s)", getFreeMemory(), getTotalMemory(), getMaxMemory(), isMaxLimitted());
    }
}
