package jp.sourceforge.talisman.fmv;

/*
 * $Id: TimeredMemoryStateNotifier.java 148 2008-07-15 07:34:55Z tama3 $
 */

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.Timer;

/**
 * Timered {@link MemoryStateNotifier <code>MemoryStateNotifier</code>}.
 * 
 * @author Haruaki Tamada
 * @version $Revision: 148 $
 */
public class TimeredMemoryStateNotifier extends MemoryStateNotifier{
    public static final int DEFAULT_INTERVAL = 300;

    private Timer timer;
    private List<RunningListener> listeners = new ArrayList<RunningListener>();

    public TimeredMemoryStateNotifier(){
        this(DEFAULT_INTERVAL);
    }

    public TimeredMemoryStateNotifier(int initialInterval){
        timer = new Timer(initialInterval, new ActionListener(){
            public void actionPerformed(ActionEvent e){
                informAll();
            }
        });
        timer.setRepeats(true);
    }

    public void addRunningListener(RunningListener listener){
        listeners.add(listener);
    }

    public void removeRunningListener(RunningListener listener){
        listeners.remove(listener);
    }

    public void start(){
        if(!isRunning()){
            timer.start();
            for(RunningListener listener: listeners){
                listener.timerStarted();
            }
        }
    }

    public void stop(){
        if(isRunning()){
            timer.stop();
            for(RunningListener listener: listeners){
                listener.timerStopped();
            }
        }
    }

    public boolean isRunning(){
        return timer.isRunning();
    }

    public int getInterval(){
        return timer.getDelay();
    }

    public void setInterval(int interval){
        timer.setDelay(interval);
    }
}
