/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.fmv.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class FmvGraphSetting
implements Serializable {
    private static final long serialVersionUID = 8786669993882472344L;
    private boolean showConfigurationButton;
    private boolean showDetails;
    private boolean showGrid;
    private boolean showSubGrid;
    private boolean showGraphLabel;
    private boolean fill;
    private int interval;
    private Color stringColor;
    private Color backgroundColor;
    private Color foregroundColor;
    private Color gridColor;
    private Color subGridColor;
    private Dimension minimumSize;
    private int historyCount;
    private int stepCount;
    private List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();

    public FmvGraphSetting(FmvGraphSetting fgs) {
        this.setShowConfigurationButton(fgs.isShowConfigurationButton());
        this.setShowDetails(fgs.isShowDetails());
        this.setShowGrid(fgs.isShowGrid());
        this.setShowGraphLabel(fgs.isShowGraphLabel());
        this.setFill(fgs.isFill());
        this.setHistoryCount(fgs.getHistoryCount());
        this.setStepCount(fgs.getStepCount());
        this.setInterval(fgs.getInterval());
        this.setStringColor(fgs.getStringColor());
        this.setBackgroundColor(fgs.getBackgroundColor());
        this.setForegroundColor(fgs.getForegroundColor());
        this.setGridColor(fgs.getGridColor());
        this.setSubGridColor(fgs.getSubGridColor());
        this.setMinimumSize(this.getMinimumSize());
    }

    public FmvGraphSetting() {
        this.setShowConfigurationButton(true);
        this.setShowDetails(true);
        this.setShowGrid(true);
        this.setShowSubGrid(true);
        this.setShowGraphLabel(true);
        this.setFill(false);
        this.setHistoryCount(400);
        this.setStepCount(300);
        this.setInterval(300);
        this.setStringColor(Color.BLACK);
        this.setBackgroundColor(Color.WHITE);
        this.setForegroundColor(Color.RED);
        this.setGridColor(Color.GRAY);
        this.setSubGridColor(Color.LIGHT_GRAY);
        this.setMinimumSize(new Dimension(300, 300));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public int getHistoryCount() {
        return this.historyCount;
    }

    public int getInterval() {
        return this.interval;
    }

    public Dimension getMinimumSize() {
        return this.minimumSize;
    }

    public int getStepCount() {
        return this.stepCount;
    }

    public Color getStringColor() {
        return this.stringColor;
    }

    public Color getSubGridColor() {
        return this.subGridColor;
    }

    public boolean isFill() {
        return this.fill;
    }

    public boolean isShowConfigurationButton() {
        return this.showConfigurationButton;
    }

    public boolean isShowDetails() {
        return this.showDetails;
    }

    public boolean isShowGraphLabel() {
        return this.showGraphLabel;
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public boolean isShowSubGrid() {
        return this.showSubGrid;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void setBackgroundColor(Color backgroundColor) {
        if (backgroundColor == null) {
            throw new NullPointerException();
        }
        Color c = this.backgroundColor;
        this.backgroundColor = backgroundColor;
        this.fireEvent(new PropertyChangeEvent(this, "background_color", c, backgroundColor));
    }

    public void setFill(boolean fill) {
        Boolean b = new Boolean(this.fill);
        this.fill = fill;
        this.fireEvent(new PropertyChangeEvent(this, "fill", b, fill));
    }

    public void setForegroundColor(Color foregroundColor) {
        if (foregroundColor == null) {
            throw new NullPointerException();
        }
        Color c = this.foregroundColor;
        this.foregroundColor = foregroundColor;
        this.fireEvent(new PropertyChangeEvent(this, "foreground_color", c, foregroundColor));
    }

    public void setGridColor(Color gridColor) {
        if (gridColor == null) {
            throw new NullPointerException();
        }
        Color c = this.gridColor;
        this.gridColor = gridColor;
        this.fireEvent(new PropertyChangeEvent(this, "grid_color", c, gridColor));
    }

    public void setHistoryCount(int historyCount) {
        if (historyCount < 0) {
            throw new IllegalArgumentException("positive value required: " + historyCount);
        }
        Integer i = new Integer(this.historyCount);
        this.historyCount = historyCount;
        this.fireEvent(new PropertyChangeEvent(this, "history_count", i, historyCount));
    }

    public void setInterval(int interval) {
        if (interval < 0) {
            throw new IllegalArgumentException("positve value required: " + interval);
        }
        Integer i = new Integer(interval);
        this.interval = interval;
        this.fireEvent(new PropertyChangeEvent(this, "interval", i, interval));
    }

    public void setMinimumSize(Dimension minimumSize) {
        if (minimumSize == null) {
            throw new NullPointerException();
        }
        Dimension d = this.minimumSize;
        this.minimumSize = minimumSize;
        this.fireEvent(new PropertyChangeEvent(this, "minimum_size", d, minimumSize));
    }

    public void setShowConfigurationButton(boolean showConfigurationButton) {
        Boolean b = new Boolean(this.showConfigurationButton);
        this.showConfigurationButton = showConfigurationButton;
        this.fireEvent(new PropertyChangeEvent(this, "show_configuration_button", b, showConfigurationButton));
    }

    public void setShowDetails(boolean showDetails) {
        Boolean b = new Boolean(this.showDetails);
        this.showDetails = showDetails;
        this.fireEvent(new PropertyChangeEvent(this, "show_details", b, showDetails));
    }

    public void setShowGraphLabel(boolean showGraphLabel) {
        Boolean b = new Boolean(this.showGraphLabel);
        this.showGraphLabel = showGraphLabel;
        this.fireEvent(new PropertyChangeEvent(this, "show_label", b, showGraphLabel));
    }

    public void setShowGrid(boolean showGrid) {
        Boolean b = new Boolean(this.showGrid);
        this.showGrid = showGrid;
        this.fireEvent(new PropertyChangeEvent(this, "show_grid", b, showGrid));
    }

    public void setShowSubGrid(boolean showSubGrid) {
        Boolean b = new Boolean(this.showSubGrid);
        this.showSubGrid = showSubGrid;
        this.fireEvent(new PropertyChangeEvent(this, "show_subgrid", b, showSubGrid));
    }

    public void setStepCount(int stepCount) {
        if (stepCount < 0) {
            throw new IllegalArgumentException("positive value required: " + stepCount);
        }
        Integer i = new Integer(stepCount);
        this.stepCount = stepCount;
        this.fireEvent(new PropertyChangeEvent(this, "step_count", i, stepCount));
    }

    public void setStringColor(Color stringColor) {
        if (stringColor == null) {
            throw new NullPointerException();
        }
        Color c = this.stringColor;
        this.stringColor = stringColor;
        this.fireEvent(new PropertyChangeEvent(this, "string_color", c, stringColor));
    }

    public void setSubGridColor(Color subGridColor) {
        if (subGridColor == null) {
            throw new NullPointerException();
        }
        Color c = this.subGridColor;
        this.subGridColor = subGridColor;
        this.fireEvent(new PropertyChangeEvent(this, "subgrid_color", c, subGridColor));
    }

    protected void fireEvent(PropertyChangeEvent e) {
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(e);
        }
    }
}

