/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.fmv;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.talisman.fmv.MemoryState;
import jp.sourceforge.talisman.fmv.MemoryStateNotifyListener;

public class MemoryStateNotifier {
    private List<MemoryStateNotifyListener> listeners = new ArrayList<MemoryStateNotifyListener>();
    private MemoryState state = null;

    public void addNotifyListener(MemoryStateNotifyListener listener) {
        this.listeners.add(listener);
    }

    public void removeNotifyListener(MemoryStateNotifyListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void informAll() {
        if (this.state != null) {
            throw new IllegalStateException("illegal state, current memory status is already build");
        }
        this.state = new MemoryState();
        for (MemoryStateNotifyListener listener : this.listeners) {
            this.inform(listener);
        }
        this.state = null;
    }

    public void inform(MemoryStateNotifyListener listener) {
        MemoryState ms = this.state;
        if (ms == null) {
            ms = new MemoryState();
        }
        listener.currentMemoryStateNotified(ms);
    }

    public long getTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    public long getUsedMemory() {
        return this.getTotalMemory() - this.getFreeMemory();
    }

    public long getFreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }
}

