package jp.sourceforge.talisman.pcp;

/*
 * $Id: MetricsDomainTest.java 132 2008-07-15 03:30:47Z tama3 $
 */

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import org.junit.Before;
import org.junit.Test;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 132 $ 
 */
public class MetricsDomainTest{
    private MetricsDomain domain;

    @Before
    public void initialize(){
        domain = new MetricsDomain(new Metrics("metrics1"), 100, 0);
    }

    @Test
    public void testBasic(){
        assertTrue(domain.getMetrics().equals(new Metrics("metrics1")));

        assertEquals(100, domain.getMaximum());
        assertEquals(0, domain.getMinimum());
        assertEquals(MetricsDomain.DEFAULT_SCALE_STEPS, domain.getScaleSteps());
    }

    @Test
    public void testFullConstructor(){
        domain = new MetricsDomain(new Metrics("metrics1"), 50, 10, 10);

        assertTrue(domain.getMetrics().equals(new Metrics("metrics1")));
        assertEquals(50, domain.getMaximum());
        assertEquals(10, domain.getMinimum());
        assertEquals(10, domain.getScaleSteps());
    }

    @Test(expected = NullPointerException.class)
    public void testNullMetrics(){
        new MetricsDomain(null, 100, 0);
    }

    @Test
    public void testSelfConstructor(){
        domain = new MetricsDomain(new Metrics("metrics1"), 50, 10, 10);
        MetricsDomain md = new MetricsDomain(domain);

        assertTrue(md.getMetrics().equals(new Metrics("metrics1")));
        assertEquals(50, md.getMaximum());
        assertEquals(10, md.getMinimum());
        assertEquals(10, md.getScaleSteps());
    }

    @Test
    public void testSetMaximum(){
        domain.setMaximum(50);
        assertEquals(50, domain.getMaximum());
    }

    @Test
    public void testSetMinimum(){
        domain.setMinimum(10);
        assertEquals(10, domain.getMinimum());
    }

    @Test
    public void testSetScaleSteps(){
        domain.setScaleSteps(10);
        assertEquals(10, domain.getScaleSteps());
    }
}
