package jp.sourceforge.talisman.pcp.ui.swing.actions;

/*
 * $Id: JToggleButtonAction.java 132 2008-07-15 03:30:47Z tama3 $
 */

import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import javax.swing.AbstractAction;
import javax.swing.JToggleButton;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 132 $ 
 */
abstract class JToggleButtonAction extends AbstractAction{
    private static final long serialVersionUID = 3221311383236523884L;

    public boolean isChecked(ActionEvent e) throws IllegalStateException{
        Object o = e.getSource();
        if(o instanceof JToggleButton){
            JToggleButton button = (JToggleButton)o;
            return button.isSelected();
        }
        else{
            try{
                Method m = o.getClass().getMethod("isSelected");
                Boolean b = (Boolean)m.invoke(o);
                if(b != null){
                    return b.booleanValue();
                }
            } catch(SecurityException e1){
            } catch(NoSuchMethodException e1){
            } catch(IllegalArgumentException e1){
            } catch(IllegalAccessException e1){
            } catch(InvocationTargetException e1){
            }
        }
        throw new IllegalStateException("action source is not toggled");
    }
}
