package jp.sourceforge.talisman.pcp.ui.swing.actions;

/*
 * $Id: ActiveLineColorSelectAction.java 132 2008-07-15 03:30:47Z tama3 $
 */

import java.awt.Color;
import java.awt.event.ActionEvent;

import jp.sourceforge.talisman.pcp.ui.swing.PcpPane;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 132 $ 
 */
public class ActiveLineColorSelectAction extends ColorChooserShowAction{
    private static final long serialVersionUID = -3896180843068958111L;

    private PcpPane pcp;

    public ActiveLineColorSelectAction(PcpPane pcp){
        this.pcp = pcp;
        putValue(ACTION_COMMAND_KEY, "activelinecolor.select");
        putValue(NAME, pcp.getMessages().get("activelinecolor.label"));
        if(pcp.getMessages().hasValue("activelinecolor.icon")){
            putValue(SMALL_ICON, pcp.getMessages().getIcon("activelinecolor.icon"));
        }
    }

    public void actionPerformed(ActionEvent e){
        Color newColor = chooseColor(pcp, pcp.getSetting().getActiveLineColor(), pcp);

        pcp.getSetting().setActiveLineColor(newColor);
    }
}
