package jp.sourceforge.talisman.pcp.ui.swing;

/*
 * $Id: PcpSelectedAreaPane.java 132 2008-07-15 03:30:47Z tama3 $
 */

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.GeneralPath;

import javax.swing.JPanel;

import jp.sourceforge.talisman.pcp.MetricsDomain;
import jp.sourceforge.talisman.pcp.Sample;
import jp.sourceforge.talisman.pcp.Samples;
import jp.sourceforge.talisman.pcp.ui.PcpGraphSetting;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 132 $ 
 */
class PcpSelectedAreaPane extends JPanel{
    private static final long serialVersionUID = 4628532390115960095L;

    private MetricsDomain[] inactiveDomains;
    private MetricsDomain[] domains;
    private int targetDomainNumber = -1;
    private boolean upperSide = false;
    private Samples samples;
    private PcpGraphSetting setting;

    public PcpSelectedAreaPane(Samples samples, MetricsDomain[] domains, PcpGraphSetting setting){
        this.samples = samples;
        this.domains = domains;
        this.setting = setting;

        initData();
        setOpaque(false);

        addMouseListener(new MouseAdapter(){
            @Override
            public void mousePressed(MouseEvent e){
                pointDetermination(e);
            }

            @Override
            public void mouseReleased(MouseEvent e){
                if(targetDomainNumber >= 0){
                    updateSelection(e);
                    targetDomainNumber = -1;
                    repaint();
                }
            }
        });
        addMouseMotionListener(new MouseMotionAdapter(){
            @Override
            public void mouseDragged(MouseEvent e){
                if(targetDomainNumber >= 0){
                    updateSelection(e);
                    repaint();
                }
            }
        });
    }

    public void clearSelection(){
        initData();

        for(Sample sample: samples){
            sample.setActive(true);
        }
    }

    @Override
    public void paintComponent(Graphics graphics){
        Graphics2D g = (Graphics2D)graphics;
        Color initColor = g.getColor();

        Dimension dim = getSize();

        GeneralPath upper = generateGeneralPath(dim, true);
        GeneralPath lower = generateGeneralPath(dim, false);

        g.setColor(setting.getSelectedAreaColor());
        g.fill(upper);
        g.fill(lower);

        g.setColor(initColor);
        super.paintComponent(g);
    }

    private GeneralPath generateGeneralPath(Dimension dim, boolean upper){
        double width = dim.getWidth() / domains.length;
        double middleWidth = width / 2d;
        double height = dim.getHeight() - setting.getSouthOffset();
        float offsetY = (float)height;
        if(upper){
            offsetY = 0f;
        }

        GeneralPath path = new GeneralPath();
        path.moveTo((float)middleWidth, 10f + offsetY);
        for(int i = 0; i < inactiveDomains.length; i++){
            double step = height / Math.abs(domains[i].getMaximum() - domains[i].getMinimum());
            int domainValue = inactiveDomains[i].getMaximum();
            if(!upper){
                domainValue = inactiveDomains[i].getMinimum();
            }
            int value = domainValue - domains[i].getMinimum();
            float lineHeight = (float)(height - (step * value));
            path.lineTo((float)(i * width + middleWidth), lineHeight + 10f);
        }
        path.lineTo((float)(dim.getWidth() - middleWidth), 10f + offsetY);
        path.closePath();

        return path;
    }

    private void initData(){
        inactiveDomains = new MetricsDomain[domains.length];
        for(int i = 0; i < domains.length; i++){
            inactiveDomains[i] = new MetricsDomain(domains[i]);
        }
    }

    private void pointDetermination(MouseEvent e){
        Dimension dim = getSize();
        double width = (dim.getWidth() / domains.length);
        double middlePoint = width / 2d;
        double height = dim.getHeight() - setting.getSouthOffset();
        int x = e.getX();
        for(int i = 0; i < domains.length; i++){
            double stepY = height / (domains[i].getMaximum() - domains[i].getMinimum());
            double offsetX = width * i + middlePoint;

            if(Math.abs(offsetX - x) < 5d){
                int y = e.getY();
                double upperY = 10 + height - (stepY * (inactiveDomains[i].getMaximum() - domains[i].getMinimum()));
                double lowerY = 10 + height - (stepY * (inactiveDomains[i].getMinimum() - domains[i].getMinimum()));
                if(Math.abs(upperY - y) < 5d){
                    upperSide = true;
                    targetDomainNumber = i;
                    break;
                }
                else if(Math.abs(lowerY - y) < 5d){
                    upperSide = false;
                    targetDomainNumber = i;
                    break;
                }
            }
        }
    }

    private void updateSelection(MouseEvent e){
        Dimension dim = getSize();
        int y = e.getY();
        MetricsDomain orig = domains[targetDomainNumber];
        MetricsDomain target = inactiveDomains[targetDomainNumber];
        double height = dim.getHeight() - setting.getSouthOffset();
        double stepY = height / (orig.getMaximum() - orig.getMinimum());
        int newValue = Math.round((float)((height - y) / stepY)) + orig.getMinimum();
        if(upperSide){
            if(orig.getMaximum() < newValue){
                newValue = orig.getMaximum();
            }
            target.setMaximum(newValue);
        }
        else{
            if(orig.getMinimum() > newValue){
                newValue = orig.getMinimum();
            }
            target.setMinimum(newValue);
        }

        for(Sample sample: samples){
            boolean activeFlag = true;
            for(MetricsDomain md: inactiveDomains){
                if(sample.hasValue(md.getMetrics())){
                    int value = sample.getValue(md.getMetrics());
                    if(value > md.getMaximum() || value < md.getMinimum()){
                        activeFlag = false;
                        break;
                    }
                }
            }
            sample.setActive(activeFlag);
        }
    }
}
