/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.pcp.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import jp.sourceforge.talisman.i18n.MessageManager;
import jp.sourceforge.talisman.i18n.Messages;
import jp.sourceforge.talisman.i18n.ResourceNotFoundException;
import jp.sourceforge.talisman.pcp.Metrics;
import jp.sourceforge.talisman.pcp.MetricsDomain;
import jp.sourceforge.talisman.pcp.Sample;
import jp.sourceforge.talisman.pcp.Samples;
import jp.sourceforge.talisman.pcp.ui.PcpGraphSetting;
import jp.sourceforge.talisman.pcp.ui.swing.PcpAxisPane;
import jp.sourceforge.talisman.pcp.ui.swing.PcpMainPane;
import jp.sourceforge.talisman.pcp.ui.swing.PcpSelectedAreaPane;

public class PcpPane
extends JPanel
implements MessageManager {
    private static final long serialVersionUID = 7536699600763579247L;
    private Samples samples;
    private MetricsDomain[] domains;
    private JLayeredPane layer = new JLayeredPane();
    private PcpAxisPane borderPane;
    private PcpMainPane mainPane;
    private PcpSelectedAreaPane selectionPane;
    private PcpGraphSetting setting;
    private Messages messages;

    public PcpPane(Samples samples) throws ResourceNotFoundException {
        this(samples, new PcpGraphSetting());
    }

    public PcpPane(Samples samples, Messages messages) {
        this(samples, new PcpGraphSetting(), messages);
    }

    public PcpPane(Samples samples, PcpGraphSetting setting) throws ResourceNotFoundException {
        this(samples, setting, new Messages("jp.sourceforge.talisman.pcp.messages"));
    }

    public PcpPane(Samples samples, PcpGraphSetting setting, Messages messages) {
        this.samples = samples;
        this.messages = messages;
        this.setSetting(setting);
        this.initData();
        this.initLayouts();
    }

    public PcpGraphSetting getSetting() {
        return this.setting;
    }

    public void setSetting(PcpGraphSetting setting) {
        if (setting == null) {
            throw new NullPointerException();
        }
        this.setting = setting;
        setting.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                PcpPane.this.repaint();
            }
        });
    }

    public void clearSelection() {
        this.selectionPane.clearSelection();
        this.repaint();
    }

    private void initData() {
        int i;
        Metrics[] metric = this.samples.getAvailableMetrics();
        MetricsDomain[] domains = new MetricsDomain[metric.length];
        for (i = 0; i < domains.length; ++i) {
            domains[i] = new MetricsDomain(metric[i]);
        }
        for (i = 0; i < metric.length; ++i) {
            for (Sample sample : this.samples) {
                if (!sample.hasValue(metric[i])) continue;
                int v = sample.getValue(metric[i]);
                if (domains[i].getMaximum() < v) {
                    domains[i].setMaximum(v);
                }
                if (domains[i].getMinimum() <= v) continue;
                domains[i].setMinimum(v);
            }
        }
        this.domains = domains;
    }

    private void initLayouts() {
        JPanel labelPane = new JPanel(new GridLayout(1, this.domains.length, 0, 0));
        for (int i = 0; i < this.domains.length; ++i) {
            Metrics metrics = this.domains[i].getMetrics();
            JLabel label = new JLabel(metrics.getName(), 0);
            if (metrics.getDescription() != null) {
                label.setToolTipText(metrics.getDescription());
            }
            labelPane.add(label);
        }
        this.borderPane = new PcpAxisPane(this.domains, this.getSetting(), this.getMessages());
        this.mainPane = new PcpMainPane(this.samples, this.domains, this.getSetting());
        this.selectionPane = new PcpSelectedAreaPane(this.samples, this.domains, this.getSetting());
        this.layer.add((Component)this.borderPane, JLayeredPane.DEFAULT_LAYER);
        this.layer.add((Component)this.mainPane, JLayeredPane.PALETTE_LAYER);
        this.layer.add((Component)this.selectionPane, JLayeredPane.MODAL_LAYER);
        this.layer.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                Component comp = e.getComponent();
                Dimension dim = comp.getSize();
                PcpPane.this.borderPane.setSize(dim);
                PcpPane.this.mainPane.setSize(dim);
                PcpPane.this.selectionPane.setSize(dim);
            }
        });
        this.layer.setPreferredSize(new Dimension(800, 400));
        this.setLayout(new BorderLayout());
        this.add((Component)this.layer, "Center");
        this.add((Component)labelPane, "South");
        this.setFont(this.getFont());
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.mainPane != null) {
            this.mainPane.setFont(font);
        }
        if (this.selectionPane != null) {
            this.selectionPane.setFont(font);
        }
        if (this.borderPane != null) {
            this.borderPane.setFont(font);
        }
    }

    public Messages getMessages() {
        return this.messages;
    }
}

