/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package jp.sourceforge.talisman.xmlcli.builder.relaxer;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.w3c.dom.*;

/**
 * <b>ShortLongOption</b> is generated from xmlcli-1_1.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <define name="short-long-option">
 *     <group>
 *       <ref name="short-option"/>
 *       <ref name="long-option"/>
 *     </group>
 *   </define>-->
 * <!-- for javadoc -->
 * <pre> &lt;define name="short-long-option"&gt;
 *     &lt;group&gt;
 *       &lt;ref name="short-option"/&gt;
 *       &lt;ref name="long-option"/&gt;
 *     &lt;/group&gt;
 *   &lt;/define&gt;</pre>
 *
 * @version xmlcli-1_1.rng (Mon Aug 13 18:01:29 JST 2007)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
@SuppressWarnings({ "unchecked", "unused", "serial"})
public class ShortLongOption implements java.io.Serializable, Cloneable, IDefinitionChoice {
    private String shortOption_;
    private String longOption_;

    /**
     * Creates a <code>ShortLongOption</code>.
     *
     */
    public ShortLongOption() {
        shortOption_ = "";
        longOption_ = "";
    }

    /**
     * Creates a <code>ShortLongOption</code>.
     *
     * @param source
     */
    public ShortLongOption(ShortLongOption source) {
        setup(source);
    }

    /**
     * Creates a <code>ShortLongOption</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public ShortLongOption(RStack stack) {
        setup(stack);
    }

    /**
     * Initializes the <code>ShortLongOption</code> by the ShortLongOption <code>source</code>.
     *
     * @param source
     */
    public void setup(ShortLongOption source) {
        int size;
        shortOption_ = source.shortOption_;
        longOption_ = source.longOption_;
    }

    /**
     * Initializes the <code>ShortLongOption</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        Element element = stack.getContextElement();
        try {
            shortOption_ = URelaxer.getElementPropertyAsStringByStack(stack, "short-option");
        } catch (IllegalArgumentException e) {} 
        try {
            longOption_ = URelaxer.getElementPropertyAsStringByStack(stack, "long-option");
        } catch (IllegalArgumentException e) {} 
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new ShortLongOption((ShortLongOption)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc = parent.getOwnerDocument();
        Element element = (Element)parent;
        int size;
        if (this.shortOption_ != null) {
            URelaxer.setElementPropertyByString(element, "short-option", this.shortOption_);
        }
        if (this.longOption_ != null) {
            URelaxer.setElementPropertyByString(element, "long-option", this.longOption_);
        }
    }

    /**
     * Gets the String property <b>shortOption</b>.
     *
     * @return String
     */
    public String getShortOption() {
        return (shortOption_);
    }

    /**
     * Sets the String property <b>shortOption</b>.
     *
     * @param shortOption
     */
    public void setShortOption(String shortOption) {
        this.shortOption_ = shortOption;
    }

    /**
     * Gets the String property <b>longOption</b>.
     *
     * @return String
     */
    public String getLongOption() {
        return (longOption_);
    }

    /**
     * Sets the String property <b>longOption</b>.
     *
     * @param longOption
     */
    public void setLongOption(String longOption) {
        this.longOption_ = longOption;
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        if (shortOption_ != null) {
            buffer.append("<short-option>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(getShortOption())));
            buffer.append("</short-option>");
        }
        if (longOption_ != null) {
            buffer.append("<long-option>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(getLongOption())));
            buffer.append("</long-option>");
        }
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        if (shortOption_ != null) {
            buffer.write("<short-option>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(getShortOption())));
            buffer.write("</short-option>");
        }
        if (longOption_ != null) {
            buffer.write("<long-option>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(getLongOption())));
            buffer.write("</long-option>");
        }
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        if (shortOption_ != null) {
            buffer.print("<short-option>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(getShortOption())));
            buffer.print("</short-option>");
        }
        if (longOption_ != null) {
            buffer.print("<long-option>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(getLongOption())));
            buffer.print("</long-option>");
        }
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
        int size;
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
        int size;
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
        int size;
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getShortOptionAsString() {
        return (URelaxer.getString(getShortOption()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getLongOptionAsString() {
        return (URelaxer.getString(getLongOption()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setShortOptionByString(String string) {
        setShortOption(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setLongOptionByString(String string) {
        setLongOption(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>ShortLongOption</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        return (isMatchHungry(stack.makeClone()));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>ShortLongOption</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        RStack target = stack.makeClone();
        boolean $match$ = false;
        Element element = target.peekElement();
        Element child;
        child = target.popElement();
        if (child == null) {
            return (false);
        }
        if (!URelaxer.isTargetElement(child, "short-option")) {
            return (false);
        }
        $match$ = true;
        child = target.popElement();
        if (child == null) {
            return (false);
        }
        if (!URelaxer.isTargetElement(child, "long-option")) {
            return (false);
        }
        $match$ = true;
        if ($match$) {
            stack.eat(target);
        }
        return ($match$);
    }
}
