/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package jp.sourceforge.talisman.xmlcli.builder.relaxer;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>CommandLineDefinitions</b> is generated from xmlcli-1_1.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="definitions">
 *         <oneOrMore>
 *           <ref name="definition"/>
 *         </oneOrMore>
 *       </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="definitions"&gt;
 *         &lt;oneOrMore&gt;
 *           &lt;ref name="definition"/&gt;
 *         &lt;/oneOrMore&gt;
 *       &lt;/element&gt;</pre>
 *
 * @version xmlcli-1_1.rng (Mon Aug 13 18:01:29 JST 2007)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
@SuppressWarnings({ "unchecked", "unused", "serial"})
public class CommandLineDefinitions implements java.io.Serializable, Cloneable {
    // List<Definition>
    private java.util.List definition_ = new java.util.ArrayList();

    /**
     * Creates a <code>CommandLineDefinitions</code>.
     *
     */
    public CommandLineDefinitions() {
    }

    /**
     * Creates a <code>CommandLineDefinitions</code>.
     *
     * @param source
     */
    public CommandLineDefinitions(CommandLineDefinitions source) {
        setup(source);
    }

    /**
     * Creates a <code>CommandLineDefinitions</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public CommandLineDefinitions(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>CommandLineDefinitions</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public CommandLineDefinitions(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>CommandLineDefinitions</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public CommandLineDefinitions(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>CommandLineDefinitions</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CommandLineDefinitions(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>CommandLineDefinitions</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CommandLineDefinitions(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>CommandLineDefinitions</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CommandLineDefinitions(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>CommandLineDefinitions</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CommandLineDefinitions(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>CommandLineDefinitions</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CommandLineDefinitions(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>CommandLineDefinitions</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CommandLineDefinitions(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>CommandLineDefinitions</code> by the CommandLineDefinitions <code>source</code>.
     *
     * @param source
     */
    public void setup(CommandLineDefinitions source) {
        int size;
        this.definition_.clear();
        size = source.definition_.size();
        for (int i = 0;i < size;i++) {
            addDefinition((Definition)source.getDefinition(i).clone());
        }
    }

    /**
     * Initializes the <code>CommandLineDefinitions</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>CommandLineDefinitions</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>CommandLineDefinitions</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        definition_.clear();
        while (true) {
            if (Definition.isMatch(stack)) {
                addDefinition(new Definition(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new CommandLineDefinitions((CommandLineDefinitions)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("definitions");
        int size;
        size = this.definition_.size();
        for (int i = 0;i < size;i++) {
            Definition value = (Definition)this.definition_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>CommandLineDefinitions</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>CommandLineDefinitions</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>CommandLineDefinitions</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>CommandLineDefinitions</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>CommandLineDefinitions</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>CommandLineDefinitions</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the Definition property <b>definition</b>.
     *
     * @return Definition[]
     */
    public Definition[] getDefinition() {
        Definition[] array = new Definition[definition_.size()];
        return ((Definition[])definition_.toArray(array));
    }

    /**
     * Sets the Definition property <b>definition</b>.
     *
     * @param definition
     */
    public void setDefinition(Definition[] definition) {
        this.definition_.clear();
        for (int i = 0;i < definition.length;i++) {
            addDefinition(definition[i]);
        }
    }

    /**
     * Sets the Definition property <b>definition</b>.
     *
     * @param definition
     */
    public void setDefinition(Definition definition) {
        this.definition_.clear();
        addDefinition(definition);
    }

    /**
     * Adds the Definition property <b>definition</b>.
     *
     * @param definition
     */
    public void addDefinition(Definition definition) {
        this.definition_.add(definition);
    }

    /**
     * Adds the Definition property <b>definition</b>.
     *
     * @param definition
     */
    public void addDefinition(Definition[] definition) {
        for (int i = 0;i < definition.length;i++) {
            addDefinition(definition[i]);
        }
    }

    /**
     * Gets number of the Definition property <b>definition</b>.
     *
     * @return int
     */
    public int sizeDefinition() {
        return (definition_.size());
    }

    /**
     * Gets the Definition property <b>definition</b> by index.
     *
     * @param index
     * @return Definition
     */
    public Definition getDefinition(int index) {
        return ((Definition)definition_.get(index));
    }

    /**
     * Sets the Definition property <b>definition</b> by index.
     *
     * @param index
     * @param definition
     */
    public void setDefinition(int index, Definition definition) {
        this.definition_.set(index, definition);
    }

    /**
     * Adds the Definition property <b>definition</b> by index.
     *
     * @param index
     * @param definition
     */
    public void addDefinition(int index, Definition definition) {
        this.definition_.add(index, definition);
    }

    /**
     * Remove the Definition property <b>definition</b> by index.
     *
     * @param index
     */
    public void removeDefinition(int index) {
        this.definition_.remove(index);
    }

    /**
     * Remove the Definition property <b>definition</b> by object.
     *
     * @param definition
     */
    public void removeDefinition(Definition definition) {
        this.definition_.remove(definition);
    }

    /**
     * Clear the Definition property <b>definition</b>.
     *
     */
    public void clearDefinition() {
        this.definition_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<definitions");
        buffer.append(">");
        size = this.definition_.size();
        for (int i = 0;i < size;i++) {
            Definition value = (Definition)this.definition_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</definitions>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<definitions");
        buffer.write(">");
        size = this.definition_.size();
        for (int i = 0;i < size;i++) {
            Definition value = (Definition)this.definition_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</definitions>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<definitions");
        buffer.print(">");
        size = this.definition_.size();
        for (int i = 0;i < size;i++) {
            Definition value = (Definition)this.definition_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</definitions>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>CommandLineDefinitions</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "definitions")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!Definition.isMatchHungry(target)) {
            return (false);
        }
        $match$ = true;
        while (true) {
            if (!Definition.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CommandLineDefinitions</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CommandLineDefinitions</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
