package jp.sourceforge.talisman.xmlcli.builder;

/*
 * $Id: RelaxerOptionsBuilder.java 28 2007-08-21 01:27:00Z tama3 $
 */

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;

import javax.xml.parsers.ParserConfigurationException;

import jp.sourceforge.talisman.xmlcli.builder.relaxer.AvailableOptions;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.CommandLine;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.CommandLineDefinitions;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.Definition;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.Group;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.IAvailableOptionsChoice;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.IDefinitionChoice;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.LongOption;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.ShortLongOption;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.ShortOption;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 28 $ $Date: 2007-08-21 10:27:00 +0900 (Tue, 21 Aug 2007) $
 */
public class RelaxerOptionsBuilder extends AbstractOptionsBuilder{
    private CommandLine commandline;

    public RelaxerOptionsBuilder(InputStream in){
        super(in);
    }

    @Override
    public Options buildOptions() throws IOException, SAXException, DOMException{
        try{
            commandline = new CommandLine(getStream());
            Map<String, Option> optionMap = getOptions(commandline.getCommandLineDefinitions());
            Options options = buildOptions(optionMap, commandline.getAvailableOptions());

            return options;
        }catch(ParserConfigurationException e){
        }

        return null;
    }

    @Override
    public String getDefinitionName(){
        if(commandline != null){
            return commandline.getName();
        }
        return null;
    }

    private Options buildOptions(Map<String, Option> map,
            AvailableOptions available){
        Options options = new Options();
        for(IAvailableOptionsChoice choice: available.getContent()){
            if(choice instanceof jp.sourceforge.talisman.xmlcli.builder.relaxer.Option){
                jp.sourceforge.talisman.xmlcli.builder.relaxer.Option o = (jp.sourceforge.talisman.xmlcli.builder.relaxer.Option)choice;
                options.addOption(map.get(o.getContent()));
            }
            else if(choice instanceof Group){
                OptionGroup group = new OptionGroup();
                for(String option: ((Group)choice).getOption()){
                    group.addOption(map.get(option));
                }
                options.addOptionGroup(group);
            }
        }
        return options;
    }

    private Map<String, Option> getOptions(CommandLineDefinitions definitions){
        Map<String, Option> options = new HashMap<String, Option>();
        for(Definition def: definitions.getDefinition()){
            String name = def.getName();
            IDefinitionChoice choice = (IDefinitionChoice)def.getContent();
            String shortOption = null;
            String longOption = null;
            if(choice instanceof ShortOption){
                shortOption = ((ShortOption)choice).getContent();
            }
            else if(choice instanceof LongOption){
                longOption = ((LongOption)choice).getContent();
            }
            else if(choice instanceof ShortLongOption){
                shortOption = ((ShortLongOption)choice).getShortOption();
                longOption = ((ShortLongOption)choice).getLongOption();
            }
            Option option = createOption(shortOption, longOption, def);
            options.put(name, option);
        }
        return options;
    }

    @SuppressWarnings("static-access")
    private Option createOption(String shortOption, String longOption, Definition def){
        boolean hasArg = true;
        String argument = def.getArgument();
        int argumentCount = -1;
        if(argument == null || argument.equals(Definition.ARGUMENT_NONE)){
            hasArg = false;
        }
        String multipleArgs = def.getMultipleArgs();
        if(multipleArgs != null && !multipleArgs.trim().equals("")){
            try{
                argumentCount = Integer.parseInt(multipleArgs);
            }catch(NumberFormatException e){
                argumentCount = -1;
            }
        }

        OptionBuilder builder = null;
        if(longOption != null)
            builder = builder.withLongOpt(longOption);
        if(hasArg)
            builder = builder.hasArg(hasArg);
        if(def.getArgumentName() != null)
            builder = builder.withArgName(def.getArgumentName());
        if(def.getDescription() != null)
            builder = builder.withDescription(deleteWhiteSpace(def.getDescription()));
        if(def.getValueSeparator() != null)
            builder = builder.withValueSeparator(def.getValueSeparator().charAt(0));
        if(def.getType() != null)
            builder = builder.withType(def.getType());
        if(def.getRequire() != null)
            builder = builder.isRequired();
        if(argument != null && argument.equals(Definition.ARGUMENT_OPTIONAL)){
            builder = builder.hasOptionalArg();
        }
        if(def.getMultipleArgs() != null){
            if(argument != null && argument.equals(Definition.ARGUMENT_OPTIONAL)){
                if(argumentCount > 0)
                    builder = builder.hasOptionalArgs(argumentCount);
                else
                    builder = builder.hasOptionalArgs();
            }
            else{
                if(argumentCount > 0)
                    builder = builder.hasArgs(argumentCount);
                else
                    builder = builder.hasArgs();
            }
        }

        if(shortOption != null){
            return builder.create(shortOption);
        }
        return builder.create();

    }

    private String deleteWhiteSpace(String string){
        BufferedReader in = new BufferedReader(new StringReader(string));
        String line;
        StringBuilder result = new StringBuilder();
        boolean first = true;

        try{
            while((line = in.readLine()) != null){
                if(!first){
                    result.append(' ');
                }
                line = line.trim();
                if(!line.equals("")){
                    result.append(line);
                    first = false;
                }
            }
        }catch(IOException e){
            throw new InternalError(e.getMessage());
        }
        return new String(result);
    }
}
