package jp.sourceforge.talisman.xmlcli.builder;

/*
 * $Id: OptionsBuilderFactory.java 28 2007-08-21 01:27:00Z tama3 $
 */

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import jp.sourceforge.talisman.xmlcli.OptionsBuilder;
import jp.sourceforge.talisman.xmlcli.ParseType;

/**
 * The factory class for {@link OptionsBuilder <code>OptionsBuilder</code>}.
 * 
 * @author Haruaki TAMADA
 * @version $Revision: 28 $ $Date: 2007-08-21 10:27:00 +0900 (Tue, 21 Aug 2007) $
 */
public class OptionsBuilderFactory{
    private static OptionsBuilderFactory factory;

    private OptionsBuilderFactory(){
    }

    public static OptionsBuilderFactory getInstance(){
        if(factory == null){
            factory = new OptionsBuilderFactory();
        }
        return factory;
    }

    public OptionsBuilder createBuilder(File file) throws IOException{
        return createBuilder(new FileInputStream(file));
    }

    public OptionsBuilder createBuilder(java.net.URL url) throws IOException{
        return createBuilder(url.openStream());
    }

    public OptionsBuilder createBuilder(String string) throws IOException{
        return createBuilder(new ByteArrayInputStream(string.getBytes()));
    }

    public OptionsBuilder createBuilder(InputStream in){
        return new RelaxerOptionsBuilder(in);
    }

    public OptionsBuilder createBuilder(ParseType type, File file) throws IOException{
        return createBuilder(type, new FileInputStream(file));
    }

    public OptionsBuilder createBuilder(ParseType type, java.net.URL url) throws IOException{
        return createBuilder(type, url.openStream());
    }

    public OptionsBuilder createBuilder(ParseType type, String string) throws IOException{
        return createBuilder(type, new ByteArrayInputStream(string.getBytes()));
    }

    public OptionsBuilder createBuilder(ParseType type, InputStream in){
    	OptionsBuilder builder;
    	switch(type){
    	case RELAXER:
    		builder = new RelaxerOptionsBuilder(in);
    		break;
    	case SAX:
    	default:
            builder = new SaxOptionsBuilder(in);
    	}
    	return builder;
    }
}
