package jp.sourceforge.talisman.xmlcli;

/*
 * $Id: CommandLinePlus.java 28 2007-08-21 01:27:00Z tama3 $
 */

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.sourceforge.talisman.xmlcli.io.ArgfInputStream;
import jp.sourceforge.talisman.xmlcli.io.ArgfReader;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

/**
 * This class is a wrapper class of {@link CommandLine <code>CommandLine</code>}.
 * Because <code>CommandLine</code> has some bugs. This class fixed them.
 *
 * @author Haruaki TAMADA
 * @version $Revision: 28 $ $Date: 2007-08-21 10:27:00 +0900 (Tue, 21 Aug 2007) $
 */
public class CommandLinePlus{
    private static final Value EXISTS_VALUE = new Value(true);

    private Map<String, String> longOptionNames = new HashMap<String, String>();
    private CommandLine line;

    /**
     * copy given {@link CommandLine <code>CommandLine</code>} object.
     */
    public CommandLinePlus(CommandLine line){
        Option[] options = line.getOptions();
        for(int i = 0; i < options.length; i++){
            String longName = options[i].getLongOpt();
            String shortName = options[i].getOpt();
            if(longName != null && shortName != null){
                longOptionNames.put(longName, shortName);
            }
        }
        this.line = line;
    }

    public ArgfInputStream getArgfInputStream(){
        return new ArgfInputStream(getArgs());
    }

    public ArgfReader getArgfReader(){
        return new ArgfReader(getArgs());
    }

    @SuppressWarnings("unchecked")
    public List<String> getArgList(){
        List<String> list = new ArrayList<String>();
        List orig = line.getArgList();
        for(Iterator i = orig.iterator(); i.hasNext(); ){
            list.add((String)i.next());
        }
        return list;
    }

    public String[] getArgs(){
        return line.getArgs();
    }

    public Object getOptionObject(char opt){
        return getOptionObject(String.valueOf(opt));
    }

    public Object getOptionObject(String opt){
        String name = opt;
        if(opt.length() != 1){
            String n = longOptionNames.get(name);
            if(n != null) name = n;
        }
        return line.getOptionObject(name);
    }

    public Option[] getOptions(){
        return line.getOptions();
    }

    public String getOptionValue(char opt){
        return getOptionValue(String.valueOf(opt));
    }

    public String getOptionValue(String opt){
        String name = opt;
        if(opt.length() != 1){
            String n = longOptionNames.get(name);
            if(n != null) name = n;
        }
        return line.getOptionValue(name);
    }

    public String getOptionValue(char opt, String defaultValue){
        return getOptionValue(String.valueOf(opt));
    }

    public String getOptionValue(String opt, String defaultValue){
        String value = getOptionValue(opt);
        if(value == null){
            value = defaultValue;
        }

        return value;
    }

    public String[] getOptionValues(char opt){
        return getOptionValues(String.valueOf(opt));
    }

    public String[] getOptionValues(String opt){
        String name = opt;
        if(opt.length() != 1){
            String n = longOptionNames.get(name);
            if(n != null) name = n;
        }
        return line.getOptionValues(name);
    }

    public boolean hasOption(char opt){
        return hasOption(String.valueOf(opt));
    }

    public boolean hasOption(String opt){
        String name = opt;
        if(opt.length() != 1){
            String n = longOptionNames.get(name);
            if(n != null) name = n;
        }
        return line.hasOption(name);
    }

    @SuppressWarnings("unchecked")
    public Iterator<Option> iterator(){
        return (Iterator<Option>)line.iterator();
    }

    public Map<String, Object> getOptionValueMap(){
        Map<String, Object> map = new HashMap<String, Object>();
        Option[] option = getOptions();

        for(int i = 0; i < option.length; i++){
            String optionName = option[i].getLongOpt();
            if(optionName == null) optionName = option[i].getOpt();

            if(hasOption(optionName)){
                if(option[i].hasArgs()){
                    map.put(optionName, option[i].getValues());
                }
                else if(option[i].hasArg()){
                    map.put(optionName, option[i].getValue());
                }
                else{
                    map.put(optionName, EXISTS_VALUE);
                }
            }
        }

        return map;
    }

    /**
     * This class represents a object is exist or not.
     */
    public static class Value{
        private boolean exists = true;

        private Value(boolean exists){
            this.exists = exists;
        }

        public int hashCode(){
            if(exists) return 1;
            return 0;
        }

        public boolean equals(Object o){
            return o instanceof Value && o.hashCode() == hashCode();
        }
    };
}
