/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package jp.sourceforge.talisman.xmlcli.builder.relaxer;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>Properties</b> is generated from xmlcli-2_0.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="properties">
 *       <zeroOrMore>
 *         <element name="property">
 *           <element name="name">
 *             <data type="string"/>
 *           </element>
 *           <element name="value">
 *             <data type="string"/>
 *           </element>
 *         </element>
 *       </zeroOrMore>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="properties"&gt;
 *       &lt;zeroOrMore&gt;
 *         &lt;element name="property"&gt;
 *           &lt;element name="name"&gt;
 *             &lt;data type="string"/&gt;
 *           &lt;/element&gt;
 *           &lt;element name="value"&gt;
 *             &lt;data type="string"/&gt;
 *           &lt;/element&gt;
 *         &lt;/element&gt;
 *       &lt;/zeroOrMore&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version xmlcli-2_0.rng (Thu Aug 16 18:37:44 JST 2007)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
@SuppressWarnings({ "unchecked", "serial", "unused" })
public class Properties implements java.io.Serializable, Cloneable {
    // List<PropertiesProperty>
    private java.util.List propertiesProperty_ = new java.util.ArrayList();

    /**
     * Creates a <code>Properties</code>.
     *
     */
    public Properties() {
    }

    /**
     * Creates a <code>Properties</code>.
     *
     * @param source
     */
    public Properties(Properties source) {
        setup(source);
    }

    /**
     * Creates a <code>Properties</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public Properties(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>Properties</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public Properties(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>Properties</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public Properties(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>Properties</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Properties(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>Properties</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Properties(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>Properties</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Properties(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>Properties</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Properties(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>Properties</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Properties(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>Properties</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Properties(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>Properties</code> by the Properties <code>source</code>.
     *
     * @param source
     */
    public void setup(Properties source) {
        int size;
        this.propertiesProperty_.clear();
        size = source.propertiesProperty_.size();
        for (int i = 0;i < size;i++) {
            addPropertiesProperty((PropertiesProperty)source.getPropertiesProperty(i).clone());
        }
    }

    /**
     * Initializes the <code>Properties</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>Properties</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>Properties</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        propertiesProperty_.clear();
        while (true) {
            if (PropertiesProperty.isMatch(stack)) {
                addPropertiesProperty(new PropertiesProperty(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new Properties((Properties)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("properties");
        int size;
        size = this.propertiesProperty_.size();
        for (int i = 0;i < size;i++) {
            PropertiesProperty value = (PropertiesProperty)this.propertiesProperty_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>Properties</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>Properties</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Properties</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Properties</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Properties</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Properties</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the PropertiesProperty property <b>propertiesProperty</b>.
     *
     * @return PropertiesProperty[]
     */
    public PropertiesProperty[] getPropertiesProperty() {
        PropertiesProperty[] array = new PropertiesProperty[propertiesProperty_.size()];
        return ((PropertiesProperty[])propertiesProperty_.toArray(array));
    }

    /**
     * Sets the PropertiesProperty property <b>propertiesProperty</b>.
     *
     * @param propertiesProperty
     */
    public void setPropertiesProperty(PropertiesProperty[] propertiesProperty) {
        this.propertiesProperty_.clear();
        for (int i = 0;i < propertiesProperty.length;i++) {
            addPropertiesProperty(propertiesProperty[i]);
        }
    }

    /**
     * Sets the PropertiesProperty property <b>propertiesProperty</b>.
     *
     * @param propertiesProperty
     */
    public void setPropertiesProperty(PropertiesProperty propertiesProperty) {
        this.propertiesProperty_.clear();
        addPropertiesProperty(propertiesProperty);
    }

    /**
     * Adds the PropertiesProperty property <b>propertiesProperty</b>.
     *
     * @param propertiesProperty
     */
    public void addPropertiesProperty(PropertiesProperty propertiesProperty) {
        this.propertiesProperty_.add(propertiesProperty);
    }

    /**
     * Adds the PropertiesProperty property <b>propertiesProperty</b>.
     *
     * @param propertiesProperty
     */
    public void addPropertiesProperty(PropertiesProperty[] propertiesProperty) {
        for (int i = 0;i < propertiesProperty.length;i++) {
            addPropertiesProperty(propertiesProperty[i]);
        }
    }

    /**
     * Gets number of the PropertiesProperty property <b>propertiesProperty</b>.
     *
     * @return int
     */
    public int sizePropertiesProperty() {
        return (propertiesProperty_.size());
    }

    /**
     * Gets the PropertiesProperty property <b>propertiesProperty</b> by index.
     *
     * @param index
     * @return PropertiesProperty
     */
    public PropertiesProperty getPropertiesProperty(int index) {
        return ((PropertiesProperty)propertiesProperty_.get(index));
    }

    /**
     * Sets the PropertiesProperty property <b>propertiesProperty</b> by index.
     *
     * @param index
     * @param propertiesProperty
     */
    public void setPropertiesProperty(int index, PropertiesProperty propertiesProperty) {
        this.propertiesProperty_.set(index, propertiesProperty);
    }

    /**
     * Adds the PropertiesProperty property <b>propertiesProperty</b> by index.
     *
     * @param index
     * @param propertiesProperty
     */
    public void addPropertiesProperty(int index, PropertiesProperty propertiesProperty) {
        this.propertiesProperty_.add(index, propertiesProperty);
    }

    /**
     * Remove the PropertiesProperty property <b>propertiesProperty</b> by index.
     *
     * @param index
     */
    public void removePropertiesProperty(int index) {
        this.propertiesProperty_.remove(index);
    }

    /**
     * Remove the PropertiesProperty property <b>propertiesProperty</b> by object.
     *
     * @param propertiesProperty
     */
    public void removePropertiesProperty(PropertiesProperty propertiesProperty) {
        this.propertiesProperty_.remove(propertiesProperty);
    }

    /**
     * Clear the PropertiesProperty property <b>propertiesProperty</b>.
     *
     */
    public void clearPropertiesProperty() {
        this.propertiesProperty_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<properties");
        buffer.append(">");
        size = this.propertiesProperty_.size();
        for (int i = 0;i < size;i++) {
            PropertiesProperty value = (PropertiesProperty)this.propertiesProperty_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</properties>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<properties");
        buffer.write(">");
        size = this.propertiesProperty_.size();
        for (int i = 0;i < size;i++) {
            PropertiesProperty value = (PropertiesProperty)this.propertiesProperty_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</properties>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<properties");
        buffer.print(">");
        size = this.propertiesProperty_.size();
        for (int i = 0;i < size;i++) {
            PropertiesProperty value = (PropertiesProperty)this.propertiesProperty_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</properties>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>Properties</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "properties")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        while (true) {
            if (!PropertiesProperty.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Properties</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Properties</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
