/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package jp.sourceforge.talisman.xmlcli.builder.relaxer;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>Argument</b> is generated from xmlcli-2_0.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="argument">
 *       <attribute name="name">
 *         <data type="string"/>
 *       </attribute>
 *       <interleave>
 *         <optional>
 *           <element name="id">
 *             <data type="integer"/>
 *           </element>
 *         </optional>
 *         <optional>
 *           <element name="description">
 *             <data type="string"/>
 *           </element>
 *         </optional>
 *         <optional>
 *           <element name="consume-remaining">
 *             <data type="string"/>
 *           </element>
 *         </optional>
 *         <optional>
 *           <choice>
 *             <ref name="default-value"/>
 *             <element name="default-values">
 *               <oneOrMore>
 *                 <ref name="default-value"/>
 *               </oneOrMore>
 *             </element>
 *           </choice>
 *         </optional>
 *         <optional>
 *           <element name="maximum">
 *             <data type="integer"/>
 *           </element>
 *         </optional>
 *         <optional>
 *           <element name="minimum">
 *             <data type="integer"/>
 *           </element>
 *         </optional>
 *         <optional>
 *           <element name="initial-separator">
 *             <data type="string">
 *               <param name="maxLength">1</param>
 *             </data>
 *           </element>
 *         </optional>
 *         <optional>
 *           <element name="subsequent-separator">
 *             <data type="string">
 *               <param name="maxLength">1</param>
 *             </data>
 *           </element>
 *         </optional>
 *         <optional>
 *           <ref name="validator"/>
 *         </optional>
 *       </interleave>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="argument"&gt;
 *       &lt;attribute name="name"&gt;
 *         &lt;data type="string"/&gt;
 *       &lt;/attribute&gt;
 *       &lt;interleave&gt;
 *         &lt;optional&gt;
 *           &lt;element name="id"&gt;
 *             &lt;data type="integer"/&gt;
 *           &lt;/element&gt;
 *         &lt;/optional&gt;
 *         &lt;optional&gt;
 *           &lt;element name="description"&gt;
 *             &lt;data type="string"/&gt;
 *           &lt;/element&gt;
 *         &lt;/optional&gt;
 *         &lt;optional&gt;
 *           &lt;element name="consume-remaining"&gt;
 *             &lt;data type="string"/&gt;
 *           &lt;/element&gt;
 *         &lt;/optional&gt;
 *         &lt;optional&gt;
 *           &lt;choice&gt;
 *             &lt;ref name="default-value"/&gt;
 *             &lt;element name="default-values"&gt;
 *               &lt;oneOrMore&gt;
 *                 &lt;ref name="default-value"/&gt;
 *               &lt;/oneOrMore&gt;
 *             &lt;/element&gt;
 *           &lt;/choice&gt;
 *         &lt;/optional&gt;
 *         &lt;optional&gt;
 *           &lt;element name="maximum"&gt;
 *             &lt;data type="integer"/&gt;
 *           &lt;/element&gt;
 *         &lt;/optional&gt;
 *         &lt;optional&gt;
 *           &lt;element name="minimum"&gt;
 *             &lt;data type="integer"/&gt;
 *           &lt;/element&gt;
 *         &lt;/optional&gt;
 *         &lt;optional&gt;
 *           &lt;element name="initial-separator"&gt;
 *             &lt;data type="string"&gt;
 *               &lt;param name="maxLength"&gt;1&lt;/param&gt;
 *             &lt;/data&gt;
 *           &lt;/element&gt;
 *         &lt;/optional&gt;
 *         &lt;optional&gt;
 *           &lt;element name="subsequent-separator"&gt;
 *             &lt;data type="string"&gt;
 *               &lt;param name="maxLength"&gt;1&lt;/param&gt;
 *             &lt;/data&gt;
 *           &lt;/element&gt;
 *         &lt;/optional&gt;
 *         &lt;optional&gt;
 *           &lt;ref name="validator"/&gt;
 *         &lt;/optional&gt;
 *       &lt;/interleave&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version xmlcli-2_0.rng (Thu Aug 16 18:37:44 JST 2007)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
@SuppressWarnings({ "unchecked", "serial", "unused" })
public class Argument implements java.io.Serializable, Cloneable, IOptionChoiceChoice {
    private String name_;
    private java.math.BigInteger id_;
    private String description_;
    private String consumeRemaining_;
    private ArgumentChoice argumentChoice_;
    private java.math.BigInteger maximum_;
    private java.math.BigInteger minimum_;
    private String initialSeparator_;
    private String subsequentSeparator_;
    private Validator validator_;

    /**
     * Creates a <code>Argument</code>.
     *
     */
    public Argument() {
        name_ = "";
    }

    /**
     * Creates a <code>Argument</code>.
     *
     * @param source
     */
    public Argument(Argument source) {
        setup(source);
    }

    /**
     * Creates a <code>Argument</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public Argument(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>Argument</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public Argument(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>Argument</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public Argument(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>Argument</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Argument(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>Argument</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Argument(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>Argument</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Argument(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>Argument</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Argument(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>Argument</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Argument(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>Argument</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Argument(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>Argument</code> by the Argument <code>source</code>.
     *
     * @param source
     */
    public void setup(Argument source) {
        int size;
        name_ = source.name_;
        id_ = source.id_;
        description_ = source.description_;
        consumeRemaining_ = source.consumeRemaining_;
        if (source.argumentChoice_ != null) {
            setArgumentChoice((ArgumentChoice)source.getArgumentChoice().clone());
        }
        maximum_ = source.maximum_;
        minimum_ = source.minimum_;
        initialSeparator_ = source.initialSeparator_;
        subsequentSeparator_ = source.subsequentSeparator_;
        if (source.validator_ != null) {
            setValidator((Validator)source.getValidator().clone());
        }
    }

    /**
     * Initializes the <code>Argument</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>Argument</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>Argument</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        RInterleave interleave;
        name_ = URelaxer.getAttributePropertyAsString(element, "name");
        interleave = new RInterleave(stack);
        interleave.addElementSlot("id", "?");
        interleave.addElementSlot("description", "?");
        interleave.addElementSlot("consume-remaining", "?");
        interleave.addHedgeSlot(ArgumentChoice.class, "?");
        interleave.addElementSlot("maximum", "?");
        interleave.addElementSlot("minimum", "?");
        interleave.addElementSlot("initial-separator", "?");
        interleave.addElementSlot("subsequent-separator", "?");
        interleave.addElementSlot(Validator.class, "?");
        if (interleave.isMatch()) {
            id_ = interleave.getElementPropertyAsBigInteger("id");
            description_ = interleave.getElementPropertyAsString("description");
            consumeRemaining_ = interleave.getElementPropertyAsString("consume-remaining");
            setArgumentChoice((ArgumentChoice)interleave.getProperty(ArgumentChoice.class));
            maximum_ = interleave.getElementPropertyAsBigInteger("maximum");
            minimum_ = interleave.getElementPropertyAsBigInteger("minimum");
            initialSeparator_ = interleave.getElementPropertyAsString("initial-separator");
            subsequentSeparator_ = interleave.getElementPropertyAsString("subsequent-separator");
            setValidator((Validator)interleave.getProperty(Validator.class));
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new Argument((Argument)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("argument");
        int size;
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.id_ != null) {
            URelaxer.setElementPropertyByBigInteger(element, "id", this.id_);
        }
        if (this.description_ != null) {
            URelaxer.setElementPropertyByString(element, "description", this.description_);
        }
        if (this.consumeRemaining_ != null) {
            URelaxer.setElementPropertyByString(element, "consume-remaining", this.consumeRemaining_);
        }
        if (this.argumentChoice_ != null) {
            this.argumentChoice_.makeElement(element);
        }
        if (this.maximum_ != null) {
            URelaxer.setElementPropertyByBigInteger(element, "maximum", this.maximum_);
        }
        if (this.minimum_ != null) {
            URelaxer.setElementPropertyByBigInteger(element, "minimum", this.minimum_);
        }
        if (this.initialSeparator_ != null) {
            URelaxer.setElementPropertyByString(element, "initial-separator", this.initialSeparator_);
        }
        if (this.subsequentSeparator_ != null) {
            URelaxer.setElementPropertyByString(element, "subsequent-separator", this.subsequentSeparator_);
        }
        if (this.validator_ != null) {
            this.validator_.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>Argument</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>Argument</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Argument</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Argument</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Argument</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Argument</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>name</b>.
     *
     * @return String
     */
    public String getName() {
        return (name_);
    }

    /**
     * Sets the String property <b>name</b>.
     *
     * @param name
     */
    public void setName(String name) {
        this.name_ = name;
    }

    /**
     * Gets the java.math.BigInteger property <b>id</b>.
     *
     * @return java.math.BigInteger
     */
    public java.math.BigInteger getId() {
        return (id_);
    }

    /**
     * Sets the java.math.BigInteger property <b>id</b>.
     *
     * @param id
     */
    public void setId(java.math.BigInteger id) {
        this.id_ = id;
    }

    /**
     * Gets the String property <b>description</b>.
     *
     * @return String
     */
    public String getDescription() {
        return (description_);
    }

    /**
     * Sets the String property <b>description</b>.
     *
     * @param description
     */
    public void setDescription(String description) {
        this.description_ = description;
    }

    /**
     * Gets the String property <b>consumeRemaining</b>.
     *
     * @return String
     */
    public String getConsumeRemaining() {
        return (consumeRemaining_);
    }

    /**
     * Sets the String property <b>consumeRemaining</b>.
     *
     * @param consumeRemaining
     */
    public void setConsumeRemaining(String consumeRemaining) {
        this.consumeRemaining_ = consumeRemaining;
    }

    /**
     * Gets the ArgumentChoice property <b>argumentChoice</b>.
     *
     * @return ArgumentChoice
     */
    public ArgumentChoice getArgumentChoice() {
        return (argumentChoice_);
    }

    /**
     * Sets the ArgumentChoice property <b>argumentChoice</b>.
     *
     * @param argumentChoice
     */
    public void setArgumentChoice(ArgumentChoice argumentChoice) {
        this.argumentChoice_ = argumentChoice;
    }

    /**
     * Gets the java.math.BigInteger property <b>maximum</b>.
     *
     * @return java.math.BigInteger
     */
    public java.math.BigInteger getMaximum() {
        return (maximum_);
    }

    /**
     * Sets the java.math.BigInteger property <b>maximum</b>.
     *
     * @param maximum
     */
    public void setMaximum(java.math.BigInteger maximum) {
        this.maximum_ = maximum;
    }

    /**
     * Gets the java.math.BigInteger property <b>minimum</b>.
     *
     * @return java.math.BigInteger
     */
    public java.math.BigInteger getMinimum() {
        return (minimum_);
    }

    /**
     * Sets the java.math.BigInteger property <b>minimum</b>.
     *
     * @param minimum
     */
    public void setMinimum(java.math.BigInteger minimum) {
        this.minimum_ = minimum;
    }

    /**
     * Gets the String property <b>initialSeparator</b>.
     *
     * @return String
     */
    public String getInitialSeparator() {
        return (initialSeparator_);
    }

    /**
     * Sets the String property <b>initialSeparator</b>.
     *
     * @param initialSeparator
     */
    public void setInitialSeparator(String initialSeparator) {
        this.initialSeparator_ = initialSeparator;
    }

    /**
     * Gets the String property <b>subsequentSeparator</b>.
     *
     * @return String
     */
    public String getSubsequentSeparator() {
        return (subsequentSeparator_);
    }

    /**
     * Sets the String property <b>subsequentSeparator</b>.
     *
     * @param subsequentSeparator
     */
    public void setSubsequentSeparator(String subsequentSeparator) {
        this.subsequentSeparator_ = subsequentSeparator;
    }

    /**
     * Gets the Validator property <b>validator</b>.
     *
     * @return Validator
     */
    public Validator getValidator() {
        return (validator_);
    }

    /**
     * Sets the Validator property <b>validator</b>.
     *
     * @param validator
     */
    public void setValidator(Validator validator) {
        this.validator_ = validator;
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<argument");
        if (name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.append("\"");
        }
        buffer.append(">");
        if (id_ != null) {
            buffer.append("<id>");
            buffer.append(URelaxer.getString(getId()));
            buffer.append("</id>");
        }
        if (description_ != null) {
            buffer.append("<description>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(getDescription())));
            buffer.append("</description>");
        }
        if (consumeRemaining_ != null) {
            buffer.append("<consume-remaining>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(getConsumeRemaining())));
            buffer.append("</consume-remaining>");
        }
        if (argumentChoice_ != null) {
            argumentChoice_.makeTextElement(buffer);
        }
        if (maximum_ != null) {
            buffer.append("<maximum>");
            buffer.append(URelaxer.getString(getMaximum()));
            buffer.append("</maximum>");
        }
        if (minimum_ != null) {
            buffer.append("<minimum>");
            buffer.append(URelaxer.getString(getMinimum()));
            buffer.append("</minimum>");
        }
        if (initialSeparator_ != null) {
            buffer.append("<initial-separator>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(getInitialSeparator())));
            buffer.append("</initial-separator>");
        }
        if (subsequentSeparator_ != null) {
            buffer.append("<subsequent-separator>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(getSubsequentSeparator())));
            buffer.append("</subsequent-separator>");
        }
        if (validator_ != null) {
            validator_.makeTextElement(buffer);
        }
        buffer.append("</argument>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<argument");
        if (name_ != null) {
            buffer.write(" name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.write("\"");
        }
        buffer.write(">");
        if (id_ != null) {
            buffer.write("<id>");
            buffer.write(URelaxer.getString(getId()));
            buffer.write("</id>");
        }
        if (description_ != null) {
            buffer.write("<description>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(getDescription())));
            buffer.write("</description>");
        }
        if (consumeRemaining_ != null) {
            buffer.write("<consume-remaining>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(getConsumeRemaining())));
            buffer.write("</consume-remaining>");
        }
        if (argumentChoice_ != null) {
            argumentChoice_.makeTextElement(buffer);
        }
        if (maximum_ != null) {
            buffer.write("<maximum>");
            buffer.write(URelaxer.getString(getMaximum()));
            buffer.write("</maximum>");
        }
        if (minimum_ != null) {
            buffer.write("<minimum>");
            buffer.write(URelaxer.getString(getMinimum()));
            buffer.write("</minimum>");
        }
        if (initialSeparator_ != null) {
            buffer.write("<initial-separator>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(getInitialSeparator())));
            buffer.write("</initial-separator>");
        }
        if (subsequentSeparator_ != null) {
            buffer.write("<subsequent-separator>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(getSubsequentSeparator())));
            buffer.write("</subsequent-separator>");
        }
        if (validator_ != null) {
            validator_.makeTextElement(buffer);
        }
        buffer.write("</argument>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<argument");
        if (name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.print("\"");
        }
        buffer.print(">");
        if (id_ != null) {
            buffer.print("<id>");
            buffer.print(URelaxer.getString(getId()));
            buffer.print("</id>");
        }
        if (description_ != null) {
            buffer.print("<description>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(getDescription())));
            buffer.print("</description>");
        }
        if (consumeRemaining_ != null) {
            buffer.print("<consume-remaining>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(getConsumeRemaining())));
            buffer.print("</consume-remaining>");
        }
        if (argumentChoice_ != null) {
            argumentChoice_.makeTextElement(buffer);
        }
        if (maximum_ != null) {
            buffer.print("<maximum>");
            buffer.print(URelaxer.getString(getMaximum()));
            buffer.print("</maximum>");
        }
        if (minimum_ != null) {
            buffer.print("<minimum>");
            buffer.print(URelaxer.getString(getMinimum()));
            buffer.print("</minimum>");
        }
        if (initialSeparator_ != null) {
            buffer.print("<initial-separator>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(getInitialSeparator())));
            buffer.print("</initial-separator>");
        }
        if (subsequentSeparator_ != null) {
            buffer.print("<subsequent-separator>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(getSubsequentSeparator())));
            buffer.print("</subsequent-separator>");
        }
        if (validator_ != null) {
            validator_.makeTextElement(buffer);
        }
        buffer.print("</argument>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getNameAsString() {
        return (URelaxer.getString(getName()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getIdAsString() {
        return (URelaxer.getString(getId()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getDescriptionAsString() {
        return (URelaxer.getString(getDescription()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getConsumeRemainingAsString() {
        return (URelaxer.getString(getConsumeRemaining()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getMaximumAsString() {
        return (URelaxer.getString(getMaximum()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getMinimumAsString() {
        return (URelaxer.getString(getMinimum()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getInitialSeparatorAsString() {
        return (URelaxer.getString(getInitialSeparator()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getSubsequentSeparatorAsString() {
        return (URelaxer.getString(getSubsequentSeparator()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setNameByString(String string) {
        setName(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setIdByString(String string) {
        setId(new java.math.BigInteger(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setDescriptionByString(String string) {
        setDescription(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setConsumeRemainingByString(String string) {
        setConsumeRemaining(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setMaximumByString(String string) {
        setMaximum(new java.math.BigInteger(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setMinimumByString(String string) {
        setMinimum(new java.math.BigInteger(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setInitialSeparatorByString(String string) {
        setInitialSeparator(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setSubsequentSeparatorByString(String string) {
        setSubsequentSeparator(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>Argument</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "argument")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        RInterleave interleave;
        if (!URelaxer.hasAttributeHungry(target, "name")) {
            return (false);
        }
        $match$ = true;
        interleave = new RInterleave(target);
        interleave.addElementSlot("id", "?");
        interleave.addElementSlot("description", "?");
        interleave.addElementSlot("consume-remaining", "?");
        interleave.addHedgeSlot(ArgumentChoice.class, "?");
        interleave.addElementSlot("maximum", "?");
        interleave.addElementSlot("minimum", "?");
        interleave.addElementSlot("initial-separator", "?");
        interleave.addElementSlot("subsequent-separator", "?");
        interleave.addElementSlot(Validator.class, "?");
        if (interleave.isMatch()) {
            $match$ = true;
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Argument</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Argument</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
