package jp.sourceforge.talisman.xmlcli.builder;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.commons.cli2.validation.EnumValidator;
import org.apache.commons.cli2.validation.InvalidArgumentException;
import org.apache.commons.cli2.validation.Validator;

class DelayedEnumValidator implements Validator{
	private Set<Object> set = new HashSet<Object>();
	private Validator validator;

	public void addValue(Object value){
		set.add(value);
		validator = null;
	}

	public void removeValue(Object value){
		set.remove(value);
		validator = null;
	}

	@SuppressWarnings("unchecked")
	public void validate(List list) throws InvalidArgumentException {
		if(validator == null){
			validator = new EnumValidator(set);
		}
		validate(list);
	}
}
