package jp.sourceforge.talisman.xmlcli.builder;

/*
 * $Id: AbstractOptionsBuilder.java,v 1.2 2006/02/26 09:47:59 harua-t Exp $
 */

import java.io.IOException;
import java.io.InputStream;

import jp.sourceforge.talisman.xmlcli.OptionsBuilder;

import org.apache.commons.cli2.Group;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;

/**
 * Abstract class of {@link OptionsBuilder <code>OptionsBuilder</code>}.
 * 
 * @author Haruaki TAMADA
 * @version $Revision: 1.2 $ $Date: 2006/02/26 09:47:59 $
 */
public abstract class AbstractOptionsBuilder implements OptionsBuilder{
    private InputStream in;

    public AbstractOptionsBuilder(InputStream in){
        this.in = in;
    }

    public InputStream getStream(){
        return in;
    }

    public abstract String getDefinitionName();

    public abstract Group buildOptions() throws IOException, SAXException, DOMException;
}
