package jp.sourceforge.talisman.xmlcli;

import java.io.FileInputStream;
import java.io.IOException;

import jp.sourceforge.talisman.xmlcli.builder.OptionsBuilderFactory;

import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.util.HelpFormatter;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision$ $Date$
 */
public class XmlCli {
	private String name;
	private Group options;

	public XmlCli(String xmlfile){
		parseOptions(xmlfile);
	}

	public Group getOptions()	{
		return options;
	}

	public void printHelp(){
		printHelp("syntax");
	}

	public void printHelp(String syntax){
		HelpFormatter formatter = new HelpFormatter();
		formatter.setShellCommand(name);
		formatter.setGroup(options);
		formatter.print();
	}

	private void parseOptions(String file){
		try{
		    OptionsBuilderFactory factory = OptionsBuilderFactory.getInstance();
		    OptionsBuilder builder = factory.createBuilder(new FileInputStream(file));
		    options = builder.buildOptions();
		    name = builder.getDefinitionName();

		} catch(DOMException e){
		    // some exception handle process...
		} catch(SAXException e){
		    // some exception handle process...
		} catch(IOException e){
		    // some exception handle process...
		}
	}

	public static void main(String[] args){
		for(String arg: args){
			new XmlCli(arg).printHelp();
		}
	}
}
