package jp.sourceforge.talisman.xmlcli;

/*
 * $Id: OptionsBuilder.java,v 1.2 2006/02/26 09:47:59 harua-t Exp $
 */

import java.io.IOException;

import org.apache.commons.cli2.Group;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;

/**
 * <a href="http://jakarta.apache.org/commons/cli/">Jakarta Commons
 * CLI</a> is very useful.  However, if the structur of options is
 * complexed, to build a instance of Options are tired and uncool.
 * The best solution I think, the structur of options is described in
 * some configuration file, and build the instance of Options at
 * runtime by {@link OptionsBuilder <code>OptionsBuilder</code>}.
 *
 * @author Haruaki TAMADA
 * @version $Revision: 1.2 $ $Date: 2006/02/26 09:47:59 $
 */
public interface OptionsBuilder{
    public String getDefinitionName();

    public Group buildOptions() throws IOException, SAXException, DOMException;
}
