/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.xmlcli.builder.relaxer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.ArgumentChoice;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.IOptionChoiceChoice;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.RInterleave;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.RStack;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.UJAXP;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.URelaxer;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Argument
implements Serializable,
Cloneable,
IOptionChoiceChoice {
    private String name_;
    private BigInteger id_;
    private String description_;
    private String consumeRemaining_;
    private ArgumentChoice argumentChoice_;
    private BigInteger maximum_;
    private BigInteger minimum_;
    private String initialSeparator_;
    private String subsequentSeparator_;
    private Validator validator_;

    public Argument() {
        this.name_ = "";
    }

    public Argument(Argument source) {
        this.setup(source);
    }

    public Argument(RStack stack) {
        this.setup(stack);
    }

    public Argument(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Argument(Element element) {
        this.setup(element);
    }

    public Argument(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Argument(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Argument(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Argument(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Argument(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Argument(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Argument source) {
        this.name_ = source.name_;
        this.id_ = source.id_;
        this.description_ = source.description_;
        this.consumeRemaining_ = source.consumeRemaining_;
        if (source.argumentChoice_ != null) {
            this.setArgumentChoice((ArgumentChoice)source.getArgumentChoice().clone());
        }
        this.maximum_ = source.maximum_;
        this.minimum_ = source.minimum_;
        this.initialSeparator_ = source.initialSeparator_;
        this.subsequentSeparator_ = source.subsequentSeparator_;
        if (source.validator_ != null) {
            this.setValidator((Validator)source.getValidator().clone());
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
        RInterleave interleave = new RInterleave(stack);
        interleave.addElementSlot("id", "?");
        interleave.addElementSlot("description", "?");
        interleave.addElementSlot("consume-remaining", "?");
        interleave.addHedgeSlot(ArgumentChoice.class, "?");
        interleave.addElementSlot("maximum", "?");
        interleave.addElementSlot("minimum", "?");
        interleave.addElementSlot("initial-separator", "?");
        interleave.addElementSlot("subsequent-separator", "?");
        interleave.addElementSlot(Validator.class, "?");
        if (interleave.isMatch()) {
            this.id_ = interleave.getElementPropertyAsBigInteger("id");
            this.description_ = interleave.getElementPropertyAsString("description");
            this.consumeRemaining_ = interleave.getElementPropertyAsString("consume-remaining");
            this.setArgumentChoice((ArgumentChoice)interleave.getProperty(ArgumentChoice.class));
            this.maximum_ = interleave.getElementPropertyAsBigInteger("maximum");
            this.minimum_ = interleave.getElementPropertyAsBigInteger("minimum");
            this.initialSeparator_ = interleave.getElementPropertyAsString("initial-separator");
            this.subsequentSeparator_ = interleave.getElementPropertyAsString("subsequent-separator");
            this.setValidator((Validator)interleave.getProperty(Validator.class));
        }
    }

    public Object clone() {
        return new Argument(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("argument");
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.id_ != null) {
            URelaxer.setElementPropertyByBigInteger(element, "id", this.id_);
        }
        if (this.description_ != null) {
            URelaxer.setElementPropertyByString(element, "description", this.description_);
        }
        if (this.consumeRemaining_ != null) {
            URelaxer.setElementPropertyByString(element, "consume-remaining", this.consumeRemaining_);
        }
        if (this.argumentChoice_ != null) {
            this.argumentChoice_.makeElement(element);
        }
        if (this.maximum_ != null) {
            URelaxer.setElementPropertyByBigInteger(element, "maximum", this.maximum_);
        }
        if (this.minimum_ != null) {
            URelaxer.setElementPropertyByBigInteger(element, "minimum", this.minimum_);
        }
        if (this.initialSeparator_ != null) {
            URelaxer.setElementPropertyByString(element, "initial-separator", this.initialSeparator_);
        }
        if (this.subsequentSeparator_ != null) {
            URelaxer.setElementPropertyByString(element, "subsequent-separator", this.subsequentSeparator_);
        }
        if (this.validator_ != null) {
            this.validator_.makeElement(element);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public BigInteger getId() {
        return this.id_;
    }

    public void setId(BigInteger id) {
        this.id_ = id;
    }

    public String getDescription() {
        return this.description_;
    }

    public void setDescription(String description) {
        this.description_ = description;
    }

    public String getConsumeRemaining() {
        return this.consumeRemaining_;
    }

    public void setConsumeRemaining(String consumeRemaining) {
        this.consumeRemaining_ = consumeRemaining;
    }

    public ArgumentChoice getArgumentChoice() {
        return this.argumentChoice_;
    }

    public void setArgumentChoice(ArgumentChoice argumentChoice) {
        this.argumentChoice_ = argumentChoice;
    }

    public BigInteger getMaximum() {
        return this.maximum_;
    }

    public void setMaximum(BigInteger maximum) {
        this.maximum_ = maximum;
    }

    public BigInteger getMinimum() {
        return this.minimum_;
    }

    public void setMinimum(BigInteger minimum) {
        this.minimum_ = minimum;
    }

    public String getInitialSeparator() {
        return this.initialSeparator_;
    }

    public void setInitialSeparator(String initialSeparator) {
        this.initialSeparator_ = initialSeparator;
    }

    public String getSubsequentSeparator() {
        return this.subsequentSeparator_;
    }

    public void setSubsequentSeparator(String subsequentSeparator) {
        this.subsequentSeparator_ = subsequentSeparator;
    }

    public Validator getValidator() {
        return this.validator_;
    }

    public void setValidator(Validator validator) {
        this.validator_ = validator;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<argument");
        if (this.name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.append("\"");
        }
        buffer.append(">");
        if (this.id_ != null) {
            buffer.append("<id>");
            buffer.append(URelaxer.getString(this.getId()));
            buffer.append("</id>");
        }
        if (this.description_ != null) {
            buffer.append("<description>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getDescription())));
            buffer.append("</description>");
        }
        if (this.consumeRemaining_ != null) {
            buffer.append("<consume-remaining>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getConsumeRemaining())));
            buffer.append("</consume-remaining>");
        }
        if (this.argumentChoice_ != null) {
            this.argumentChoice_.makeTextElement(buffer);
        }
        if (this.maximum_ != null) {
            buffer.append("<maximum>");
            buffer.append(URelaxer.getString(this.getMaximum()));
            buffer.append("</maximum>");
        }
        if (this.minimum_ != null) {
            buffer.append("<minimum>");
            buffer.append(URelaxer.getString(this.getMinimum()));
            buffer.append("</minimum>");
        }
        if (this.initialSeparator_ != null) {
            buffer.append("<initial-separator>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getInitialSeparator())));
            buffer.append("</initial-separator>");
        }
        if (this.subsequentSeparator_ != null) {
            buffer.append("<subsequent-separator>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getSubsequentSeparator())));
            buffer.append("</subsequent-separator>");
        }
        if (this.validator_ != null) {
            this.validator_.makeTextElement(buffer);
        }
        buffer.append("</argument>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<argument");
        if (this.name_ != null) {
            buffer.write(" name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.write("\"");
        }
        buffer.write(">");
        if (this.id_ != null) {
            buffer.write("<id>");
            buffer.write(URelaxer.getString(this.getId()));
            buffer.write("</id>");
        }
        if (this.description_ != null) {
            buffer.write("<description>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getDescription())));
            buffer.write("</description>");
        }
        if (this.consumeRemaining_ != null) {
            buffer.write("<consume-remaining>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getConsumeRemaining())));
            buffer.write("</consume-remaining>");
        }
        if (this.argumentChoice_ != null) {
            this.argumentChoice_.makeTextElement(buffer);
        }
        if (this.maximum_ != null) {
            buffer.write("<maximum>");
            buffer.write(URelaxer.getString(this.getMaximum()));
            buffer.write("</maximum>");
        }
        if (this.minimum_ != null) {
            buffer.write("<minimum>");
            buffer.write(URelaxer.getString(this.getMinimum()));
            buffer.write("</minimum>");
        }
        if (this.initialSeparator_ != null) {
            buffer.write("<initial-separator>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getInitialSeparator())));
            buffer.write("</initial-separator>");
        }
        if (this.subsequentSeparator_ != null) {
            buffer.write("<subsequent-separator>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getSubsequentSeparator())));
            buffer.write("</subsequent-separator>");
        }
        if (this.validator_ != null) {
            this.validator_.makeTextElement(buffer);
        }
        buffer.write("</argument>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<argument");
        if (this.name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.print("\"");
        }
        buffer.print(">");
        if (this.id_ != null) {
            buffer.print("<id>");
            buffer.print(URelaxer.getString(this.getId()));
            buffer.print("</id>");
        }
        if (this.description_ != null) {
            buffer.print("<description>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getDescription())));
            buffer.print("</description>");
        }
        if (this.consumeRemaining_ != null) {
            buffer.print("<consume-remaining>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getConsumeRemaining())));
            buffer.print("</consume-remaining>");
        }
        if (this.argumentChoice_ != null) {
            this.argumentChoice_.makeTextElement(buffer);
        }
        if (this.maximum_ != null) {
            buffer.print("<maximum>");
            buffer.print(URelaxer.getString(this.getMaximum()));
            buffer.print("</maximum>");
        }
        if (this.minimum_ != null) {
            buffer.print("<minimum>");
            buffer.print(URelaxer.getString(this.getMinimum()));
            buffer.print("</minimum>");
        }
        if (this.initialSeparator_ != null) {
            buffer.print("<initial-separator>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getInitialSeparator())));
            buffer.print("</initial-separator>");
        }
        if (this.subsequentSeparator_ != null) {
            buffer.print("<subsequent-separator>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getSubsequentSeparator())));
            buffer.print("</subsequent-separator>");
        }
        if (this.validator_ != null) {
            this.validator_.makeTextElement(buffer);
        }
        buffer.print("</argument>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getNameAsString() {
        return URelaxer.getString(this.getName());
    }

    public String getIdAsString() {
        return URelaxer.getString(this.getId());
    }

    public String getDescriptionAsString() {
        return URelaxer.getString(this.getDescription());
    }

    public String getConsumeRemainingAsString() {
        return URelaxer.getString(this.getConsumeRemaining());
    }

    public String getMaximumAsString() {
        return URelaxer.getString(this.getMaximum());
    }

    public String getMinimumAsString() {
        return URelaxer.getString(this.getMinimum());
    }

    public String getInitialSeparatorAsString() {
        return URelaxer.getString(this.getInitialSeparator());
    }

    public String getSubsequentSeparatorAsString() {
        return URelaxer.getString(this.getSubsequentSeparator());
    }

    public void setNameByString(String string) {
        this.setName(string);
    }

    public void setIdByString(String string) {
        this.setId(new BigInteger(string));
    }

    public void setDescriptionByString(String string) {
        this.setDescription(string);
    }

    public void setConsumeRemainingByString(String string) {
        this.setConsumeRemaining(string);
    }

    public void setMaximumByString(String string) {
        this.setMaximum(new BigInteger(string));
    }

    public void setMinimumByString(String string) {
        this.setMinimum(new BigInteger(string));
    }

    public void setInitialSeparatorByString(String string) {
        this.setInitialSeparator(string);
    }

    public void setSubsequentSeparatorByString(String string) {
        this.setSubsequentSeparator(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "argument")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (!URelaxer.hasAttributeHungry(target, "name")) {
            return false;
        }
        $match$ = true;
        RInterleave interleave = new RInterleave(target);
        interleave.addElementSlot("id", "?");
        interleave.addElementSlot("description", "?");
        interleave.addElementSlot("consume-remaining", "?");
        interleave.addHedgeSlot(ArgumentChoice.class, "?");
        interleave.addElementSlot("maximum", "?");
        interleave.addElementSlot("minimum", "?");
        interleave.addElementSlot("initial-separator", "?");
        interleave.addElementSlot("subsequent-separator", "?");
        interleave.addElementSlot(Validator.class, "?");
        if (interleave.isMatch()) {
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Argument.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Argument.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

