/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.xmlcli;

import java.io.FileInputStream;
import java.io.IOException;
import jp.sourceforge.talisman.xmlcli.OptionsBuilder;
import jp.sourceforge.talisman.xmlcli.builder.OptionsBuilderFactory;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.util.HelpFormatter;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;

public class XmlCli {
    private String name;
    private Group options;

    public XmlCli(String xmlfile) {
        this.parseOptions(xmlfile);
    }

    public Group getOptions() {
        return this.options;
    }

    public void printHelp() {
        this.printHelp("syntax");
    }

    public void printHelp(String syntax) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setShellCommand(this.name);
        formatter.setGroup(this.options);
        formatter.print();
    }

    private void parseOptions(String file) {
        try {
            OptionsBuilderFactory factory = OptionsBuilderFactory.getInstance();
            OptionsBuilder builder = factory.createBuilder(new FileInputStream(file));
            this.options = builder.buildOptions();
            this.name = builder.getDefinitionName();
        }
        catch (DOMException dOMException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            new XmlCli(arg).printHelp();
            ++n2;
        }
    }
}

