/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.xmlcli.builder.relaxer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.Children;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.IOptionsChoice;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.OptionChoice;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.RInterleave;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.RStack;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.UJAXP;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Option
implements Serializable,
Cloneable,
IOptionsChoice {
    private String name_;
    private List shortName_ = new ArrayList();
    private String longName_;
    private BigInteger id_;
    private String description_;
    private Boolean required_;
    private OptionChoice optionChoice_;
    private Children children_;

    public Option() {
        this.name_ = "";
    }

    public Option(Option source) {
        this.setup(source);
    }

    public Option(RStack stack) {
        this.setup(stack);
    }

    public Option(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Option(Element element) {
        this.setup(element);
    }

    public Option(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Option(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Option(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Option(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Option(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Option(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Option source) {
        this.name_ = source.name_;
        this.setShortName(source.getShortName());
        this.longName_ = source.longName_;
        this.id_ = source.id_;
        this.description_ = source.description_;
        this.required_ = source.required_;
        if (source.optionChoice_ != null) {
            this.setOptionChoice((OptionChoice)source.getOptionChoice().clone());
        }
        if (source.children_ != null) {
            this.setChildren((Children)source.getChildren().clone());
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
        RInterleave interleave = new RInterleave(stack);
        interleave.addElementSlot("short-name", "*");
        interleave.addElementSlot("long-name", "?");
        interleave.addElementSlot("id", "?");
        interleave.addElementSlot("description", "?");
        interleave.addElementSlot("required", "?");
        interleave.addHedgeSlot(OptionChoice.class, "?");
        interleave.addElementSlot(Children.class, "?");
        if (interleave.isMatch()) {
            this.shortName_ = interleave.getElementPropertyAsStringList("short-name");
            this.longName_ = interleave.getElementPropertyAsString("long-name");
            this.id_ = interleave.getElementPropertyAsBigInteger("id");
            this.description_ = interleave.getElementPropertyAsString("description");
            this.required_ = interleave.getElementPropertyAsBooleanObject("required");
            this.setOptionChoice((OptionChoice)interleave.getProperty(OptionChoice.class));
            this.setChildren((Children)interleave.getProperty(Children.class));
        }
    }

    public Object clone() {
        return new Option(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("option");
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        URelaxer.setElementPropertyByStringList(element, "short-name", this.shortName_);
        if (this.longName_ != null) {
            URelaxer.setElementPropertyByString(element, "long-name", this.longName_);
        }
        if (this.id_ != null) {
            URelaxer.setElementPropertyByBigInteger(element, "id", this.id_);
        }
        if (this.description_ != null) {
            URelaxer.setElementPropertyByString(element, "description", this.description_);
        }
        if (this.required_ != null) {
            URelaxer.setElementPropertyByBoolean(element, "required", this.required_);
        }
        if (this.optionChoice_ != null) {
            this.optionChoice_.makeElement(element);
        }
        if (this.children_ != null) {
            this.children_.makeElement(element);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public String[] getShortName() {
        String[] array = new String[this.shortName_.size()];
        return this.shortName_.toArray(array);
    }

    public void setShortName(String[] shortName) {
        this.shortName_.clear();
        int i = 0;
        while (i < shortName.length) {
            this.addShortName(shortName[i]);
            ++i;
        }
    }

    public void setShortName(String shortName) {
        this.shortName_.clear();
        this.addShortName(shortName);
    }

    public void addShortName(String shortName) {
        this.shortName_.add(shortName);
    }

    public void addShortName(String[] shortName) {
        int i = 0;
        while (i < shortName.length) {
            this.addShortName(shortName[i]);
            ++i;
        }
    }

    public int sizeShortName() {
        return this.shortName_.size();
    }

    public String getShortName(int index) {
        return (String)this.shortName_.get(index);
    }

    public void setShortName(int index, String shortName) {
        this.shortName_.set(index, shortName);
    }

    public void addShortName(int index, String shortName) {
        this.shortName_.add(index, shortName);
    }

    public void removeShortName(int index) {
        this.shortName_.remove(index);
    }

    public void removeShortName(String shortName) {
        this.shortName_.remove(shortName);
    }

    public void clearShortName() {
        this.shortName_.clear();
    }

    public String getLongName() {
        return this.longName_;
    }

    public void setLongName(String longName) {
        this.longName_ = longName;
    }

    public BigInteger getId() {
        return this.id_;
    }

    public void setId(BigInteger id) {
        this.id_ = id;
    }

    public String getDescription() {
        return this.description_;
    }

    public void setDescription(String description) {
        this.description_ = description;
    }

    public boolean getRequired() {
        if (this.required_ == null) {
            return false;
        }
        return this.required_;
    }

    public boolean getRequired(boolean required) {
        if (this.required_ == null) {
            return required;
        }
        return this.required_;
    }

    public Boolean getRequiredAsBoolean() {
        return this.required_;
    }

    public boolean checkRequired() {
        return this.required_ != null;
    }

    public void setRequired(boolean required) {
        this.required_ = new Boolean(required);
    }

    public void setRequired(Boolean required) {
        this.required_ = required;
    }

    public OptionChoice getOptionChoice() {
        return this.optionChoice_;
    }

    public void setOptionChoice(OptionChoice optionChoice) {
        this.optionChoice_ = optionChoice;
    }

    public Children getChildren() {
        return this.children_;
    }

    public void setChildren(Children children) {
        this.children_ = children;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<option");
        if (this.name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.append("\"");
        }
        buffer.append(">");
        int size = this.sizeShortName();
        int i = 0;
        while (i < size) {
            buffer.append("<short-name>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getShortName(i))));
            buffer.append("</short-name>");
            ++i;
        }
        if (this.longName_ != null) {
            buffer.append("<long-name>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getLongName())));
            buffer.append("</long-name>");
        }
        if (this.id_ != null) {
            buffer.append("<id>");
            buffer.append(URelaxer.getString(this.getId()));
            buffer.append("</id>");
        }
        if (this.description_ != null) {
            buffer.append("<description>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getDescription())));
            buffer.append("</description>");
        }
        if (this.required_ != null) {
            buffer.append("<required>");
            buffer.append(URelaxer.getString(this.getRequired()));
            buffer.append("</required>");
        }
        if (this.optionChoice_ != null) {
            this.optionChoice_.makeTextElement(buffer);
        }
        if (this.children_ != null) {
            this.children_.makeTextElement(buffer);
        }
        buffer.append("</option>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<option");
        if (this.name_ != null) {
            buffer.write(" name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.write("\"");
        }
        buffer.write(">");
        int size = this.sizeShortName();
        int i = 0;
        while (i < size) {
            buffer.write("<short-name>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getShortName(i))));
            buffer.write("</short-name>");
            ++i;
        }
        if (this.longName_ != null) {
            buffer.write("<long-name>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getLongName())));
            buffer.write("</long-name>");
        }
        if (this.id_ != null) {
            buffer.write("<id>");
            buffer.write(URelaxer.getString(this.getId()));
            buffer.write("</id>");
        }
        if (this.description_ != null) {
            buffer.write("<description>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getDescription())));
            buffer.write("</description>");
        }
        if (this.required_ != null) {
            buffer.write("<required>");
            buffer.write(URelaxer.getString(this.getRequired()));
            buffer.write("</required>");
        }
        if (this.optionChoice_ != null) {
            this.optionChoice_.makeTextElement(buffer);
        }
        if (this.children_ != null) {
            this.children_.makeTextElement(buffer);
        }
        buffer.write("</option>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<option");
        if (this.name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.print("\"");
        }
        buffer.print(">");
        int size = this.sizeShortName();
        int i = 0;
        while (i < size) {
            buffer.print("<short-name>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getShortName(i))));
            buffer.print("</short-name>");
            ++i;
        }
        if (this.longName_ != null) {
            buffer.print("<long-name>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getLongName())));
            buffer.print("</long-name>");
        }
        if (this.id_ != null) {
            buffer.print("<id>");
            buffer.print(URelaxer.getString(this.getId()));
            buffer.print("</id>");
        }
        if (this.description_ != null) {
            buffer.print("<description>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getDescription())));
            buffer.print("</description>");
        }
        if (this.required_ != null) {
            buffer.print("<required>");
            buffer.print(URelaxer.getString(this.getRequired()));
            buffer.print("</required>");
        }
        if (this.optionChoice_ != null) {
            this.optionChoice_.makeTextElement(buffer);
        }
        if (this.children_ != null) {
            this.children_.makeTextElement(buffer);
        }
        buffer.print("</option>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getNameAsString() {
        return URelaxer.getString(this.getName());
    }

    public String[] getShortNameAsString() {
        int size = this.sizeShortName();
        String[] array = new String[size];
        int i = 0;
        while (i < size) {
            array[i] = URelaxer.getString(this.getShortName(i));
            ++i;
        }
        return array;
    }

    public String getShortNameAsString(int index) {
        return URelaxer.getString(this.getShortName(index));
    }

    public String getLongNameAsString() {
        return URelaxer.getString(this.getLongName());
    }

    public String getIdAsString() {
        return URelaxer.getString(this.getId());
    }

    public String getDescriptionAsString() {
        return URelaxer.getString(this.getDescription());
    }

    public String getRequiredAsString() {
        return URelaxer.getString(this.getRequired());
    }

    public void setNameByString(String string) {
        this.setName(string);
    }

    public void setShortNameByString(String[] strings) {
        if (strings.length > 0) {
            String string = strings[0];
            this.setShortName(string);
            int i = 1;
            while (i < strings.length) {
                string = strings[i];
                this.addShortName(string);
                ++i;
            }
        }
    }

    public void setShortNameByString(int index, String value) {
        this.setShortName(index, value);
    }

    public void setLongNameByString(String string) {
        this.setLongName(string);
    }

    public void setIdByString(String string) {
        this.setId(new BigInteger(string));
    }

    public void setDescriptionByString(String string) {
        this.setDescription(string);
    }

    public void setRequiredByString(String string) {
        this.setRequired((boolean)new Boolean(string));
    }

    public void addShortNameByString(String string) {
        this.addShortName(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "option")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (!URelaxer.hasAttributeHungry(target, "name")) {
            return false;
        }
        $match$ = true;
        RInterleave interleave = new RInterleave(target);
        interleave.addElementSlot("short-name", "*");
        interleave.addElementSlot("long-name", "?");
        interleave.addElementSlot("id", "?");
        interleave.addElementSlot("description", "?");
        interleave.addElementSlot("required", "?");
        interleave.addHedgeSlot(OptionChoice.class, "?");
        interleave.addElementSlot(Children.class, "?");
        if (interleave.isMatch()) {
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Option.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Option.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

