/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.commandline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.commandline.CommandLineImpl;

public class DefaultingCommandLine
extends CommandLineImpl {
    private final List commandLines = new ArrayList();

    public void appendCommandLine(CommandLine commandLine) {
        this.commandLines.add(commandLine);
    }

    public void insertCommandLine(int index, CommandLine commandLine) {
        this.commandLines.add(index, commandLine);
    }

    public Iterator commandLines() {
        return Collections.unmodifiableList(this.commandLines).iterator();
    }

    public Option getOption(String trigger) {
        Iterator i = this.commandLines.iterator();
        while (i.hasNext()) {
            CommandLine commandLine = (CommandLine)i.next();
            Option actual = commandLine.getOption(trigger);
            if (actual == null) continue;
            return actual;
        }
        return null;
    }

    public List getOptions() {
        ArrayList options = new ArrayList();
        ArrayList temp = new ArrayList();
        Iterator i = this.commandLines.iterator();
        while (i.hasNext()) {
            CommandLine commandLine = (CommandLine)i.next();
            temp.clear();
            temp.addAll(commandLine.getOptions());
            temp.removeAll(options);
            options.addAll(temp);
        }
        return Collections.unmodifiableList(options);
    }

    public Set getOptionTriggers() {
        HashSet all = new HashSet();
        Iterator i = this.commandLines.iterator();
        while (i.hasNext()) {
            CommandLine commandLine = (CommandLine)i.next();
            all.addAll(commandLine.getOptionTriggers());
        }
        return Collections.unmodifiableSet(all);
    }

    public boolean hasOption(Option option) {
        Iterator i = this.commandLines.iterator();
        while (i.hasNext()) {
            CommandLine commandLine = (CommandLine)i.next();
            if (!commandLine.hasOption(option)) continue;
            return true;
        }
        return false;
    }

    public List getValues(Option option, List defaultValues) {
        Iterator i = this.commandLines.iterator();
        while (i.hasNext()) {
            CommandLine commandLine = (CommandLine)i.next();
            List actual = commandLine.getValues(option);
            if (actual == null || actual.isEmpty()) continue;
            return actual;
        }
        if (defaultValues == null) {
            return Collections.EMPTY_LIST;
        }
        return defaultValues;
    }

    public Boolean getSwitch(Option option, Boolean defaultValue) {
        Iterator i = this.commandLines.iterator();
        while (i.hasNext()) {
            CommandLine commandLine = (CommandLine)i.next();
            Boolean actual = commandLine.getSwitch(option);
            if (actual == null) continue;
            return actual;
        }
        return defaultValue;
    }

    public String getProperty(String property, String defaultValue) {
        Iterator i = this.commandLines.iterator();
        while (i.hasNext()) {
            CommandLine commandLine = (CommandLine)i.next();
            String actual = commandLine.getProperty(property);
            if (actual == null) continue;
            return actual;
        }
        return defaultValue;
    }

    public Set getProperties() {
        HashSet all = new HashSet();
        Iterator i = this.commandLines.iterator();
        while (i.hasNext()) {
            CommandLine commandLine = (CommandLine)i.next();
            all.addAll(commandLine.getProperties());
        }
        return Collections.unmodifiableSet(all);
    }
}

