/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.xmlcli.builder.relaxer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.IValidatorChoice;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.Properties;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.RStack;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.UJAXP;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.URelaxer;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.ValidatorClassName;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.ValidatorType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Validator
implements Serializable,
Cloneable {
    private IValidatorChoice content_;
    private Properties properties_;

    public Validator() {
    }

    public Validator(Validator source) {
        this.setup(source);
    }

    public Validator(RStack stack) {
        this.setup(stack);
    }

    public Validator(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Validator(Element element) {
        this.setup(element);
    }

    public Validator(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Validator(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Validator(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Validator(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Validator(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Validator(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Validator source) {
        if (source.content_ != null) {
            this.setContent((IValidatorChoice)source.getContent().clone());
        }
        if (source.properties_ != null) {
            this.setProperties((Properties)source.getProperties().clone());
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        if (ValidatorClassName.isMatch(stack)) {
            this.setContent(new ValidatorClassName(stack));
        } else if (ValidatorType.isMatch(stack)) {
            this.setContent(new ValidatorType(stack));
        } else {
            throw new IllegalArgumentException();
        }
        this.setProperties(new Properties(stack));
    }

    public Object clone() {
        return new Validator(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("validator");
        this.content_.makeElement(element);
        this.properties_.makeElement(element);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public IValidatorChoice getContent() {
        return this.content_;
    }

    public void setContent(IValidatorChoice content) {
        this.content_ = content;
    }

    public Properties getProperties() {
        return this.properties_;
    }

    public void setProperties(Properties properties) {
        this.properties_ = properties;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<validator");
        this.content_.makeTextAttribute(buffer);
        buffer.append(">");
        this.content_.makeTextElement(buffer);
        this.properties_.makeTextElement(buffer);
        buffer.append("</validator>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<validator");
        this.content_.makeTextAttribute(buffer);
        buffer.write(">");
        this.content_.makeTextElement(buffer);
        this.properties_.makeTextElement(buffer);
        buffer.write("</validator>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<validator");
        this.content_.makeTextAttribute(buffer);
        buffer.print(">");
        this.content_.makeTextElement(buffer);
        this.properties_.makeTextElement(buffer);
        buffer.print("</validator>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "validator")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (ValidatorClassName.isMatchHungry(target)) {
            $match$ = true;
        } else if (ValidatorType.isMatchHungry(target)) {
            $match$ = true;
        } else {
            return false;
        }
        if (!Properties.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Validator.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Validator.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

