/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.Map;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ExportResourcesAction;
import org.eclipse.ui.actions.ImportResourcesAction;
import org.eclipse.ui.actions.LabelRetargetAction;
import org.eclipse.ui.actions.NewWizardAction;
import org.eclipse.ui.actions.NewWizardDropDownAction;
import org.eclipse.ui.actions.OpenInNewWindowAction;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.internal.CloseAllPerspectivesAction;
import org.eclipse.ui.internal.CloseAllSavedAction;
import org.eclipse.ui.internal.ClosePerspectiveAction;
import org.eclipse.ui.internal.EditActionSetsAction;
import org.eclipse.ui.internal.IntroAction;
import org.eclipse.ui.internal.LockToolBarAction;
import org.eclipse.ui.internal.MaximizePartAction;
import org.eclipse.ui.internal.MinimizePartAction;
import org.eclipse.ui.internal.NavigationHistoryAction;
import org.eclipse.ui.internal.OpenPreferencesAction;
import org.eclipse.ui.internal.QuickAccessMenu;
import org.eclipse.ui.internal.QuitAction;
import org.eclipse.ui.internal.ResetPerspectiveAction;
import org.eclipse.ui.internal.SaveAction;
import org.eclipse.ui.internal.SaveAllAction;
import org.eclipse.ui.internal.SaveAsAction;
import org.eclipse.ui.internal.SavePerspectiveAction;
import org.eclipse.ui.internal.ToggleEditorsVisibilityAction;
import org.eclipse.ui.internal.WorkbenchEditorsAction;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbookEditorsAction;
import org.eclipse.ui.internal.actions.CommandAction;
import org.eclipse.ui.internal.actions.DynamicHelpAction;
import org.eclipse.ui.internal.actions.HelpContentsAction;
import org.eclipse.ui.internal.actions.HelpSearchAction;
import org.eclipse.ui.internal.actions.NewEditorAction;
import org.eclipse.ui.internal.actions.OpenPerspectiveDialogAction;
import org.eclipse.ui.services.IServiceLocator;

public abstract class ActionFactory {
    public static final ActionFactory ABOUT = new ActionFactory("about"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.help.aboutAction", window);
            action.setId(this.getId());
            IProduct product = Platform.getProduct();
            String productName = null;
            if (product != null) {
                productName = product.getName();
            }
            if (productName == null) {
                productName = "";
            }
            action.setText(NLS.bind((String)WorkbenchMessages.AboutAction_text, (Object)productName));
            action.setToolTipText(NLS.bind((String)WorkbenchMessages.AboutAction_toolTip, (Object)productName));
            window.getWorkbench().getHelpSystem().setHelp(action, "org.eclipse.ui.about_action_context");
            return action;
        }
    };
    public static final ActionFactory ACTIVATE_EDITOR = new ActionFactory("activateEditor"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.window.activateEditor", window);
            action.setId(this.getId());
            action.setText(WorkbenchMessages.ActivateEditorAction_text);
            action.setToolTipText(WorkbenchMessages.ActivateEditorAction_toolTip);
            return action;
        }
    };
    public static final ActionFactory BACK = new ActionFactory("back"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            LabelRetargetAction action = new LabelRetargetAction(this.getId(), WorkbenchMessages.Workbench_back);
            action.setToolTipText(WorkbenchMessages.Workbench_backToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.navigate.back");
            return action;
        }
    };
    public static final ActionFactory BACKWARD_HISTORY = new ActionFactory("backardHistory"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            NavigationHistoryAction action = new NavigationHistoryAction(window, false);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory CLOSE = new ActionFactory("close"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.file.close", window);
            action.setText(WorkbenchMessages.CloseEditorAction_text);
            action.setToolTipText(WorkbenchMessages.CloseEditorAction_toolTip);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory CLOSE_ALL = new ActionFactory("closeAll"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.file.closeAll", window);
            action.setText(WorkbenchMessages.CloseAllAction_text);
            action.setToolTipText(WorkbenchMessages.CloseAllAction_toolTip);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory CLOSE_OTHERS = new ActionFactory("closeOthers"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.file.closeOthers", window);
            action.setText(WorkbenchMessages.CloseOthersAction_text);
            action.setToolTipText(WorkbenchMessages.CloseOthersAction_toolTip);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory CLOSE_ALL_PERSPECTIVES = new ActionFactory("closeAllPerspectives"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            CloseAllPerspectivesAction action = new CloseAllPerspectivesAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory CLOSE_ALL_SAVED = new ActionFactory("closeAllSaved"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            CloseAllSavedAction action = new CloseAllSavedAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory CLOSE_PERSPECTIVE = new ActionFactory("closePerspective"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            ClosePerspectiveAction action = new ClosePerspectiveAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory INTRO = new ActionFactory("intro"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            IntroAction action = new IntroAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory COPY = new ActionFactory("copy"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction action = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_copy);
            action.setToolTipText(WorkbenchMessages.Workbench_copyToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.edit.copy");
            ISharedImages sharedImages = window.getWorkbench().getSharedImages();
            action.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
            action.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
            return action;
        }
    };
    public static final ActionFactory CUT = new ActionFactory("cut"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction action = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_cut);
            action.setToolTipText(WorkbenchMessages.Workbench_cutToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.edit.cut");
            ISharedImages sharedImages = window.getWorkbench().getSharedImages();
            action.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
            action.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
            return action;
        }
    };
    public static final ActionFactory DELETE = new ActionFactory("delete"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction action = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_delete);
            action.setToolTipText(WorkbenchMessages.Workbench_deleteToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.edit.delete");
            action.enableAccelerator(false);
            window.getWorkbench().getHelpSystem().setHelp(action, "org.eclipse.ui.delete_retarget_action_context");
            ISharedImages sharedImages = window.getWorkbench().getSharedImages();
            action.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
            action.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
            return action;
        }
    };
    public static final ActionFactory EDIT_ACTION_SETS = new ActionFactory("editActionSets"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            EditActionSetsAction action = new EditActionSetsAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory EXPORT = new ActionFactory("export"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            ExportResourcesAction action = new ExportResourcesAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory FIND = new ActionFactory("find"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction action = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_findReplace);
            action.setToolTipText(WorkbenchMessages.Workbench_findReplaceToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
            return action;
        }
    };
    public static final ActionFactory FORWARD = new ActionFactory("forward"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            LabelRetargetAction action = new LabelRetargetAction(this.getId(), WorkbenchMessages.Workbench_forward);
            action.setToolTipText(WorkbenchMessages.Workbench_forwardToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.navigate.forward");
            return action;
        }
    };
    public static final ActionFactory FORWARD_HISTORY = new ActionFactory("forwardHistory"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            NavigationHistoryAction action = new NavigationHistoryAction(window, true);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory GO_INTO = new ActionFactory("goInto"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            LabelRetargetAction action = new LabelRetargetAction(this.getId(), WorkbenchMessages.Workbench_goInto);
            action.setToolTipText(WorkbenchMessages.Workbench_goIntoToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.navigate.goInto");
            return action;
        }
    };
    public static final ActionFactory IMPORT = new ActionFactory("import"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            ImportResourcesAction action = new ImportResourcesAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory LOCK_TOOL_BAR = new ActionFactory("lockToolBar"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            LockToolBarAction action = new LockToolBarAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory MAXIMIZE = new ActionFactory("maximize"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            MaximizePartAction action = new MaximizePartAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory MINIMIZE = new ActionFactory("minimize"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            MinimizePartAction action = new MinimizePartAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory MOVE = new ActionFactory("move"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction action = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_move);
            action.setToolTipText(WorkbenchMessages.Workbench_moveToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.edit.move");
            return action;
        }
    };
    public static final ActionFactory NEW = new ActionFactory("new"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            NewWizardAction action = new NewWizardAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory NEW_WIZARD_DROP_DOWN = new ActionFactory("newWizardDropDown"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            NewWizardDropDownAction action = new NewWizardDropDownAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory NEXT = new ActionFactory("next"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.navigate.next", window);
            action.setText(WorkbenchMessages.Workbench_next);
            action.setId(this.getId());
            action.setToolTipText(WorkbenchMessages.Workbench_nextToolTip);
            return action;
        }
    };
    public static final ActionFactory NEXT_EDITOR = new ActionFactory("nextEditor"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.window.nextEditor", window);
            action.setText(WorkbenchMessages.CycleEditorAction_next_text);
            action.setToolTipText(WorkbenchMessages.CycleEditorAction_next_toolTip);
            window.getWorkbench().getHelpSystem().setHelp(action, "org.eclipse.ui.cycle_editor_forward_action_context");
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory NEXT_PART = new ActionFactory("nextPart"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.window.nextView", window);
            action.setText(WorkbenchMessages.CyclePartAction_next_text);
            action.setToolTipText(WorkbenchMessages.CyclePartAction_next_toolTip);
            window.getWorkbench().getHelpSystem().setHelp(action, "org.eclipse.ui.cycle_part_forward_action_context");
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory NEXT_PERSPECTIVE = new ActionFactory("nextPerspective"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.window.nextPerspective", window);
            action.setText(WorkbenchMessages.CyclePerspectiveAction_next_text);
            action.setToolTipText(WorkbenchMessages.CyclePerspectiveAction_next_toolTip);
            window.getWorkbench().getHelpSystem().setHelp(action, "org.eclipse.ui.cycle_perspective_forward_action_context");
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory OPEN_NEW_WINDOW = new ActionFactory("openNewWindow"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            OpenInNewWindowAction action = new OpenInNewWindowAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory PASTE = new ActionFactory("paste"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction action = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_paste);
            action.setToolTipText(WorkbenchMessages.Workbench_pasteToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.edit.paste");
            ISharedImages sharedImages = window.getWorkbench().getSharedImages();
            action.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
            action.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
            return action;
        }
    };
    public static final ActionFactory PREFERENCES = new ActionFactory("preferences"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            OpenPreferencesAction action = new OpenPreferencesAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory PREVIOUS = new ActionFactory("previous"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.navigate.previous", window);
            action.setText(WorkbenchMessages.Workbench_previous);
            action.setId(this.getId());
            action.setToolTipText(WorkbenchMessages.Workbench_previousToolTip);
            return action;
        }
    };
    public static final ActionFactory PREVIOUS_EDITOR = new ActionFactory("previousEditor"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.window.previousEditor", window);
            action.setText(WorkbenchMessages.CycleEditorAction_prev_text);
            action.setToolTipText(WorkbenchMessages.CycleEditorAction_prev_toolTip);
            window.getWorkbench().getHelpSystem().setHelp(action, "org.eclipse.ui.cycle_editor_backward_action_context");
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory PREVIOUS_PART = new ActionFactory("previousPart"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.window.previousView", window);
            action.setText(WorkbenchMessages.CyclePartAction_prev_text);
            action.setToolTipText(WorkbenchMessages.CyclePartAction_prev_toolTip);
            window.getWorkbench().getHelpSystem().setHelp(action, "org.eclipse.ui.cycle_part_backward_action_context");
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory PREVIOUS_PERSPECTIVE = new ActionFactory("previousPerspective"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.window.previousPerspective", window);
            action.setText(WorkbenchMessages.CyclePerspectiveAction_prev_text);
            action.setToolTipText(WorkbenchMessages.CyclePerspectiveAction_prev_toolTip);
            window.getWorkbench().getHelpSystem().setHelp(action, "org.eclipse.ui.cycle_perspective_backward_action_context");
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory PRINT = new ActionFactory("print"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction action = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_print);
            action.setToolTipText(WorkbenchMessages.Workbench_printToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.file.print");
            action.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_PRINT_EDIT"));
            action.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_PRINT_EDIT_DISABLED"));
            return action;
        }
    };
    public static final ActionFactory PROPERTIES = new ActionFactory("properties"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction action = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_properties);
            action.setToolTipText(WorkbenchMessages.Workbench_propertiesToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.file.properties");
            return action;
        }
    };
    public static final ActionFactory QUIT = new ActionFactory("quit"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            QuitAction action = new QuitAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory REDO = new ActionFactory("redo"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            LabelRetargetAction action = new LabelRetargetAction(this.getId(), WorkbenchMessages.Workbench_redo);
            action.setToolTipText(WorkbenchMessages.Workbench_redoToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.edit.redo");
            ISharedImages sharedImages = window.getWorkbench().getSharedImages();
            action.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
            action.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO_DISABLED"));
            return action;
        }
    };
    public static final ActionFactory REFRESH = new ActionFactory("refresh"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction action = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_refresh);
            action.setToolTipText(WorkbenchMessages.Workbench_refreshToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.file.refresh");
            return action;
        }
    };
    public static final ActionFactory RENAME = new ActionFactory("rename"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction action = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_rename);
            action.setToolTipText(WorkbenchMessages.Workbench_renameToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.edit.rename");
            return action;
        }
    };
    public static final ActionFactory RESET_PERSPECTIVE = new ActionFactory("resetPerspective"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            ResetPerspectiveAction action = new ResetPerspectiveAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory REVERT = new ActionFactory("revert"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction action = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_revert);
            action.setToolTipText(WorkbenchMessages.Workbench_revertToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.file.revert");
            return action;
        }
    };
    public static final ActionFactory SAVE = new ActionFactory("save"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            SaveAction action = new SaveAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory SAVE_ALL = new ActionFactory("saveAll"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            SaveAllAction action = new SaveAllAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory SAVE_AS = new ActionFactory("saveAs"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            SaveAsAction action = new SaveAsAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory SAVE_PERSPECTIVE = new ActionFactory("savePerspective"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            SavePerspectiveAction action = new SavePerspectiveAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory SELECT_ALL = new ActionFactory("selectAll"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction action = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_selectAll);
            action.setToolTipText(WorkbenchMessages.Workbench_selectAllToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
            return action;
        }
    };
    public static final ActionFactory SHOW_EDITOR = new ActionFactory("showEditor"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            ToggleEditorsVisibilityAction action = new ToggleEditorsVisibilityAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory SHOW_OPEN_EDITORS = new ActionFactory("showOpenEditors"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchEditorsAction action = new WorkbenchEditorsAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory SHOW_WORKBOOK_EDITORS = new ActionFactory("showWorkBookEditors"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbookEditorsAction action = new WorkbookEditorsAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory SHOW_QUICK_ACCESS = new ActionFactory("showQuickAccess"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            QuickAccessMenu action = new QuickAccessMenu(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory SHOW_PART_PANE_MENU = new ActionFactory("showPartPaneMenu"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.window.showSystemMenu", window);
            action.setText(WorkbenchMessages.ShowPartPaneMenuAction_text);
            action.setToolTipText(WorkbenchMessages.ShowPartPaneMenuAction_toolTip);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory SHOW_VIEW_MENU = new ActionFactory("showViewMenu"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.window.showViewMenu", window);
            action.setText(WorkbenchMessages.ShowViewMenuAction_text);
            action.setToolTipText(WorkbenchMessages.ShowViewMenuAction_toolTip);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory UNDO = new ActionFactory("undo"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            LabelRetargetAction action = new LabelRetargetAction(this.getId(), WorkbenchMessages.Workbench_undo);
            action.setToolTipText(WorkbenchMessages.Workbench_undoToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.edit.undo");
            ISharedImages sharedImages = window.getWorkbench().getSharedImages();
            action.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
            action.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO_DISABLED"));
            return action;
        }
    };
    public static final ActionFactory UP = new ActionFactory("up"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            LabelRetargetAction action = new LabelRetargetAction(this.getId(), WorkbenchMessages.Workbench_up);
            action.setToolTipText(WorkbenchMessages.Workbench_upToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.navigate.up");
            return action;
        }
    };
    public static final ActionFactory HELP_CONTENTS = new ActionFactory("helpContents"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            HelpContentsAction action = new HelpContentsAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory HELP_SEARCH = new ActionFactory("helpSearch"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            HelpSearchAction action = new HelpSearchAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory DYNAMIC_HELP = new ActionFactory("dynamicHelp"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            DynamicHelpAction action = new DynamicHelpAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory OPEN_PERSPECTIVE_DIALOG = new ActionFactory("openPerspectiveDialog"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            OpenPerspectiveDialogAction action = new OpenPerspectiveDialogAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory NEW_EDITOR = new ActionFactory("newEditor"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            NewEditorAction action = new NewEditorAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory TOGGLE_COOLBAR = new ActionFactory("toggleCoolbar"){

        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.ToggleCoolbarAction", window);
            action.setText(WorkbenchMessages.ToggleCoolbarVisibilityAction_hide_text);
            action.setToolTipText(WorkbenchMessages.ToggleCoolbarVisibilityAction_toolTip);
            action.setId(this.getId());
            return action;
        }
    };
    private final String actionId;

    public static void linkCycleActionPair(IWorkbenchAction next, IWorkbenchAction previous) {
    }

    protected ActionFactory(String actionId) {
        this.actionId = actionId;
    }

    public abstract IWorkbenchAction create(IWorkbenchWindow var1);

    public String getId() {
        return this.actionId;
    }

    public static interface IWorkbenchAction
    extends IAction {
        public void dispose();
    }

    private static class WorkbenchCommandAction
    extends CommandAction
    implements IWorkbenchAction {
        public WorkbenchCommandAction(String commandIdIn, IWorkbenchWindow window) {
            super(window, commandIdIn);
        }

        public WorkbenchCommandAction(String commandIdIn, Map parameterMap, IServiceLocator serviceLocator) {
            super(serviceLocator, commandIdIn, parameterMap);
        }
    }
}

