/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class TableColumn
extends Item {
    static final int IMAGE_PART = 0;
    static final int TEXT_PART = 1;
    int headerHandle;
    int stringHandle;
    boolean moveable;
    boolean resizable;
    Table parent;

    public TableColumn(Table parent, int style) {
        this(parent, TableColumn.checkStyle(style), -1);
    }

    public TableColumn(Table parent, int style, int index) {
        super(parent, TableColumn.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, index);
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return TableColumn.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle() {
        this.handle = OS.gcnew_GridViewColumn();
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.headerHandle = OS.gcnew_GridViewColumnHeader();
        OS.GridViewColumn_Header(this.handle, this.headerHandle);
        int row = OS.gcnew_SWTRow(this.jniRef, this.headerHandle);
        OS.GridViewColumnHeader_Content(this.headerHandle, row);
        OS.GCHandle_Free(row);
    }

    void deregister() {
        this.display.removeWidget(this.headerHandle);
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    int GetBackground(int itemHandle) {
        return 0;
    }

    int GetCheck(int itemHandle) {
        return 0;
    }

    int GetFont(int itemHandle) {
        return 0;
    }

    int GetForeground(int itemHandle) {
        return 0;
    }

    int GetImage(int itemHandle) {
        return this.image != null ? this.image.handle : 0;
    }

    int GetText(int itemHandle) {
        int result = 0;
        if (this.text != null && (result = this.stringHandle) == 0) {
            result = this.stringHandle = this.createDotNetString(this.text, false);
        }
        return result;
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    String getNameText() {
        return this.getText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return this.moveable;
    }

    public boolean getResizable() {
        this.checkWidget();
        return this.resizable;
    }

    public String getToolTipText() {
        this.checkWidget();
        int strPtr = OS.FrameworkElement_ToolTip(this.headerHandle);
        String string = TableColumn.createJavaString(strPtr);
        OS.GCHandle_Free(strPtr);
        return string;
    }

    public int getWidth() {
        this.checkWidget();
        return (int)OS.GridViewColumn_ActualWidth(this.handle);
    }

    int findPart(int part) {
        if (!OS.FrameworkElement_IsLoaded(this.headerHandle)) {
            this.updateLayout(this.headerHandle);
        }
        int contentPresenterType = OS.ContentPresenter_typeid();
        int contentPresenter = this.findStackPanel(this.headerHandle, contentPresenterType);
        OS.GCHandle_Free(contentPresenterType);
        int result = OS.VisualTreeHelper_GetChild(contentPresenter, part);
        OS.GCHandle_Free(contentPresenter);
        return result;
    }

    int findStackPanel(int element, int contentPresenterType) {
        int type = OS.Object_GetType(element);
        boolean found = OS.Object_Equals(contentPresenterType, type);
        OS.GCHandle_Free(type);
        if (found) {
            return OS.VisualTreeHelper_GetChild(element, 0);
        }
        int count = OS.VisualTreeHelper_GetChildrenCount(element);
        int i = 0;
        while (i < count) {
            int child = OS.VisualTreeHelper_GetChild(element, i);
            int result = this.findStackPanel(child, contentPresenterType);
            OS.GCHandle_Free(child);
            if (result != 0) {
                return result;
            }
            ++i;
        }
        return 0;
    }

    public void pack() {
        this.checkWidget();
        this.updateLayout(this.parent.handle);
        double width = 0.0;
        if (this.headerHandle != 0) {
            int size = OS.UIElement_DesiredSize(this.headerHandle);
            width = OS.Size_Width(size);
            OS.GCHandle_Free(size);
        }
        int columnIndex = this.parent.indexOf(this);
        int items = OS.ItemsControl_Items(this.parent.handle);
        int i = 0;
        while (i < this.parent.itemCount) {
            TableItem item = this.parent.getItem(items, i, false);
            if (item != null) {
                width = Math.max(width, item.computeWidth(columnIndex));
            }
            ++i;
        }
        OS.GCHandle_Free(items);
        OS.GridViewColumn_Width(this.handle, width);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.handle != 0) {
            OS.GCHandle_Free(this.handle);
        }
        this.handle = 0;
        OS.GCHandle_Free(this.headerHandle);
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.stringHandle != 0) {
            OS.GCHandle_Free(this.stringHandle);
        }
        this.stringHandle = 0;
    }

    void register() {
        this.display.addWidget(this.headerHandle, this);
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        int index = this.parent.indexOf(this);
        if (index == -1 || index == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
    }

    public void setImage(Image image) {
        this.checkWidget();
        super.setImage(image);
    }

    public void setMoveable(boolean moveable) {
        this.checkWidget();
        this.moveable = moveable;
        this.parent.updateMoveable();
    }

    public void setResizable(boolean resizable) {
        this.checkWidget();
        this.resizable = resizable;
    }

    void setSortDirection(int direction) {
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        if (this.stringHandle != 0) {
            OS.GCHandle_Free(this.stringHandle);
            this.stringHandle = 0;
        }
        if (OS.FrameworkElement_IsLoaded(this.headerHandle)) {
            int part = this.findPart(1);
            int property = OS.TextBlock_TextProperty();
            int bindingExpression = OS.FrameworkElement_GetBindingExpression(part, property);
            OS.BindingExpression_UpdateTarget(bindingExpression);
            OS.GCHandle_Free(part);
            OS.GCHandle_Free(property);
            OS.GCHandle_Free(bindingExpression);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        if (string != null && string.length() == 0) {
            string = null;
        }
        int strPtr = this.createDotNetString(string, false);
        OS.FrameworkElement_ToolTip(this.headerHandle, strPtr);
        OS.GCHandle_Free(strPtr);
    }

    public void setWidth(int width) {
        this.checkWidget();
        if (width < 0) {
            return;
        }
        OS.GridViewColumn_Width(this.handle, width);
    }
}

