/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Table
extends Composite {
    int gridViewHandle;
    int parentingHandle;
    int columnCount;
    int itemCount;
    boolean ignoreSelection;
    static final String CHECKBOX_PART_NAME = "SWT_PART_CHECKBOX";
    static final String IMAGE_PART_NAME = "SWT_PART_IMAGE";
    static final String TEXT_PART_NAME = "SWT_PART_TEXT";
    static final int BACKGROUND_NOTIFY = 3;
    static final int CHECK_NOTIFY = 4;
    static final int FONT_NOTIFY = 5;
    static final int FOREGROUND_NOTIFY = 2;
    static final int IMAGE_NOTIFY = 1;
    static final int TEXT_NOTIFY = 0;

    public Table(Composite parent, int style) {
        super(parent, Table.checkStyle(style));
    }

    void _addListener(int eventType, Listener listener) {
        super._addListener(eventType, listener);
        switch (eventType) {
            default: 
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int backgroundProperty() {
        return OS.Control_BackgroundProperty();
    }

    boolean checkData(TableItem item) {
        if ((this.style & 0x10000000) == 0) {
            return true;
        }
        if (!item.cached) {
            item.cached = true;
            Event event = new Event();
            event.item = item;
            event.index = this.indexOf(item);
            item.ignoreNotify = true;
            this.sendEvent(36, event);
            item.ignoreNotify = false;
            if (this.isDisposed() || item.isDisposed()) {
                return false;
            }
        }
        return true;
    }

    static int checkStyle(int style) {
        style |= 0x300;
        return Table.checkBits(style |= 0x10000, 4, 2, 0, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clear(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        int items = OS.ItemsControl_Items(this.handle);
        TableItem item = this.getItem(items, index, false);
        OS.GCHandle_Free(items);
        if (item != null) {
            item.clear();
        }
    }

    public void clear(int start, int end) {
        this.checkWidget();
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (start < 0 || start > end || end >= this.itemCount) {
            this.error(6);
        }
        if (start == 0 && end == this.itemCount - 1) {
            this.clearAll();
        } else {
            int items = OS.ItemsControl_Items(this.handle);
            int i = start;
            while (i <= end) {
                TableItem item = this.getItem(items, i, false);
                if (item != null) {
                    item.clear();
                }
                ++i;
            }
            OS.GCHandle_Free(items);
        }
    }

    public void clear(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int i = 0;
        while (i < indices.length) {
            if (indices[i] < 0 || indices[i] >= this.itemCount) {
                this.error(6);
            }
            ++i;
        }
        int items = OS.ItemsControl_Items(this.handle);
        int i2 = 0;
        while (i2 < indices.length) {
            int index = indices[i2];
            TableItem item = this.getItem(items, index, false);
            if (item != null) {
                item.clear();
            }
            ++i2;
        }
        OS.GCHandle_Free(items);
    }

    public void clearAll() {
        this.checkWidget();
        int items = OS.ItemsControl_Items(this.handle);
        int i = 0;
        while (i < this.itemCount) {
            TableItem item = this.getItem(items, i, false);
            if (item != null) {
                item.clear();
            }
            ++i;
        }
        OS.GCHandle_Free(items);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point size = this.computeSize(this.handle, wHint, hHint, changed);
        if (size.x == 0) {
            size.x = 64;
        }
        if (size.y == 0) {
            size.y = 64;
        }
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    int createCellTemplate(int index) {
        int verticalAlignmentProperty;
        int template = OS.gcnew_DataTemplate();
        int stackPanelType = OS.StackPanel_typeid();
        int stackPanelNode = OS.gcnew_FrameworkElementFactory(stackPanelType);
        if (index == 0 && (this.style & 0x20) != 0) {
            int checkBoxType = OS.CheckBox_typeid();
            int checkBoxName = this.createDotNetString(CHECKBOX_PART_NAME, false);
            int checkBoxNode = OS.gcnew_FrameworkElementFactory(checkBoxType, checkBoxName);
            verticalAlignmentProperty = OS.FrameworkElement_VerticalAlignmentProperty();
            OS.FrameworkElementFactory_SetValueVerticalAlignment(checkBoxNode, verticalAlignmentProperty, 1);
            int marginProperty = OS.FrameworkElement_MarginProperty();
            int thickness = OS.gcnew_Thickness(0.0, 0.0, 4.0, 0.0);
            OS.FrameworkElementFactory_SetValue(checkBoxNode, marginProperty, thickness);
            OS.FrameworkElementFactory_AppendChild(stackPanelNode, checkBoxNode);
            int checkPath = this.createDotNetString("Check", false);
            int checkBinding = OS.gcnew_Binding(checkPath);
            int isCheckedProperty = OS.ToggleButton_IsCheckedProperty();
            OS.FrameworkElementFactory_SetBinding(checkBoxNode, isCheckedProperty, checkBinding);
            OS.GCHandle_Free(checkPath);
            OS.GCHandle_Free(checkBinding);
            OS.GCHandle_Free(isCheckedProperty);
            OS.GCHandle_Free(thickness);
            OS.GCHandle_Free(marginProperty);
            OS.GCHandle_Free(verticalAlignmentProperty);
            OS.GCHandle_Free(checkBoxName);
            OS.GCHandle_Free(checkBoxNode);
            OS.GCHandle_Free(checkBoxType);
        }
        int textType = OS.TextBlock_typeid();
        int textName = this.createDotNetString(TEXT_PART_NAME, false);
        int textNode = OS.gcnew_FrameworkElementFactory(textType, textName);
        verticalAlignmentProperty = OS.FrameworkElement_VerticalAlignmentProperty();
        OS.FrameworkElementFactory_SetValueVerticalAlignment(textNode, verticalAlignmentProperty, 1);
        int imageType = OS.Image_typeid();
        int imageName = this.createDotNetString(IMAGE_PART_NAME, false);
        int imageNode = OS.gcnew_FrameworkElementFactory(imageType, imageName);
        int marginProperty = OS.FrameworkElement_MarginProperty();
        int thickness = OS.gcnew_Thickness(0.0, 0.0, 4.0, 0.0);
        OS.FrameworkElementFactory_SetValue(imageNode, marginProperty, thickness);
        int orientationProperty = OS.StackPanel_OrientationProperty();
        OS.FrameworkElementFactory_SetValueOrientation(stackPanelNode, orientationProperty, 0);
        OS.FrameworkElementFactory_AppendChild(stackPanelNode, imageNode);
        OS.FrameworkElementFactory_AppendChild(stackPanelNode, textNode);
        OS.FrameworkTemplate_VisualTree(template, stackPanelNode);
        int cellConverter = OS.gcnew_SWTCellConverter();
        int textPath = this.createDotNetString("Text", false);
        int textBinding = OS.gcnew_Binding(textPath);
        OS.Binding_Converter(textBinding, cellConverter);
        OS.Binding_ConverterParameter(textBinding, index);
        int textProperty = OS.TextBlock_TextProperty();
        OS.FrameworkElementFactory_SetBinding(textNode, textProperty, textBinding);
        int imagePath = this.createDotNetString("Image", false);
        int imageBinding = OS.gcnew_Binding(imagePath);
        OS.Binding_Converter(imageBinding, cellConverter);
        OS.Binding_ConverterParameter(imageBinding, index);
        int imageProperty = OS.Image_SourceProperty();
        OS.FrameworkElementFactory_SetBinding(imageNode, imageProperty, imageBinding);
        OS.GCHandle_Free(textBinding);
        OS.GCHandle_Free(textPath);
        OS.GCHandle_Free(textProperty);
        OS.GCHandle_Free(imageBinding);
        OS.GCHandle_Free(imagePath);
        OS.GCHandle_Free(imageProperty);
        OS.GCHandle_Free(cellConverter);
        OS.GCHandle_Free(marginProperty);
        OS.GCHandle_Free(thickness);
        OS.GCHandle_Free(stackPanelType);
        OS.GCHandle_Free(imageType);
        OS.GCHandle_Free(textType);
        OS.GCHandle_Free(stackPanelNode);
        OS.GCHandle_Free(textName);
        OS.GCHandle_Free(textNode);
        OS.GCHandle_Free(imageName);
        OS.GCHandle_Free(imageNode);
        OS.GCHandle_Free(orientationProperty);
        OS.GCHandle_Free(verticalAlignmentProperty);
        return template;
    }

    void createDefaultColumn() {
        int column = OS.gcnew_GridViewColumn();
        int columnCollection = OS.GridView_Columns(this.gridViewHandle);
        OS.GridViewColumnCollection_Insert(columnCollection, 0, column);
        int cellTemplate = this.createCellTemplate(0);
        OS.GridViewColumn_CellTemplate(column, cellTemplate);
        OS.GCHandle_Free(columnCollection);
        OS.GCHandle_Free(column);
        OS.GCHandle_Free(cellTemplate);
    }

    void createHandle() {
        this.parentingHandle = OS.gcnew_Canvas();
        if (this.parentingHandle == 0) {
            this.error(2);
        }
        this.handle = OS.gcnew_ListView();
        if (this.handle == 0) {
            this.error(2);
        }
        this.gridViewHandle = OS.gcnew_GridView();
        if (this.gridViewHandle == 0) {
            this.error(2);
        }
        OS.ListView_View(this.handle, this.gridViewHandle);
        if ((this.style & 2) == 0) {
            OS.ListBox_SelectionMode(this.handle, 0);
        }
        this.createDefaultColumn();
        this.setHeaderVisible(false);
        OS.Selector_IsSynchronizedWithCurrentItem(this.handle, true);
        OS.GridView_AllowsColumnReorder(this.gridViewHandle, false);
        OS.Canvas_SetLeft(this.handle, 0.0);
        OS.Canvas_SetTop(this.handle, 0.0);
        int children = OS.Panel_Children(this.parentingHandle);
        OS.UIElementCollection_Add(children, this.handle);
        OS.GCHandle_Free(children);
    }

    int createHeaderTemplate() {
        int template = OS.gcnew_DataTemplate();
        int stackPanelType = OS.StackPanel_typeid();
        int stackPanelNode = OS.gcnew_FrameworkElementFactory(stackPanelType);
        int textType = OS.TextBlock_typeid();
        int textName = this.createDotNetString(TEXT_PART_NAME, false);
        int textNode = OS.gcnew_FrameworkElementFactory(textType, textName);
        int verticalAlignmentProperty = OS.FrameworkElement_VerticalAlignmentProperty();
        OS.FrameworkElementFactory_SetValueVerticalAlignment(textNode, verticalAlignmentProperty, 1);
        int imageType = OS.Image_typeid();
        int imageName = this.createDotNetString(IMAGE_PART_NAME, false);
        int imageNode = OS.gcnew_FrameworkElementFactory(imageType, imageName);
        int marginProperty = OS.FrameworkElement_MarginProperty();
        int thickness = OS.gcnew_Thickness(0.0, 0.0, 4.0, 0.0);
        OS.FrameworkElementFactory_SetValue(imageNode, marginProperty, thickness);
        int orientationProperty = OS.StackPanel_OrientationProperty();
        OS.FrameworkElementFactory_SetValueOrientation(stackPanelNode, orientationProperty, 0);
        OS.FrameworkElementFactory_AppendChild(stackPanelNode, imageNode);
        OS.FrameworkElementFactory_AppendChild(stackPanelNode, textNode);
        OS.FrameworkTemplate_VisualTree(template, stackPanelNode);
        int textPath = this.createDotNetString("Text", false);
        int textBinding = OS.gcnew_Binding(textPath);
        int textProperty = OS.TextBlock_TextProperty();
        OS.FrameworkElementFactory_SetBinding(textNode, textProperty, textBinding);
        int imagePath = this.createDotNetString("Image", false);
        int imageBinding = OS.gcnew_Binding(imagePath);
        int imageProperty = OS.Image_SourceProperty();
        OS.FrameworkElementFactory_SetBinding(imageNode, imageProperty, imageBinding);
        OS.GCHandle_Free(textBinding);
        OS.GCHandle_Free(textPath);
        OS.GCHandle_Free(textProperty);
        OS.GCHandle_Free(imageBinding);
        OS.GCHandle_Free(imagePath);
        OS.GCHandle_Free(imageProperty);
        OS.GCHandle_Free(imageType);
        OS.GCHandle_Free(imageName);
        OS.GCHandle_Free(marginProperty);
        OS.GCHandle_Free(thickness);
        OS.GCHandle_Free(textType);
        OS.GCHandle_Free(textName);
        OS.GCHandle_Free(stackPanelType);
        OS.GCHandle_Free(stackPanelNode);
        OS.GCHandle_Free(textNode);
        OS.GCHandle_Free(imageNode);
        OS.GCHandle_Free(orientationProperty);
        OS.GCHandle_Free(verticalAlignmentProperty);
        return template;
    }

    void createItem(TableColumn column, int index) {
        if (index == -1) {
            index = this.columnCount;
        }
        if (index < 0 || index > this.columnCount) {
            this.error(6);
        }
        column.createWidget();
        int template = this.createHeaderTemplate();
        OS.GridViewColumn_HeaderTemplate(column.handle, template);
        OS.GCHandle_Free(template);
        template = this.createCellTemplate(index);
        OS.GridViewColumn_CellTemplate(column.handle, template);
        OS.GCHandle_Free(template);
        int columns = OS.GridView_Columns(this.gridViewHandle);
        if (this.columnCount == 0) {
            OS.GridViewColumnCollection_Clear(columns);
        }
        OS.GridViewColumnCollection_Insert(columns, index, column.handle);
        OS.GCHandle_Free(columns);
        if (this.columnCount != 0) {
            int items = OS.ItemsControl_Items(this.handle);
            int i = 0;
            while (i < this.itemCount) {
                TableItem item = this.getItem(items, i, false);
                if (item != null) {
                    item.columnAdded(index);
                }
                ++i;
            }
            OS.GCHandle_Free(items);
        }
        ++this.columnCount;
    }

    void createItem(TableItem item, int index) {
        if (index == -1) {
            index = this.itemCount;
        }
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        item.createWidget();
        int items = OS.ItemsControl_Items(this.handle);
        OS.ItemCollection_Insert(items, index, item.handle);
        int count = OS.ItemCollection_Count(items);
        OS.GCHandle_Free(items);
        if (this.itemCount == count) {
            this.error(14);
        }
        ++this.itemCount;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.parentingHandle);
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int items = OS.ItemsControl_Items(this.handle);
        this.ignoreSelection = true;
        int i = 0;
        while (i < indices.length) {
            if (indices[i] >= 0 && indices[i] < this.itemCount) {
                int item = OS.ItemCollection_GetItemAt(items, i);
                OS.ListBoxItem_IsSelected(item, false);
                OS.GCHandle_Free(item);
            }
            ++i;
        }
        this.ignoreSelection = false;
        OS.GCHandle_Free(items);
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            return;
        }
        int items = OS.ItemsControl_Items(this.handle);
        int item = OS.ItemCollection_GetItemAt(items, index);
        this.ignoreSelection = true;
        OS.ListBoxItem_IsSelected(item, false);
        this.ignoreSelection = false;
        OS.GCHandle_Free(item);
        OS.GCHandle_Free(items);
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        if (start <= 0 && end >= this.itemCount - 1) {
            this.deselectAll();
        } else {
            start = Math.max(0, start);
            end = Math.min(end, this.itemCount - 1);
            int items = OS.ItemsControl_Items(this.handle);
            this.ignoreSelection = true;
            int i = start;
            while (i <= end) {
                int item = OS.ItemCollection_GetItemAt(items, i);
                OS.ListBoxItem_IsSelected(item, false);
                OS.GCHandle_Free(item);
                ++i;
            }
            this.ignoreSelection = false;
            OS.GCHandle_Free(items);
        }
    }

    public void deselectAll() {
        this.checkWidget();
        this.ignoreSelection = true;
        OS.ListBox_UnselectAll(this.handle);
        this.ignoreSelection = false;
    }

    void destroyItem(TableColumn column) {
        int columns = OS.GridView_Columns(this.gridViewHandle);
        int index = OS.GridViewColumnCollection_IndexOf(columns, column.handle);
        boolean removed = OS.GridViewColumnCollection_Remove(columns, column.handle);
        OS.GCHandle_Free(columns);
        if (!removed) {
            this.error(15);
        }
        --this.columnCount;
        if (this.columnCount == 0) {
            this.createDefaultColumn();
        }
        int items = OS.ItemsControl_Items(this.handle);
        int i = 0;
        while (i < this.itemCount) {
            TableItem item = this.getItem(items, i, false);
            if (item != null) {
                item.columnRemoved(index);
            }
            ++i;
        }
        OS.GCHandle_Free(items);
    }

    void destroyItem(TableItem item) {
        int items = OS.ItemsControl_Items(this.handle);
        this.ignoreSelection = true;
        OS.ItemCollection_Remove(items, item.handle);
        this.ignoreSelection = false;
        int count = OS.ItemCollection_Count(items);
        OS.GCHandle_Free(items);
        if (this.itemCount == count) {
            this.error(15);
        }
        --this.itemCount;
    }

    int GetBackground(int itemHandle) {
        TableItem item = this.getItem(itemHandle, true);
        this.checkData(item);
        return item.backgroundList;
    }

    int GetCheck(int itemHandle) {
        TableItem item = this.getItem(itemHandle, true);
        this.checkData(item);
        return item.checkState;
    }

    int GetFont(int itemHandle) {
        TableItem item = this.getItem(itemHandle, true);
        this.checkData(item);
        return item.fontList;
    }

    int GetForeground(int itemHandle) {
        TableItem item = this.getItem(itemHandle, true);
        this.checkData(item);
        return item.foregroundList;
    }

    int GetImage(int itemHandle) {
        TableItem item = this.getItem(itemHandle, true);
        this.checkData(item);
        return item.imageList;
    }

    int GetText(int itemHandle) {
        TableItem item = this.getItem(itemHandle, true);
        this.checkData(item);
        return item.stringList;
    }

    public TableColumn getColumn(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.columnCount) {
            this.error(6);
        }
        int columns = OS.GridView_Columns(this.gridViewHandle);
        TableColumn column = this.getColumn(columns, index);
        OS.GCHandle_Free(columns);
        return column;
    }

    TableColumn getColumn(int columns, int index) {
        int gridColumn = OS.GridViewColumnCollection_default(columns, index);
        int header = OS.GridViewColumn_Header(gridColumn);
        TableColumn column = (TableColumn)this.display.getWidget(header);
        OS.GCHandle_Free(header);
        OS.GCHandle_Free(gridColumn);
        return column;
    }

    void updateMoveable() {
        int columns = OS.GridView_Columns(this.gridViewHandle);
        boolean moveable = true;
        int i = 0;
        while (moveable && i < this.columnCount) {
            TableColumn column = this.getColumn(columns, i);
            if (!column.moveable) {
                moveable = false;
            }
            ++i;
        }
        OS.GCHandle_Free(columns);
        OS.GridView_AllowsColumnReorder(this.gridViewHandle, moveable);
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        int[] order = new int[this.columnCount];
        int i = 0;
        while (i < order.length) {
            order[i] = i;
            ++i;
        }
        return order;
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        TableColumn[] result = new TableColumn[this.columnCount];
        int columns = OS.GridView_Columns(this.gridViewHandle);
        int i = 0;
        while (i < result.length) {
            result[i] = this.getColumn(columns, i);
            ++i;
        }
        OS.GCHandle_Free(columns);
        return result;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 0;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        int columns = OS.GridView_Columns(this.gridViewHandle);
        int column = OS.GridViewColumnCollection_default(columns, 0);
        int height = 0;
        int header = OS.GridViewColumn_Header(column);
        if (header != 0) {
            height = (int)OS.FrameworkElement_ActualHeight(header);
            OS.GCHandle_Free(header);
        }
        OS.GCHandle_Free(column);
        OS.GCHandle_Free(columns);
        return height;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        int columns = OS.GridView_Columns(this.gridViewHandle);
        int column = OS.GridViewColumnCollection_default(columns, 0);
        int header = OS.GridViewColumn_Header(column);
        boolean visible = OS.UIElement_Visibility(header) == 0;
        OS.GCHandle_Free(header);
        OS.GCHandle_Free(column);
        OS.GCHandle_Free(columns);
        return visible;
    }

    public TableItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        int items = OS.ItemsControl_Items(this.handle);
        TableItem item = this.getItem(items, index, true);
        OS.GCHandle_Free(items);
        return item;
    }

    TableItem getItem(int items, int index, boolean create) {
        int item = OS.ItemCollection_GetItemAt(items, index);
        TableItem result = this.getItem(item, create);
        OS.GCHandle_Free(item);
        return result;
    }

    TableItem getItem(int item, boolean create) {
        int tag = OS.FrameworkElement_Tag(item);
        if (tag != 0) {
            int contentValue = OS.IntPtr_ToInt32(tag);
            OS.GCHandle_Free(tag);
            return (TableItem)OS.JNIGetObject(contentValue);
        }
        if (create) {
            int itemHandle = OS.GCHandle_Alloc(item);
            return new TableItem(this, 0, 0, itemHandle);
        }
        return null;
    }

    public TableItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int pt = OS.gcnew_Point(point.x, point.y);
        int input = OS.UIElement_InputHitTest(this.handle, pt);
        OS.GCHandle_Free(pt);
        if (input == 0) {
            return null;
        }
        Widget widget = this.display.getWidget(input);
        OS.GCHandle_Free(input);
        if (widget instanceof TableItem) {
            return (TableItem)widget;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        if (this.itemCount == 0) {
            return 16;
        }
        int items = OS.ItemsControl_Items(this.handle);
        int item = OS.ItemCollection_GetItemAt(items, 0);
        double height = OS.FrameworkElement_ActualHeight(item);
        OS.GCHandle_Free(item);
        OS.GCHandle_Free(items);
        return height != 0.0 ? (int)height : 16;
    }

    public TableItem[] getItems() {
        this.checkWidget();
        TableItem[] result = new TableItem[this.itemCount];
        int items = OS.ItemsControl_Items(this.handle);
        int i = 0;
        while (i < this.itemCount) {
            result[i] = this.getItem(items, i, true);
            ++i;
        }
        OS.GCHandle_Free(items);
        return result;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return false;
    }

    public TableItem[] getSelection() {
        this.checkWidget();
        int selected = OS.ListBox_SelectedItems(this.handle);
        int enumerator = OS.IList_GetEnumerator(selected);
        int count = OS.ICollection_Count(selected);
        TableItem[] result = new TableItem[count];
        int index = 0;
        while (OS.IEnumerator_MoveNext(enumerator)) {
            int item = OS.IEnumerator_Current(enumerator);
            result[index++] = this.getItem(item, true);
            OS.GCHandle_Free(item);
        }
        OS.GCHandle_Free(enumerator);
        OS.GCHandle_Free(selected);
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        int selected = OS.ListBox_SelectedItems(this.handle);
        int count = OS.ICollection_Count(selected);
        OS.GCHandle_Free(selected);
        return count;
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return OS.Selector_SelectedIndex(this.handle);
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        int items = OS.ItemsControl_Items(this.handle);
        int list = OS.ListBox_SelectedItems(this.handle);
        int enumerator = OS.IList_GetEnumerator(list);
        int count = OS.ICollection_Count(list);
        int[] indices = new int[count];
        int index = 0;
        while (OS.IEnumerator_MoveNext(enumerator)) {
            int item = OS.IEnumerator_Current(enumerator);
            indices[index++] = OS.ItemCollection_IndexOf(items, item);
            OS.GCHandle_Free(item);
        }
        OS.GCHandle_Free(enumerator);
        OS.GCHandle_Free(list);
        OS.GCHandle_Free(items);
        this.sortAscending(indices);
        return indices;
    }

    public TableColumn getSortColumn() {
        this.checkWidget();
        return null;
    }

    public int getSortDirection() {
        this.checkWidget();
        return -1;
    }

    public int getTopIndex() {
        this.checkWidget();
        int items = OS.ItemsControl_Items(this.handle);
        int item = OS.ItemCollection_GetItemAt(items, 0);
        OS.GCHandle_Free(items);
        int virtualizingStackPanel = OS.VisualTreeHelper_GetParent(item);
        OS.GCHandle_Free(item);
        int topIndex = 0;
        if (virtualizingStackPanel != 0) {
            topIndex = (int)OS.VirtualizingStackPanel_VerticalOffset(virtualizingStackPanel);
            OS.GCHandle_Free(virtualizingStackPanel);
        }
        return topIndex;
    }

    boolean hasItems() {
        return true;
    }

    void HandleChecked(int sender, int e) {
        int checkbox;
        if (!this.checkEvent(e)) {
            return;
        }
        if (this.ignoreSelection) {
            return;
        }
        int source = OS.RoutedEventArgs_Source(e);
        TableItem item = (TableItem)this.display.getWidget(source);
        OS.GCHandle_Free(source);
        if (!OS.FrameworkElement_IsLoaded(item.handle)) {
            return;
        }
        if (item.grayed && (checkbox = item.findPart(0, CHECKBOX_PART_NAME)) != 0) {
            OS.ToggleButton_IsCheckedNullSetter(checkbox);
            OS.GCHandle_Free(checkbox);
        }
        item.checked = true;
        item.updateCheckState(false);
        Event event = new Event();
        event.item = item;
        event.detail = 32;
        this.sendEvent(13, event);
    }

    void HandleIndeterminate(int sender, int e) {
        int checkbox;
        if (!this.checkEvent(e)) {
            return;
        }
        int source = OS.RoutedEventArgs_Source(e);
        TableItem item = (TableItem)this.display.getWidget(source);
        OS.GCHandle_Free(source);
        if (!OS.FrameworkElement_IsLoaded(item.handle)) {
            return;
        }
        if (!item.grayed && (checkbox = item.findPart(0, CHECKBOX_PART_NAME)) != 0) {
            OS.ToggleButton_IsChecked(checkbox, false);
            OS.GCHandle_Free(checkbox);
        }
    }

    void HandlePreviewKeyDown(int sender, int e) {
        super.HandlePreviewKeyDown(sender, e);
        if (!this.checkEvent(e)) {
            return;
        }
        int key = OS.KeyEventArgs_Key(e);
        if (key == 6) {
            int source = OS.RoutedEventArgs_OriginalSource(e);
            Widget widget = this.display.getWidget(source);
            OS.GCHandle_Free(source);
            if (widget instanceof TableItem) {
                Event event = new Event();
                event.item = (TableItem)widget;
                this.postEvent(14, event);
            }
        }
    }

    void HandleMouseDoubleClick(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        int source = OS.RoutedEventArgs_OriginalSource(e);
        Widget widget = this.display.getWidget(source);
        OS.GCHandle_Free(source);
        if (widget instanceof TableItem) {
            Event event = new Event();
            event.item = (TableItem)widget;
            this.postEvent(14, event);
        }
    }

    void HandleSelectionChanged(int sender, int e) {
        int count;
        if (!this.checkEvent(e)) {
            return;
        }
        if (this.ignoreSelection) {
            return;
        }
        int item = 0;
        int list = OS.SelectionChangedEventArgs_AddedItems(e);
        if (list != 0 && (count = OS.ICollection_Count(list)) > 0) {
            item = OS.IList_default(list, count - 1);
        }
        OS.GCHandle_Free(list);
        if (item == 0) {
            list = OS.SelectionChangedEventArgs_RemovedItems(e);
            count = OS.ICollection_Count(list);
            if (count > 0) {
                item = OS.IList_default(list, count - 1);
            }
            OS.GCHandle_Free(list);
        }
        if (item != 0) {
            TableItem result = this.getItem(item, true);
            OS.GCHandle_Free(item);
            if (result != null) {
                Event event = new Event();
                event.item = result;
                this.postEvent(13, event);
            }
        }
    }

    void HandleUnchecked(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        if (this.ignoreSelection) {
            return;
        }
        int source = OS.RoutedEventArgs_Source(e);
        TableItem item = (TableItem)this.display.getWidget(source);
        OS.GCHandle_Free(source);
        if (!OS.FrameworkElement_IsLoaded(item.handle)) {
            return;
        }
        item.checked = false;
        item.updateCheckState(false);
        Event event = new Event();
        event.item = item;
        event.detail = 32;
        this.sendEvent(13, event);
    }

    void hookEvents() {
        super.hookEvents();
        int handler = OS.gcnew_SelectionChangedEventHandler(this.jniRef, "HandleSelectionChanged");
        if (handler == 0) {
            this.error(2);
        }
        OS.Selector_SelectionChanged(this.handle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_MouseButtonEventHandler(this.jniRef, "HandleMouseDoubleClick");
        if (handler == 0) {
            this.error(2);
        }
        OS.Control_MouseDoubleClick(this.handle, handler);
        OS.GCHandle_Free(handler);
        if ((this.style & 0x20) != 0) {
            handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleChecked");
            if (handler == 0) {
                this.error(2);
            }
            int event = OS.ToggleButton_CheckedEvent();
            OS.UIElement_AddHandler(this.handle, event, handler);
            OS.GCHandle_Free(event);
            OS.GCHandle_Free(handler);
            handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleUnchecked");
            if (handler == 0) {
                this.error(2);
            }
            event = OS.ToggleButton_UncheckedEvent();
            OS.UIElement_AddHandler(this.handle, event, handler);
            OS.GCHandle_Free(event);
            OS.GCHandle_Free(handler);
            handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleIndeterminate");
            if (handler == 0) {
                this.error(2);
            }
            event = OS.ToggleButton_IndeterminateEvent();
            OS.UIElement_AddHandler(this.handle, event, handler);
            OS.GCHandle_Free(event);
            OS.GCHandle_Free(handler);
        }
    }

    public int indexOf(TableColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        int columns = OS.GridView_Columns(this.gridViewHandle);
        int index = OS.GridViewColumnCollection_IndexOf(columns, column.handle);
        OS.GCHandle_Free(columns);
        return index;
    }

    public int indexOf(TableItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        int items = OS.ItemsControl_Items(this.handle);
        int index = OS.ItemCollection_IndexOf(items, item.handle);
        OS.GCHandle_Free(items);
        return index;
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        int items = OS.ItemsControl_Items(this.handle);
        int item = OS.ItemCollection_GetItemAt(items, index);
        boolean result = OS.ListBoxItem_IsSelected(item);
        OS.GCHandle_Free(item);
        OS.GCHandle_Free(items);
        return result;
    }

    int parentingHandle() {
        return this.parentingHandle;
    }

    void register() {
        super.register();
        this.display.addWidget(this.parentingHandle, this);
    }

    void releaseChildren(boolean destroy) {
        int items = OS.ItemsControl_Items(this.handle);
        int i = 0;
        while (i < this.itemCount) {
            TableItem item = this.getItem(items, i, false);
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        OS.GCHandle_Free(items);
        int columns = OS.GridView_Columns(this.gridViewHandle);
        int i2 = 0;
        while (i2 < this.columnCount) {
            TableColumn column = this.getColumn(columns, i2);
            if (!column.isDisposed()) {
                column.release(false);
            }
            ++i2;
        }
        OS.GCHandle_Free(columns);
        super.releaseChildren(destroy);
    }

    void releaseHandle() {
        super.releaseHandle();
        OS.GCHandle_Free(this.gridViewHandle);
        this.gridViewHandle = 0;
        OS.GCHandle_Free(this.parentingHandle);
        this.parentingHandle = 0;
    }

    public void remove(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int[] newIndices = new int[indices.length];
        System.arraycopy(indices, 0, newIndices, 0, indices.length);
        this.sort(newIndices);
        int start = newIndices[newIndices.length - 1];
        int end = newIndices[0];
        if (start < 0 || start > end || end >= this.itemCount) {
            this.error(6);
        }
        int items = OS.ItemsControl_Items(this.handle);
        this.ignoreSelection = true;
        int i = newIndices.length - 1;
        while (i >= 0) {
            TableItem item = this.getItem(items, i, false);
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            OS.ItemCollection_RemoveAt(items, newIndices[i]);
            --i;
        }
        this.ignoreSelection = false;
        this.itemCount = OS.ItemCollection_Count(items);
        OS.GCHandle_Free(items);
    }

    public void remove(int index) {
        int items;
        TableItem item;
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        if ((item = this.getItem(items = OS.ItemsControl_Items(this.handle), index, false)) != null && !item.isDisposed()) {
            item.release(false);
        }
        this.ignoreSelection = true;
        OS.ItemCollection_RemoveAt(items, index);
        this.ignoreSelection = false;
        this.itemCount = OS.ItemCollection_Count(items);
        OS.GCHandle_Free(items);
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (start < 0 || start > end || end >= this.itemCount) {
            this.error(6);
        }
        if (start == 0 && end == this.itemCount - 1) {
            this.removeAll();
            return;
        }
        int items = OS.ItemsControl_Items(this.handle);
        this.ignoreSelection = true;
        int i = end;
        while (i >= start) {
            TableItem item = this.getItem(items, i, false);
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            OS.ItemCollection_RemoveAt(items, i);
            --i;
        }
        this.ignoreSelection = false;
        this.itemCount = OS.ItemCollection_Count(items);
        OS.GCHandle_Free(items);
    }

    public void removeAll() {
        this.checkWidget();
        int items = OS.ItemsControl_Items(this.handle);
        int i = 0;
        while (i < this.itemCount) {
            TableItem item = this.getItem(items, i, false);
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        this.ignoreSelection = true;
        OS.ItemCollection_Clear(items);
        this.ignoreSelection = false;
        this.itemCount = OS.ItemCollection_Count(items);
        OS.GCHandle_Free(items);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void select(int[] indices) {
        int length;
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if ((length = indices.length) == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        this.ignoreSelection = true;
        int items = OS.ItemsControl_Items(this.handle);
        int i = 0;
        while (i < indices.length) {
            if (indices[i] >= 0 && indices[i] < this.itemCount) {
                int item = OS.ItemCollection_GetItemAt(items, indices[i]);
                OS.ListBoxItem_IsSelected(item, true);
                OS.GCHandle_Free(item);
            }
            ++i;
        }
        OS.GCHandle_Free(items);
        this.ignoreSelection = false;
    }

    public void select(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            return;
        }
        int items = OS.ItemsControl_Items(this.handle);
        int item = OS.ItemCollection_GetItemAt(items, index);
        this.ignoreSelection = true;
        OS.ListBoxItem_IsSelected(item, true);
        this.ignoreSelection = false;
        OS.GCHandle_Free(item);
        OS.GCHandle_Free(items);
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (start <= 0 && end >= this.itemCount - 1) {
            this.deselectAll();
        } else {
            start = Math.max(0, start);
            end = Math.min(end, this.itemCount - 1);
            int items = OS.ItemsControl_Items(this.handle);
            this.ignoreSelection = true;
            int i = start;
            while (i <= end) {
                int item = OS.ItemCollection_GetItemAt(items, i);
                OS.ListBoxItem_IsSelected(item, true);
                OS.GCHandle_Free(item);
                ++i;
            }
            this.ignoreSelection = false;
            OS.GCHandle_Free(items);
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        this.ignoreSelection = true;
        OS.ListBox_SelectAll(this.handle);
        this.ignoreSelection = false;
    }

    int setBounds(int x, int y, int width, int height, int flags) {
        int result = super.setBounds(x, y, width, height, flags);
        if ((result & 0x4000) != 0) {
            if (this.columnCount == 0) {
                int columns = OS.GridView_Columns(this.gridViewHandle);
                int column = OS.GridViewColumnCollection_default(columns, 0);
                OS.GridViewColumn_Width(column, width);
                OS.GCHandle_Free(column);
                OS.GCHandle_Free(columns);
            }
            OS.FrameworkElement_Width(this.handle, width);
            OS.FrameworkElement_Height(this.handle, height);
        }
        return result;
    }

    public void setColumnOrder(int[] order) {
        this.checkWidget();
        if (order == null) {
            this.error(4);
        }
    }

    void setForegroundBrush(int brush) {
        if (brush != 0) {
            OS.Control_Foreground(this.handle, brush);
        } else {
            int property = OS.Control_ForegroundProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
        }
    }

    public void setHeaderVisible(boolean show) {
        this.checkWidget();
        int style = 0;
        if (!show) {
            style = OS.gcnew_Style();
            int dp = OS.UIElement_VisibilityProperty();
            int setter = OS.gcnew_SetterVisibility(dp, 2);
            int collection = OS.Style_Setters(style);
            OS.SetterBaseCollection_Add(collection, setter);
            OS.GCHandle_Free(collection);
            OS.GCHandle_Free(setter);
            OS.GCHandle_Free(dp);
        }
        OS.GridView_ColumnHeaderContainerStyle(this.gridViewHandle, style);
        if (style != 0) {
            OS.GCHandle_Free(style);
        }
    }

    public void setItemCount(int count) {
        this.checkWidget();
        count = Math.max(0, count);
        if (count == this.itemCount) {
            return;
        }
        int index = this.itemCount - 1;
        int items = OS.ItemsControl_Items(this.handle);
        while (index >= count) {
            TableItem item = this.getItem(items, index, false);
            if (item != null) {
                if (!item.isDisposed()) {
                    item.release(true);
                }
            } else {
                OS.ItemCollection_RemoveAt(items, index);
            }
            --index;
        }
        if (OS.ItemCollection_Count(items) > count) {
            this.error(15);
        }
        if ((this.style & 0x10000000) != 0) {
            int i = this.itemCount;
            while (i < count) {
                int item = OS.gcnew_ListViewItem();
                if (item == 0) {
                    this.error(2);
                }
                int row = OS.gcnew_SWTRow(this.jniRef, item);
                OS.ContentControl_Content(item, row);
                OS.ItemCollection_Add(items, item);
                OS.GCHandle_Free(row);
                OS.GCHandle_Free(item);
                ++i;
            }
        } else {
            int i = this.itemCount;
            while (i < count) {
                new TableItem(this, 0, i);
                ++i;
            }
        }
        this.itemCount = OS.ItemCollection_Count(items);
        OS.GCHandle_Free(items);
        if (this.itemCount != count) {
            this.error(14);
        }
    }

    void setItemHeight(int itemHeight) {
        this.checkWidget();
    }

    public void setLinesVisible(boolean show) {
        this.checkWidget();
    }

    public void setSelection(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = indices.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        this.select(indices);
        this.showSelection();
    }

    public void setSelection(TableItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        this.setSelection(new TableItem[]{item});
    }

    public void setSelection(TableItem[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = items.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        int i = length - 1;
        while (i >= 0) {
            int index = this.indexOf(items[i]);
            if (index != -1) {
                this.select(index);
            }
            --i;
        }
        this.showSelection();
    }

    public void setSelection(int index) {
        this.checkWidget();
        this.deselectAll();
        this.select(index);
        this.showSelection();
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        this.deselectAll();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        if (this.itemCount == 0 || start >= this.itemCount) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, this.itemCount - 1);
        this.select(start, end);
        this.showSelection();
    }

    public void setSortColumn(TableColumn column) {
        this.checkWidget();
        if (column != null && column.isDisposed()) {
            this.error(5);
        }
    }

    public void setSortDirection(int direction) {
        this.checkWidget();
        if ((direction & 0x480) == 0 && direction != 0) {
            return;
        }
    }

    public void setTopIndex(int index) {
        this.checkWidget();
    }

    public void showColumn(TableColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        if (column.parent != this) {
            return;
        }
        int index = this.indexOf(column);
        if (index < 0 || index >= this.columnCount) {
            return;
        }
    }

    public void showItem(TableItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        OS.ListBox_ScrollIntoView(this.handle, item.handle);
    }

    public void showSelection() {
        this.checkWidget();
        int itemCollection = OS.ItemsControl_Items(this.handle);
        int list = OS.ListBox_SelectedItems(this.handle);
        int enumerator = OS.IList_GetEnumerator(list);
        if (OS.IEnumerator_MoveNext(enumerator)) {
            int item = OS.IEnumerator_Current(enumerator);
            OS.ListBox_ScrollIntoView(this.handle, item);
            OS.GCHandle_Free(item);
        }
        OS.GCHandle_Free(enumerator);
        OS.GCHandle_Free(list);
        OS.GCHandle_Free(itemCollection);
    }

    int topHandle() {
        return this.parentingHandle;
    }
}

