/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Spinner
extends Composite {
    int textHandle;
    int upHandle;
    int downHandle;
    int increment;
    int pageIncrement;
    int digits;
    int max;
    int min;
    int value;

    public Spinner(Composite parent, int style) {
        super(parent, Spinner.checkStyle(style));
    }

    Control[] _getChildren() {
        return new Control[0];
    }

    static int checkStyle(int style) {
        return style & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    int backgroundHandle() {
        return this.textHandle;
    }

    int backgroundProperty() {
        return OS.Control_BackgroundProperty();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        return super.computeSize(this.handle, wHint, hHint, changed);
    }

    int createArrow(int direction) {
        int geometry = OS.gcnew_StreamGeometry();
        int context = OS.StreamGeometry_Open(geometry);
        int start = 0;
        int point = 0;
        int end = 0;
        switch (direction) {
            case 1024: {
                start = OS.gcnew_Point(0.0, 0.0);
                point = OS.gcnew_Point(3.0, 3.0);
                end = OS.gcnew_Point(6.0, 0.0);
                break;
            }
            case 128: {
                start = OS.gcnew_Point(0.0, 3.0);
                point = OS.gcnew_Point(3.0, 0.0);
                end = OS.gcnew_Point(6.0, 3.0);
            }
        }
        OS.StreamGeometryContext_BeginFigure(context, start, true, true);
        OS.StreamGeometryContext_LineTo(context, point, true, true);
        OS.StreamGeometryContext_LineTo(context, end, true, true);
        OS.StreamGeometryContext_Close(context);
        int path = OS.gcnew_Path();
        OS.Path_Data(path, geometry);
        int padding = OS.gcnew_Thickness(3.0, 0.0, 3.0, 0.0);
        OS.FrameworkElement_Margin(path, padding);
        int brush = OS.Brushes_Black();
        OS.Path_Fill(path, brush);
        OS.FrameworkElement_HorizontalAlignment(path, 1);
        OS.FrameworkElement_VerticalAlignment(path, 1);
        OS.GCHandle_Free(padding);
        OS.GCHandle_Free(start);
        OS.GCHandle_Free(point);
        OS.GCHandle_Free(end);
        OS.GCHandle_Free(brush);
        OS.GCHandle_Free(context);
        OS.GCHandle_Free(geometry);
        return path;
    }

    void createHandle() {
        this.handle = OS.gcnew_Grid();
        if (this.handle == 0) {
            this.error(2);
        }
        int row0 = OS.gcnew_RowDefinition();
        int row1 = OS.gcnew_RowDefinition();
        int rows = OS.Grid_RowDefinitions(this.handle);
        OS.RowDefinitionCollection_Add(rows, row0);
        OS.RowDefinitionCollection_Add(rows, row1);
        int col0 = OS.gcnew_ColumnDefinition();
        int col1 = OS.gcnew_ColumnDefinition();
        int columns = OS.Grid_ColumnDefinitions(this.handle);
        OS.ColumnDefinitionCollection_Add(columns, col0);
        OS.ColumnDefinitionCollection_Add(columns, col1);
        int gridChildren = OS.Panel_Children(this.handle);
        this.textHandle = OS.gcnew_TextBox();
        if (this.textHandle == 0) {
            this.error(2);
        }
        OS.Grid_SetRowSpan(this.textHandle, 2);
        OS.UIElementCollection_Add(gridChildren, this.textHandle);
        this.upHandle = OS.gcnew_RepeatButton();
        if (this.upHandle == 0) {
            this.error(2);
        }
        int upArrow = this.createArrow(128);
        OS.ContentControl_Content(this.upHandle, upArrow);
        OS.Grid_SetColumn(this.upHandle, 1);
        OS.UIElementCollection_Add(gridChildren, this.upHandle);
        this.downHandle = OS.gcnew_RepeatButton();
        if (this.downHandle == 0) {
            this.error(2);
        }
        int downArrow = this.createArrow(1024);
        OS.ContentControl_Content(this.downHandle, downArrow);
        OS.Grid_SetColumn(this.downHandle, 1);
        OS.Grid_SetRow(this.downHandle, 1);
        OS.UIElementCollection_Add(gridChildren, this.downHandle);
        int colWidth0 = OS.gcnew_GridLength(10.0, 2);
        OS.ColumnDefinition_Width(col0, colWidth0);
        int colWidth1 = OS.gcnew_GridLength(1.0, 0);
        OS.ColumnDefinition_Width(col1, colWidth1);
        OS.GCHandle_Free(colWidth0);
        OS.GCHandle_Free(colWidth1);
        OS.GCHandle_Free(upArrow);
        OS.GCHandle_Free(downArrow);
        OS.GCHandle_Free(row0);
        OS.GCHandle_Free(row1);
        OS.GCHandle_Free(rows);
        OS.GCHandle_Free(col0);
        OS.GCHandle_Free(col1);
        OS.GCHandle_Free(columns);
        OS.GCHandle_Free(gridChildren);
    }

    void createWidget() {
        super.createWidget();
        this.increment = 1;
        this.pageIncrement = 10;
        this.digits = 0;
        this.max = 100;
        this.value = 0;
        this.updateText();
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    public void copy() {
        this.checkWidget();
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
    }

    public int getDigits() {
        this.checkWidget();
        return this.digits;
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        return this.max;
    }

    public int getMinimum() {
        this.checkWidget();
        return this.min;
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int getSelection() {
        this.checkWidget();
        return this.value;
    }

    void HandleDownClick(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        this.value -= this.increment;
        this.value = Math.max(this.value, this.min);
        this.updateText();
        this.postEvent(13);
    }

    void HandleUpClick(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        this.value += this.increment;
        this.value = Math.min(this.value, this.max);
        this.updateText();
        this.postEvent(13);
    }

    void hookEvents() {
        super.hookEvents();
        int handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleDownClick");
        if (handler == 0) {
            this.error(2);
        }
        OS.ButtonBase_Click(this.downHandle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleUpClick");
        if (handler == 0) {
            this.error(2);
        }
        OS.ButtonBase_Click(this.upHandle, handler);
        OS.GCHandle_Free(handler);
    }

    public void paste() {
        this.checkWidget();
    }

    void releaseHandle() {
        super.releaseHandle();
        OS.GCHandle_Free(this.textHandle);
        OS.GCHandle_Free(this.upHandle);
        OS.GCHandle_Free(this.downHandle);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    public void setDigits(int value) {
        this.checkWidget();
        if (value < 0) {
            this.error(5);
        }
        this.digits = value;
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.increment = value;
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        this.max = value;
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        this.min = value;
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.pageIncrement = value;
    }

    public void setSelection(int value) {
        this.checkWidget();
        this.value = value;
        this.updateText();
    }

    public void setValues(int selection, int minimum, int maximum, int digits, int increment, int pageIncrement) {
        this.checkWidget();
        if (minimum < 0) {
            return;
        }
        if (maximum <= minimum) {
            return;
        }
        if (digits < 0) {
            return;
        }
        if (increment < 1) {
            return;
        }
        if (pageIncrement < 1) {
            return;
        }
        this.value = Math.min(Math.max(minimum, selection), maximum);
        this.setIncrement(increment);
        this.pageIncrement = pageIncrement;
        this.digits = digits;
        this.min = minimum;
        this.max = maximum;
        this.increment = increment;
        this.pageIncrement = pageIncrement;
        this.updateText();
    }

    void updateText() {
        String valStr = this.digits == 0 ? String.valueOf(this.value) : new Double((double)this.value / Math.pow(10.0, this.digits)).toString();
        int strPtr = this.createDotNetString(valStr, false);
        OS.TextBox_Text(this.textHandle, strPtr);
        OS.GCHandle_Free(strPtr);
    }

    String verifyText(String string, int start, int end, Event keyEvent) {
        Event event = new Event();
        event.text = string;
        event.start = start;
        event.end = end;
        if (keyEvent != null) {
            event.character = keyEvent.character;
            event.keyCode = keyEvent.keyCode;
            event.stateMask = keyEvent.stateMask;
        }
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

