/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class List
extends Scrollable {
    boolean ignoreSelection;

    public List(Composite parent, int style) {
        super(parent, List.checkStyle(style));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int item = OS.gcnew_ListBoxItem();
        int strPtr = this.createDotNetString(string, false);
        OS.ContentControl_Content(item, strPtr);
        OS.GCHandle_Free(strPtr);
        int items = OS.ItemsControl_Items(this.handle);
        OS.ItemCollection_Add(items, item);
        OS.GCHandle_Free(items);
        OS.GCHandle_Free(item);
    }

    public void add(String string, int index) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index < 0 || index > this.getItemCount()) {
            this.error(6);
        }
        int item = OS.gcnew_ListBoxItem();
        int strPtr = this.createDotNetString(string, false);
        OS.ContentControl_Content(item, strPtr);
        OS.GCHandle_Free(strPtr);
        int items = OS.ItemsControl_Items(this.handle);
        OS.ItemCollection_Insert(items, index, item);
        OS.GCHandle_Free(items);
        OS.GCHandle_Free(item);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return List.checkBits(style, 4, 2, 0, 0, 0, 0);
    }

    void createHandle() {
        this.handle = OS.gcnew_ListBox();
        if (this.handle == 0) {
            this.error(2);
        }
        OS.Selector_IsSynchronizedWithCurrentItem(this.handle, true);
        if ((this.style & 2) != 0) {
            OS.ListBox_SelectionMode(this.handle, 2);
        }
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int count = this.getItemCount();
        int items = OS.ItemsControl_Items(this.handle);
        this.ignoreSelection = true;
        int i = 0;
        while (i < indices.length) {
            int index = indices[i];
            if (index >= 0 && index < count) {
                int item = OS.ItemCollection_GetItemAt(items, index);
                OS.ListBoxItem_IsSelected(item, false);
                OS.GCHandle_Free(item);
            }
            ++i;
        }
        this.ignoreSelection = false;
        OS.GCHandle_Free(items);
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index == -1) {
            return;
        }
        if (index >= 0 && index < this.getItemCount()) {
            int items = OS.ItemsControl_Items(this.handle);
            int item = OS.ItemCollection_GetItemAt(items, index);
            OS.GCHandle_Free(items);
            this.ignoreSelection = true;
            OS.ListBoxItem_IsSelected(item, false);
            this.ignoreSelection = false;
            OS.GCHandle_Free(item);
        }
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        int count = this.getItemCount();
        int items = OS.ItemsControl_Items(this.handle);
        this.ignoreSelection = true;
        int i = end;
        while (i >= start) {
            if (i >= 0 && i < count) {
                int item = OS.ItemCollection_GetItemAt(items, i);
                OS.ListBoxItem_IsSelected(item, false);
                OS.GCHandle_Free(item);
            }
            --i;
        }
        this.ignoreSelection = false;
        OS.GCHandle_Free(items);
    }

    public void deselectAll() {
        this.checkWidget();
        this.ignoreSelection = true;
        OS.ListBox_UnselectAll(this.handle);
        this.ignoreSelection = false;
    }

    public int getFocusIndex() {
        this.checkWidget();
        int items = OS.ItemsControl_Items(this.handle);
        int index = OS.ItemCollection_CurrentPosition(items);
        OS.GCHandle_Free(items);
        return index;
    }

    public String getItem(int index) {
        this.checkWidget();
        int count = this.getItemCount();
        if (index < 0 || index >= count) {
            this.error(6);
        }
        int items = OS.ItemsControl_Items(this.handle);
        int item = OS.ItemCollection_GetItemAt(items, index);
        int content = OS.ContentControl_Content(item);
        String string = List.createJavaString(content);
        OS.GCHandle_Free(item);
        OS.GCHandle_Free(items);
        OS.GCHandle_Free(content);
        return string;
    }

    public int getItemCount() {
        this.checkWidget();
        int items = OS.ItemsControl_Items(this.handle);
        int count = OS.ItemCollection_Count(items);
        OS.GCHandle_Free(items);
        return count;
    }

    public int getItemHeight() {
        this.checkWidget();
        int result = 0;
        if (OS.ItemsControl_HasItems(this.handle)) {
            int items = OS.ItemsControl_Items(this.handle);
            int item = OS.ItemCollection_GetItemAt(items, 0);
            OS.GCHandle_Free(items);
            result = (int)OS.FrameworkElement_ActualHeight(item);
            OS.GCHandle_Free(item);
        }
        return result;
    }

    public String[] getItems() {
        this.checkWidget();
        int count = this.getItemCount();
        String[] result = new String[count];
        int i = 0;
        while (i < count) {
            result[i] = this.getItem(i);
            ++i;
        }
        return result;
    }

    public String[] getSelection() {
        this.checkWidget();
        int[] indices = this.getSelectionIndices();
        String[] result = new String[indices.length];
        int i = 0;
        while (i < indices.length) {
            result[i] = this.getItem(indices[i]);
            ++i;
        }
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        int selectedItems = OS.ListBox_SelectedItems(this.handle);
        int result = OS.ICollection_Count(selectedItems);
        OS.GCHandle_Free(selectedItems);
        return result;
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return OS.Selector_SelectedIndex(this.handle);
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        int items = OS.ItemsControl_Items(this.handle);
        int list = OS.ListBox_SelectedItems(this.handle);
        int enumerator = OS.IList_GetEnumerator(list);
        int count = OS.ICollection_Count(list);
        int[] indices = new int[count];
        int index = 0;
        while (OS.IEnumerator_MoveNext(enumerator)) {
            int item = OS.IEnumerator_Current(enumerator);
            indices[index++] = OS.ItemCollection_IndexOf(items, item);
            OS.GCHandle_Free(item);
        }
        OS.GCHandle_Free(enumerator);
        OS.GCHandle_Free(list);
        OS.GCHandle_Free(items);
        this.sortAscending(indices);
        return indices;
    }

    public int getTopIndex() {
        this.checkWidget();
        int topIndex = 0;
        if (OS.ItemsControl_HasItems(this.handle)) {
            int items = OS.ItemsControl_Items(this.handle);
            int item = OS.ItemCollection_GetItemAt(items, 0);
            OS.GCHandle_Free(items);
            int virtualizingStackPanel = OS.VisualTreeHelper_GetParent(item);
            OS.GCHandle_Free(item);
            if (virtualizingStackPanel != 0) {
                topIndex = (int)OS.VirtualizingStackPanel_VerticalOffset(virtualizingStackPanel);
                OS.GCHandle_Free(virtualizingStackPanel);
            }
        }
        return topIndex;
    }

    void HandleMouseDoubleClick(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        this.postEvent(14);
    }

    void HandleSelectionChanged(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        if (!this.ignoreSelection) {
            this.postEvent(13);
        }
    }

    void HandlePreviewKeyDown(int sender, int e) {
        super.HandlePreviewKeyDown(sender, e);
        if (!this.checkEvent(e)) {
            return;
        }
        int key = OS.KeyEventArgs_Key(e);
        if (key == 6) {
            this.postEvent(14);
        }
    }

    void hookEvents() {
        super.hookEvents();
        int handler = OS.gcnew_SelectionChangedEventHandler(this.jniRef, "HandleSelectionChanged");
        OS.Selector_SelectionChanged(this.handle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_MouseButtonEventHandler(this.jniRef, "HandleMouseDoubleClick");
        OS.Control_MouseDoubleClick(this.handle, handler);
        OS.GCHandle_Free(handler);
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        int count;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (start >= (count = this.getItemCount())) {
            return -1;
        }
        start = Math.max(start, 0);
        int strPtr = this.createDotNetString(string, false);
        int items = OS.ItemsControl_Items(this.handle);
        int index = -1;
        while (start < count && index == -1) {
            int item = OS.ItemCollection_GetItemAt(items, start);
            int content = OS.ContentControl_Content(item);
            OS.GCHandle_Free(item);
            if (content != 0) {
                if (OS.Object_Equals(content, strPtr)) {
                    index = start;
                }
                OS.GCHandle_Free(content);
            }
            ++start;
        }
        OS.GCHandle_Free(strPtr);
        OS.GCHandle_Free(items);
        return index;
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        boolean selected = false;
        if (index >= 0 && index < this.getItemCount()) {
            int items = OS.ItemsControl_Items(this.handle);
            int item = OS.ItemCollection_GetItemAt(items, index);
            selected = OS.ListBoxItem_IsSelected(item);
            OS.GCHandle_Free(items);
            OS.GCHandle_Free(item);
        }
        return selected;
    }

    public void remove(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int[] newIndices = new int[indices.length];
        System.arraycopy(indices, 0, newIndices, 0, indices.length);
        this.sort(newIndices);
        int start = newIndices[newIndices.length - 1];
        int end = newIndices[0];
        int count = this.getItemCount();
        if (start < 0 || start > end || end >= count) {
            this.error(6);
        }
        int items = OS.ItemsControl_Items(this.handle);
        int i = newIndices.length - 1;
        while (i >= 0) {
            OS.ItemCollection_RemoveAt(items, indices[i]);
            --i;
        }
        OS.GCHandle_Free(items);
    }

    public void remove(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.getItemCount()) {
            this.error(6);
        }
        int items = OS.ItemsControl_Items(this.handle);
        OS.ItemCollection_RemoveAt(items, index);
        OS.GCHandle_Free(items);
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        int count = this.getItemCount();
        if (start < 0 || start > end || end >= count) {
            this.error(6);
        }
        if (start == 0 && end == count - 1) {
            this.removeAll();
            return;
        }
        int items = OS.ItemsControl_Items(this.handle);
        int i = end;
        while (i >= start) {
            OS.ItemCollection_RemoveAt(items, i);
            --i;
        }
        OS.GCHandle_Free(items);
    }

    public void remove(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((index = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(index);
    }

    public void removeAll() {
        this.checkWidget();
        int items = OS.ItemsControl_Items(this.handle);
        this.ignoreSelection = true;
        OS.ItemCollection_Clear(items);
        this.ignoreSelection = false;
        OS.GCHandle_Free(items);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void select(int[] indices) {
        int length;
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if ((length = indices.length) == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        this.select(indices, false);
    }

    void select(int[] indices, boolean scroll) {
        int i = 0;
        while (i < indices.length) {
            int index = indices[i];
            if (index != -1) {
                this.select(index, false);
            }
            ++i;
        }
        if (scroll) {
            this.showSelection();
        }
    }

    public void select(int index) {
        this.checkWidget();
        this.select(index, false);
    }

    void select(int index, boolean scroll) {
        if (index < 0) {
            return;
        }
        int count = this.getItemCount();
        if (index >= count) {
            return;
        }
        int items = OS.ItemsControl_Items(this.handle);
        int item = OS.ItemCollection_GetItemAt(items, index);
        OS.GCHandle_Free(items);
        this.ignoreSelection = true;
        OS.ListBoxItem_IsSelected(item, true);
        this.ignoreSelection = false;
        if (scroll) {
            OS.FrameworkElement_BringIntoView(item);
        }
        OS.GCHandle_Free(item);
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        int count = this.getItemCount();
        if (count == 0 || start >= count) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, count - 1);
        this.ignoreSelection = true;
        if ((this.style & 4) != 0) {
            this.select(start, false);
        } else {
            this.select(start, end, false);
        }
        this.ignoreSelection = false;
    }

    void select(int start, int end, boolean scroll) {
        int items = OS.ItemsControl_Items(this.handle);
        this.ignoreSelection = true;
        int i = start;
        while (i <= end) {
            int item = OS.ItemCollection_GetItemAt(items, i);
            OS.ListBoxItem_IsSelected(item, true);
            OS.GCHandle_Free(item);
            ++i;
        }
        this.ignoreSelection = false;
        OS.GCHandle_Free(items);
        if (scroll) {
            this.showSelection();
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        this.ignoreSelection = true;
        OS.ListBox_SelectAll(this.handle);
        this.ignoreSelection = false;
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int topIndex = this.getTopIndex();
        boolean isSelected = this.isSelected(index);
        this.remove(index);
        this.add(string, index);
        if (isSelected) {
            this.select(index, false);
        }
        this.setTopIndex(topIndex);
    }

    public void setItems(String[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        int i = 0;
        while (i < items.length) {
            if (items[i] == null) {
                this.error(5);
            }
            ++i;
        }
        int itemCollection = OS.ItemsControl_Items(this.handle);
        this.ignoreSelection = true;
        OS.ItemCollection_Clear(itemCollection);
        int i2 = 0;
        while (i2 < items.length) {
            String string = items[i2];
            int item = OS.gcnew_ListBoxItem();
            int strPtr = this.createDotNetString(string, false);
            OS.ContentControl_Content(item, strPtr);
            OS.GCHandle_Free(strPtr);
            OS.ItemCollection_Add(itemCollection, item);
            OS.GCHandle_Free(item);
            ++i2;
        }
        this.ignoreSelection = false;
        OS.GCHandle_Free(itemCollection);
    }

    public void setSelection(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = indices.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        this.select(indices, true);
    }

    public void setSelection(String[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = items.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        int i = length - 1;
        while (i >= 0) {
            String string = items[i];
            int index = 0;
            if (string != null) {
                while ((index = this.indexOf(string, index)) != -1) {
                    this.select(index, false);
                    if ((this.style & 4) != 0 && this.isSelected(index)) {
                        this.showSelection();
                        return;
                    }
                    ++index;
                }
            }
            --i;
        }
    }

    public void setSelection(int index) {
        this.checkWidget();
        this.deselectAll();
        this.select(index, true);
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        this.deselectAll();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        int count = this.getItemCount();
        if (count == 0 || start >= count) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, count - 1);
        if ((this.style & 4) != 0) {
            this.select(start, true);
        } else {
            this.select(start, end, true);
        }
    }

    public void setTopIndex(int index) {
        this.checkWidget();
    }

    public void showSelection() {
        this.checkWidget();
        int items = OS.ItemsControl_Items(this.handle);
        int selectedItems = OS.ListBox_SelectedItems(this.handle);
        int enumerator = OS.IList_GetEnumerator(selectedItems);
        if (OS.IEnumerator_MoveNext(enumerator)) {
            int item = OS.IEnumerator_Current(enumerator);
            OS.ListBox_ScrollIntoView(this.handle, item);
            OS.GCHandle_Free(item);
        }
        OS.GCHandle_Free(enumerator);
        OS.GCHandle_Free(selectedItems);
        OS.GCHandle_Free(items);
    }
}

