/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class FontDialog
extends Dialog {
    FontData fontData;
    RGB rgb;

    public FontDialog(Shell parent) {
        this(parent, 32768);
    }

    public FontDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public FontData[] getFontList() {
        if (this.fontData == null) {
            return null;
        }
        FontData[] result = new FontData[]{this.fontData};
        return result;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public FontData open() {
        int result;
        boolean success;
        int dialog = OS.gcnew_FontDialog();
        OS.FontDialog_ShowColor(dialog, true);
        if (this.fontData != null) {
            int fontFamily = this.parent.createDotNetString(this.fontData.fontFamily, false);
            int fontStyle = 0;
            int fontWeight = OS.FontWeight_ToOpenTypeWeight(OS.FontWeights_Bold);
            if (fontWeight == this.fontData.weight) {
                fontStyle |= 1;
            }
            if (this.fontData.style == OS.FontStyles_Italic) {
                fontStyle |= 2;
            }
            if (this.fontData.style == OS.FontStyles_Normal) {
                fontStyle |= 0;
            }
            int font = OS.gcnew_Font(fontFamily, this.fontData.height, fontStyle);
            OS.FontDialog_Font(dialog, font);
            OS.GCHandle_Free(font);
            OS.GCHandle_Free(fontFamily);
        }
        if (this.rgb != null) {
            int color = OS.DrawingColor_FromArgb(174, this.rgb.red, this.rgb.blue, this.rgb.green);
            OS.FontDialog_Color(dialog, color);
            OS.GCHandle_Free(color);
        }
        boolean bl = success = (result = OS.FormsCommonDialog_ShowDialog(dialog)) == 1;
        if (success) {
            int font = OS.FontDialog_Font(dialog);
            int fontFamilyPtr = OS.Font_FontFamily(font);
            int fontFamilyName = OS.DrawingFontFamily_Name(fontFamilyPtr);
            String fontFamily = Widget.createJavaString(fontFamilyName);
            int fontStyle = OS.Font_Style(font);
            int fontDataStyle = (fontStyle & 2) != 0 ? OS.FontStyles_Italic : OS.FontStyles_Normal;
            int weight = (fontStyle & 1) != 0 ? OS.FontWeight_ToOpenTypeWeight(OS.FontWeights_Bold) : OS.FontWeight_ToOpenTypeWeight(OS.FontWeights_Normal);
            int height = OS.Font_Size(font);
            OS.GCHandle_Free(fontFamilyName);
            OS.GCHandle_Free(fontFamilyPtr);
            OS.GCHandle_Free(font);
            this.fontData = FontData.wpf_new(fontFamily, fontDataStyle, weight, 1, height);
            int color = OS.FontDialog_Color(dialog);
            int argb = OS.DrawingColor_ToArgb(color);
            int red = (argb & 0xFF0000) >> 16;
            int green = (argb & 0xFF00) >> 8;
            int blue = argb & 0xFF;
            OS.GCHandle_Free(color);
            this.rgb = new RGB(red, green, blue);
        }
        OS.GCHandle_Free(dialog);
        return success ? this.fontData : null;
    }

    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setFontList(FontData[] fontData) {
        this.fontData = fontData != null && fontData.length > 0 ? fontData[0] : null;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }
}

