/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.Item;

public class ExpandItem
extends Item {
    ExpandBar parent;
    Control control;
    int imageHandle;
    int textHandle;
    int contentHandle;

    public ExpandItem(ExpandBar parent, int style) {
        this(parent, style, ExpandItem.checkNull(parent).getItemCount());
    }

    public ExpandItem(ExpandBar parent, int style, int index) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, style, index);
    }

    static ExpandBar checkNull(ExpandBar control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    void createHandle() {
        int panel;
        this.handle = OS.gcnew_Expander();
        if (this.handle == 0) {
            this.error(2);
        }
        int spacing = this.parent.spacing;
        int thickness = OS.gcnew_Thickness(spacing, spacing, spacing, spacing);
        OS.FrameworkElement_Margin(this.handle, thickness);
        OS.GCHandle_Free(thickness);
        this.imageHandle = OS.gcnew_Image();
        if (this.imageHandle == 0) {
            this.error(2);
        }
        OS.Image_Stretch(this.imageHandle, 0);
        OS.UIElement_Visibility(this.imageHandle, (byte)2);
        this.textHandle = OS.gcnew_TextBlock();
        if (this.textHandle == 0) {
            this.error(2);
        }
        if ((panel = OS.gcnew_StackPanel()) == 0) {
            this.error(2);
        }
        OS.StackPanel_Orientation(panel, 0);
        thickness = OS.gcnew_Thickness(1.0, 1.0, 1.0, 1.0);
        if (thickness == 0) {
            this.error(2);
        }
        OS.FrameworkElement_Margin(panel, thickness);
        OS.GCHandle_Free(thickness);
        int children = OS.Panel_Children(panel);
        OS.UIElementCollection_Add(children, this.imageHandle);
        OS.UIElementCollection_Add(children, this.textHandle);
        OS.GCHandle_Free(children);
        OS.HeaderedContentControl_Header(this.handle, panel);
        OS.GCHandle_Free(panel);
        this.contentHandle = OS.gcnew_Canvas();
        if (this.contentHandle == 0) {
            this.error(2);
        }
        OS.ContentControl_Content(this.handle, this.contentHandle);
    }

    void deregister() {
        this.display.removeWidget(this.handle);
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public boolean getExpanded() {
        this.checkWidget();
        return OS.Expander_IsExpanded(this.handle);
    }

    public int getHeaderHeight() {
        this.checkWidget();
        int panel = OS.HeaderedContentControl_Header(this.handle);
        return (int)OS.FrameworkElement_ActualHeight(panel);
    }

    public int getHeight() {
        this.checkWidget();
        return (int)OS.FrameworkElement_Height(this.contentHandle);
    }

    public ExpandBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    Control getWidgetControl() {
        return this.parent;
    }

    void HandleExpanded(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        Event event = new Event();
        event.item = this;
        this.parent.notifyListeners(17, event);
    }

    void HandleCollapsed(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        Event event = new Event();
        event.item = this;
        this.parent.notifyListeners(18, event);
    }

    void HandleSizeChanged(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        this.resizeControl();
    }

    void hookEvents() {
        super.hookEvents();
        int handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleExpanded");
        if (handler == 0) {
            this.error(2);
        }
        OS.Expander_Expanded(this.handle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleCollapsed");
        if (handler == 0) {
            this.error(2);
        }
        OS.Expander_Collapsed(this.handle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_SizeChangedEventHandler(this.jniRef, "HandleSizeChanged");
        if (handler == 0) {
            this.error(2);
        }
        OS.FrameworkElement_SizeChanged(this.contentHandle, handler);
        OS.GCHandle_Free(handler);
    }

    void register() {
        this.display.addWidget(this.handle, this);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.handle != 0) {
            OS.GCHandle_Free(this.handle);
        }
        this.handle = 0;
        this.parent = null;
        if (this.textHandle != 0) {
            OS.GCHandle_Free(this.textHandle);
        }
        this.textHandle = 0;
        if (this.imageHandle != 0) {
            OS.GCHandle_Free(this.imageHandle);
        }
        this.imageHandle = 0;
        if (this.contentHandle != 0) {
            OS.GCHandle_Free(this.contentHandle);
        }
        this.contentHandle = 0;
    }

    void resizeControl() {
        if (this.control != null) {
            int width = (int)OS.FrameworkElement_ActualWidth(this.contentHandle);
            int height = (int)OS.FrameworkElement_Height(this.contentHandle);
            this.control.setSize(width, height);
        }
    }

    public void setControl(Control control) {
        int topHandle;
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        Control oldControl = this.control;
        Control newControl = control;
        this.control = control;
        int children = OS.Panel_Children(this.contentHandle);
        int parentHandle = this.parent.parentingHandle();
        int parentChildren = OS.Panel_Children(parentHandle);
        if (newControl != null) {
            topHandle = newControl.topHandle();
            OS.UIElementCollection_Remove(parentChildren, topHandle);
            OS.UIElementCollection_Add(children, topHandle);
        }
        if (oldControl != null) {
            topHandle = oldControl.topHandle();
            OS.UIElementCollection_Remove(children, topHandle);
            OS.UIElementCollection_Add(parentChildren, topHandle);
        }
        OS.GCHandle_Free(children);
        OS.GCHandle_Free(parentChildren);
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        OS.Expander_IsExpanded(this.handle, expanded);
    }

    public void setHeight(int height) {
        this.checkWidget();
        if (height < 0) {
            return;
        }
        OS.FrameworkElement_Height(this.contentHandle, height);
    }

    public void setImage(Image image) {
        super.setImage(image);
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        OS.Image_Source(this.imageHandle, image != null ? image.handle : 0);
        OS.UIElement_Visibility(this.imageHandle, image != null ? (byte)0 : 2);
        OS.UIElement_Visibility(this.textHandle, (byte)(image != null && this.text.length() == 0 ? 2 : 0));
        int spacing = image != null && this.text.length() != 0 ? 3 : 0;
        int margin = OS.gcnew_Thickness(0.0, 0.0, spacing, 0.0);
        if (margin == 0) {
            this.error(2);
        }
        OS.FrameworkElement_Margin(this.imageHandle, margin);
        OS.GCHandle_Free(margin);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        int ptr = this.createDotNetString(this.text, false);
        if (ptr == 0) {
            this.error(2);
        }
        OS.TextBlock_Text(this.textHandle, ptr);
        OS.GCHandle_Free(ptr);
        OS.UIElement_Visibility(this.textHandle, (byte)(this.text.length() == 0 && this.image != null ? 2 : 0));
        int spacing = this.image != null && this.text.length() != 0 ? 3 : 0;
        int margin = OS.gcnew_Thickness(0.0, 0.0, spacing, 0.0);
        if (margin == 0) {
            this.error(2);
        }
        OS.FrameworkElement_Margin(this.imageHandle, margin);
        OS.GCHandle_Free(margin);
    }
}

