/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.wpf.OS;

public final class Region
extends Resource {
    public int handle;

    public Region() {
        this(null);
    }

    public Region(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        this.handle = OS.gcnew_GeometryGroup();
        if (this.handle == 0) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    Region(Device device, int handle) {
        this.device = device;
        this.handle = handle;
    }

    public void add(int[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        this.combine(pointArray, 0);
    }

    public void add(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.add(rect.x, rect.y, rect.width, rect.height);
    }

    public void add(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (width < 0 || height < 0) {
            SWT.error(5);
        }
        int rect = OS.gcnew_Rect(x, y, width, height);
        int geometry1 = OS.gcnew_RectangleGeometry(rect);
        int geometries = OS.GeometryGroup_Children(this.handle);
        if (OS.GeometryCollection_Count(geometries) == 0) {
            OS.GeometryCollection_Add(geometries, geometry1);
        } else {
            int geometry2 = OS.GeometryGroup_Children(this.handle, 0);
            int geometry3 = OS.gcnew_CombinedGeometry(0, geometry1, geometry2);
            OS.GeometryCollection_Remove(geometries, geometry2);
            OS.GeometryCollection_Add(geometries, geometry3);
            OS.GCHandle_Free(geometry2);
            OS.GCHandle_Free(geometry3);
        }
        OS.GCHandle_Free(rect);
        OS.GCHandle_Free(geometry1);
        OS.GCHandle_Free(geometries);
    }

    public void add(Region region) {
        int geometries;
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        if (OS.GeometryCollection_Count(geometries = OS.GeometryGroup_Children(this.handle)) == 0) {
            OS.GeometryCollection_Add(geometries, region.handle);
        } else {
            int geometry2 = OS.GeometryGroup_Children(this.handle, 0);
            int geometry3 = OS.gcnew_CombinedGeometry(0, region.handle, geometry2);
            OS.GeometryCollection_Remove(geometries, geometry2);
            OS.GeometryCollection_Add(geometries, geometry3);
            OS.GCHandle_Free(geometry2);
            OS.GCHandle_Free(geometry3);
        }
        OS.GCHandle_Free(geometries);
    }

    void combine(int[] pointArray, int mode) {
        if (pointArray.length < 4) {
            return;
        }
        int list = OS.gcnew_PointCollection(pointArray.length / 2);
        int i = 2;
        while (i < pointArray.length) {
            int point = OS.gcnew_Point(pointArray[i], pointArray[i + 1]);
            OS.PointCollection_Add(list, point);
            OS.GCHandle_Free(point);
            i += 2;
        }
        int poly = OS.gcnew_PolyLineSegment(list, true);
        OS.GCHandle_Free(list);
        int figure = OS.gcnew_PathFigure();
        int startPoint = OS.gcnew_Point(pointArray[0], pointArray[1]);
        OS.PathFigure_StartPoint(figure, startPoint);
        OS.PathFigure_IsClosed(figure, true);
        int segments = OS.PathFigure_Segments(figure);
        OS.PathSegmentCollection_Add(segments, poly);
        int path = OS.gcnew_PathGeometry();
        int figures = OS.PathGeometry_Figures(path);
        OS.PathFigureCollection_Add(figures, figure);
        int geometries = OS.GeometryGroup_Children(this.handle);
        if (OS.GeometryCollection_Count(geometries) == 0) {
            if (mode == 0) {
                OS.GeometryCollection_Add(geometries, path);
            }
        } else {
            int geometry2 = OS.GeometryGroup_Children(this.handle, 0);
            int geometry3 = OS.gcnew_CombinedGeometry(mode, geometry2, path);
            OS.GeometryCollection_Remove(geometries, geometry2);
            OS.GeometryCollection_Add(geometries, geometry3);
            OS.GCHandle_Free(geometry2);
            OS.GCHandle_Free(geometry3);
        }
        OS.GCHandle_Free(geometries);
        OS.GCHandle_Free(figures);
        OS.GCHandle_Free(path);
        OS.GCHandle_Free(segments);
        OS.GCHandle_Free(figure);
        OS.GCHandle_Free(startPoint);
        OS.GCHandle_Free(poly);
    }

    public boolean contains(int x, int y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int point = OS.gcnew_Point(x, y);
        boolean result = OS.Geometry_FillContains(this.handle, point);
        OS.GCHandle_Free(point);
        return result;
    }

    public boolean contains(Point pt) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pt == null) {
            SWT.error(4);
        }
        return this.contains(pt.x, pt.y);
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        OS.GCHandle_Free(this.handle);
        this.handle = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Region)) {
            return false;
        }
        Region rgn = (Region)object;
        return this.handle == rgn.handle;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (OS.Geometry_IsEmpty(this.handle)) {
            return new Rectangle(0, 0, 0, 0);
        }
        int rect = OS.Geometry_Bounds(this.handle);
        Rectangle result = new Rectangle((int)OS.Rect_X(rect), (int)OS.Rect_Y(rect), (int)OS.Rect_Width(rect), (int)OS.Rect_Height(rect));
        OS.GCHandle_Free(rect);
        return result;
    }

    public int hashCode() {
        return this.handle;
    }

    public void intersect(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.intersect(rect.x, rect.y, rect.width, rect.height);
    }

    public void intersect(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (width < 0 || height < 0) {
            SWT.error(5);
        }
        int rect = OS.gcnew_Rect(x, y, width, height);
        int geometry1 = OS.gcnew_RectangleGeometry(rect);
        int geometries = OS.GeometryGroup_Children(this.handle);
        if (OS.GeometryCollection_Count(geometries) != 0) {
            int geometry2 = OS.GeometryGroup_Children(this.handle, 0);
            int geometry3 = OS.gcnew_CombinedGeometry(1, geometry1, geometry2);
            OS.GeometryCollection_Remove(geometries, geometry2);
            OS.GeometryCollection_Add(geometries, geometry3);
            OS.GCHandle_Free(geometry2);
            OS.GCHandle_Free(geometry3);
        }
        OS.GCHandle_Free(rect);
        OS.GCHandle_Free(geometry1);
        OS.GCHandle_Free(geometries);
    }

    public void intersect(Region region) {
        int geometries;
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        if (OS.GeometryCollection_Count(geometries = OS.GeometryGroup_Children(this.handle)) != 0) {
            int geometry2 = OS.GeometryGroup_Children(this.handle, 0);
            int geometry3 = OS.gcnew_CombinedGeometry(1, region.handle, geometry2);
            OS.GeometryCollection_Remove(geometries, geometry2);
            OS.GeometryCollection_Add(geometries, geometry3);
            OS.GCHandle_Free(geometry2);
            OS.GCHandle_Free(geometry3);
        }
        OS.GCHandle_Free(geometries);
    }

    public boolean intersects(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int rect = OS.gcnew_Rect(x, y, width, height);
        int geometry = OS.gcnew_RectangleGeometry(rect);
        int result = OS.Geometry_FillContainsWithDetail(this.handle, geometry);
        OS.GCHandle_Free(geometry);
        OS.GCHandle_Free(rect);
        return result != 1;
    }

    public boolean intersects(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        return this.intersects(rect.x, rect.y, rect.width, rect.height);
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public boolean isEmpty() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.Geometry_IsEmpty(this.handle);
    }

    public void subtract(int[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        this.combine(pointArray, 3);
    }

    public void subtract(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.subtract(rect.x, rect.y, rect.width, rect.height);
    }

    public void subtract(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (width < 0 || height < 0) {
            SWT.error(5);
        }
        int rect = OS.gcnew_Rect(x, y, width, height);
        int geometry1 = OS.gcnew_RectangleGeometry(rect);
        int geometries = OS.GeometryGroup_Children(this.handle);
        if (OS.GeometryCollection_Count(geometries) != 0) {
            int geometry2 = OS.GeometryGroup_Children(this.handle, 0);
            int geometry3 = OS.gcnew_CombinedGeometry(3, geometry2, geometry1);
            OS.GeometryCollection_Remove(geometries, geometry2);
            OS.GeometryCollection_Add(geometries, geometry3);
            OS.GCHandle_Free(geometry2);
            OS.GCHandle_Free(geometry3);
        }
        OS.GCHandle_Free(rect);
        OS.GCHandle_Free(geometry1);
        OS.GCHandle_Free(geometries);
    }

    public void subtract(Region region) {
        int geometries;
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        if (OS.GeometryCollection_Count(geometries = OS.GeometryGroup_Children(this.handle)) != 0) {
            int geometry2 = OS.GeometryGroup_Children(this.handle, 0);
            int geometry3 = OS.gcnew_CombinedGeometry(3, geometry2, region.handle);
            OS.GeometryCollection_Remove(geometries, geometry2);
            OS.GeometryCollection_Add(geometries, geometry3);
            OS.GCHandle_Free(geometry2);
            OS.GCHandle_Free(geometry3);
        }
        OS.GCHandle_Free(geometries);
    }

    public void translate(int x, int y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int transform1 = OS.Geometry_Transform(this.handle);
        int transform2 = OS.gcnew_TranslateTransform(x, y);
        int transform = OS.gcnew_TransformGroup();
        int transforms = OS.TransformGroup_Children(transform);
        OS.TransformCollection_Add(transforms, transform1);
        OS.TransformCollection_Add(transforms, transform2);
        OS.Geometry_Transform(this.handle, transform);
        OS.GCHandle_Free(transform1);
        OS.GCHandle_Free(transform2);
        OS.GCHandle_Free(transform);
        OS.GCHandle_Free(transforms);
    }

    public void translate(Point pt) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pt == null) {
            SWT.error(4);
        }
        this.translate(pt.x, pt.y);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Region {*DISPOSED*}";
        }
        return "Region {" + this.handle + "}";
    }

    public static Region wpf_new(Device device, int handle) {
        return new Region(device, handle);
    }
}

