/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.wpf.OS;

public final class GC
extends Resource {
    public int handle;
    Drawable drawable;
    GCData data;
    static final int FOREGROUND = 1;
    static final int BACKGROUND = 2;
    static final int FONT = 4;
    static final int LINE_STYLE = 8;
    static final int LINE_WIDTH = 16;
    static final int LINE_CAP = 32;
    static final int LINE_JOIN = 64;
    static final int LINE_MITERLIMIT = 128;
    static final int ALPHA = 256;
    static final int CLIPPING = 512;
    static final int TRANSFORM = 1024;
    static final int DRAW = 1913;
    static final int FILL = 1794;
    static final int IMAGE = 1792;
    static final double[] LINE_DOT_ZERO = new double[]{3.0, 3.0};
    static final double[] LINE_DASH_ZERO = new double[]{18.0, 6.0};
    static final double[] LINE_DASHDOT_ZERO = new double[]{9.0, 6.0, 3.0, 6.0};
    static final double[] LINE_DASHDOTDOT_ZERO = new double[]{9.0, 3.0, 3.0, 3.0, 3.0, 3.0};

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int style) {
        if (drawable == null) {
            SWT.error(4);
        }
        GCData data = new GCData();
        data.style = GC.checkStyle(style);
        int hDC = drawable.internal_new_GC(data);
        Device device = data.device;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = data.device = device;
        this.init(drawable, data, hDC);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    static int checkStyle(int style) {
        if ((style & 0x2000000) != 0) {
            style &= 0xFBFFFFFF;
        }
        return style & 0x6000000;
    }

    void checkGC(int mask) {
        int state = this.data.state;
        if ((state & mask) == mask) {
            return;
        }
        state = (state ^ mask) & mask;
        this.data.state |= mask;
        if ((state & 0xF9) != 0) {
            float width;
            int brush;
            int pen = this.data.pen;
            if (pen != 0) {
                OS.GCHandle_Free(pen);
            }
            pen = this.data.pen = OS.gcnew_Pen();
            Pattern pattern = this.data.foregroundPattern;
            if (pattern != null) {
                brush = pattern.handle;
            } else {
                int foreground = this.data.foreground;
                brush = OS.gcnew_SolidColorBrush(foreground);
                if (brush == 0) {
                    SWT.error(2);
                }
            }
            OS.Pen_Brush(pen, brush);
            if (pattern == null) {
                OS.GCHandle_Free(brush);
            }
            OS.Pen_Thickness(pen, (width = this.data.lineWidth) == 0.0f ? 1.0f : width);
            double[] dashes = null;
            int dashStyle = 0;
            switch (this.data.lineStyle) {
                case 1: {
                    dashStyle = OS.DashStyles_Solid();
                    break;
                }
                case 3: {
                    if (width == 0.0f) {
                        dashes = LINE_DOT_ZERO;
                        break;
                    }
                    dashStyle = OS.DashStyles_Dot();
                    break;
                }
                case 2: {
                    if (width == 0.0f) {
                        dashes = LINE_DASH_ZERO;
                        break;
                    }
                    dashStyle = OS.DashStyles_Dash();
                    break;
                }
                case 4: {
                    if (width == 0.0f) {
                        dashes = LINE_DASHDOT_ZERO;
                        break;
                    }
                    dashStyle = OS.DashStyles_DashDot();
                    break;
                }
                case 5: {
                    if (width == 0.0f) {
                        dashes = LINE_DASHDOTDOT_ZERO;
                        break;
                    }
                    dashStyle = OS.DashStyles_DashDotDot();
                    break;
                }
                case 6: {
                    if (this.data.lineDashes != null) {
                        dashes = new double[this.data.lineDashes.length * 2];
                        int i = 0;
                        while (i < this.data.lineDashes.length) {
                            double dash;
                            dashes[i] = dash = (double)this.data.lineDashes[i] / (double)Math.max(1.0f, width);
                            dashes[i + this.data.lineDashes.length] = dash;
                            ++i;
                        }
                        break;
                    }
                    dashStyle = OS.DashStyles_Solid();
                }
            }
            if (dashes != null) {
                int list = OS.gcnew_DoubleCollection(dashes.length);
                int i = 0;
                while (i < dashes.length) {
                    OS.DoubleCollection_Add(list, dashes[i]);
                    ++i;
                }
                dashStyle = OS.gcnew_DashStyle(list, this.data.lineDashesOffset);
                OS.GCHandle_Free(list);
            }
            OS.Pen_DashStyle(pen, dashStyle);
            OS.GCHandle_Free(dashStyle);
            int joinStyle = 0;
            switch (this.data.lineJoin) {
                case 1: {
                    joinStyle = 0;
                    break;
                }
                case 3: {
                    joinStyle = 1;
                    break;
                }
                case 2: {
                    joinStyle = 2;
                }
            }
            OS.Pen_LineJoin(pen, joinStyle);
            int capStyle = 0;
            switch (this.data.lineCap) {
                case 1: {
                    capStyle = 0;
                    break;
                }
                case 2: {
                    capStyle = 1;
                    break;
                }
                case 3: {
                    capStyle = 2;
                }
            }
            OS.Pen_DashCap(pen, capStyle);
            OS.Pen_EndLineCap(pen, capStyle);
            OS.Pen_StartLineCap(pen, capStyle);
            OS.Pen_MiterLimit(pen, this.data.lineMiterLimit);
        }
        if ((state & 2) != 0) {
            if (this.data.brush != 0) {
                OS.GCHandle_Free(this.data.brush);
            }
            this.data.brush = 0;
            Pattern pattern = this.data.backgroundPattern;
            if (pattern != null) {
                this.data.currentBrush = pattern.handle;
            } else {
                int background = this.data.background;
                int brush = OS.gcnew_SolidColorBrush(background);
                if (brush == 0) {
                    SWT.error(2);
                }
                this.data.currentBrush = this.data.brush = brush;
            }
        }
        if ((state & 0x700) != 0) {
            int i = 0;
            while (i < this.data.pushCount) {
                OS.DrawingContext_Pop(this.handle);
                ++i;
            }
            this.data.pushCount = 0;
            if (this.data.alpha != 255) {
                OS.DrawingContext_PushOpacity(this.handle, (double)(this.data.alpha & 0xFF) / 255.0);
                ++this.data.pushCount;
            }
            if (this.data.clip != 0) {
                OS.DrawingContext_PushClip(this.handle, this.data.clip);
                ++this.data.pushCount;
            }
            if (this.data.transform != 0) {
                OS.DrawingContext_PushTransform(this.handle, this.data.transform);
                ++this.data.pushCount;
            }
        }
    }

    public void copyArea(Image image, int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
    }

    public void copyArea(int srcX, int srcY, int width, int height, int destX, int destY) {
        this.copyArea(srcX, srcY, width, height, destX, destY, true);
    }

    public void copyArea(int srcX, int srcY, int width, int height, int destX, int destY, boolean paint) {
        if (this.handle == 0) {
            SWT.error(44);
        }
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        if (this.data.device.isDisposed()) {
            return;
        }
        int brush = this.data.brush;
        if (brush != 0) {
            OS.GCHandle_Free(brush);
        }
        this.data.brush = 0;
        int pen = this.data.pen;
        if (pen != 0) {
            OS.GCHandle_Free(pen);
        }
        this.data.pen = 0;
        int clip = this.data.clip;
        if (clip != 0) {
            OS.GCHandle_Free(clip);
        }
        this.data.clip = 0;
        int transform = this.data.transform;
        if (transform != 0) {
            OS.GCHandle_Free(transform);
        }
        this.data.transform = 0;
        Image image = this.data.image;
        if (image != null) {
            image.memGC = null;
        }
        Device device = this.data.device;
        if (this.drawable != null) {
            this.drawable.internal_dispose_GC(this.handle, this.data);
        }
        this.drawable = null;
        this.handle = 0;
        this.data.image = null;
        if (device.tracking) {
            device.dispose_Object(this);
        }
        this.data.device = null;
        this.data = null;
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(1913);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        double offset = 0.0;
        if (this.data.lineWidth == 0.0f || this.data.lineWidth % 2.0f == 1.0f) {
            offset = 0.5;
        }
        if (arcAngle >= 360 || arcAngle <= -360) {
            int center = OS.gcnew_Point((double)x + offset + (double)((float)width / 2.0f), (double)y + offset + (double)((float)height / 2.0f));
            OS.DrawingContext_DrawEllipse(this.handle, 0, this.data.pen, center, (float)width / 2.0f, (float)height / 2.0f);
            OS.GCHandle_Free(center);
            return;
        }
        boolean isNegative = arcAngle < 0;
        boolean isLargeAngle = arcAngle > 180 || arcAngle < -180;
        arcAngle += startAngle;
        if (isNegative) {
            int tmp = startAngle;
            startAngle = arcAngle;
            arcAngle = tmp;
        }
        double x1 = Math.cos((double)startAngle * Math.PI / 180.0) * (double)width / 2.0 + (double)x + offset + (double)width / 2.0;
        double y1 = -1.0 * Math.sin((double)startAngle * Math.PI / 180.0) * (double)height / 2.0 + (double)y + offset + (double)height / 2.0;
        double x2 = Math.cos((double)arcAngle * Math.PI / 180.0) * (double)width / 2.0 + (double)x + offset + (double)width / 2.0;
        double y2 = -1.0 * Math.sin((double)arcAngle * Math.PI / 180.0) * (double)height / 2.0 + (double)y + offset + (double)height / 2.0;
        int startPoint = OS.gcnew_Point(x1, y1);
        int endPoint = OS.gcnew_Point(x2, y2);
        int size = OS.gcnew_Size((double)width / 2.0, (double)height / 2.0);
        int arc = OS.gcnew_ArcSegment(endPoint, size, 0.0, isLargeAngle, 0, true);
        int figure = OS.gcnew_PathFigure();
        OS.PathFigure_StartPoint(figure, startPoint);
        int segments = OS.PathFigure_Segments(figure);
        OS.PathSegmentCollection_Add(segments, arc);
        int path = OS.gcnew_PathGeometry();
        int figures = OS.PathGeometry_Figures(path);
        OS.PathFigureCollection_Add(figures, figure);
        OS.DrawingContext_DrawGeometry(this.handle, 0, this.data.pen, path);
        OS.GCHandle_Free(figures);
        OS.GCHandle_Free(path);
        OS.GCHandle_Free(segments);
        OS.GCHandle_Free(figure);
        OS.GCHandle_Free(arc);
        OS.GCHandle_Free(size);
        OS.GCHandle_Free(endPoint);
        OS.GCHandle_Free(startPoint);
    }

    public void drawFocus(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
    }

    public void drawImage(Image image, int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, 0, 0, -1, -1, x, y, -1, -1, true);
    }

    public void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (srcWidth == 0 || srcHeight == 0 || destWidth == 0 || destHeight == 0) {
            return;
        }
        if (srcX < 0 || srcY < 0 || srcWidth < 0 || srcHeight < 0 || destWidth < 0 || destHeight < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, false);
    }

    void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        int rect;
        this.checkGC(1792);
        int imageHandle = image.handle;
        int imgWidth = OS.BitmapSource_PixelWidth(imageHandle);
        int imgHeight = OS.BitmapSource_PixelHeight(imageHandle);
        if (simple) {
            srcWidth = destWidth = imgWidth;
            srcHeight = destHeight = imgHeight;
        } else {
            boolean bl = simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && destWidth == imgWidth && srcHeight == destHeight && destHeight == imgHeight;
            if (srcX + srcWidth > imgWidth || srcY + srcHeight > imgHeight) {
                SWT.error(5);
            }
        }
        int mode = 0;
        switch (this.data.interpolation) {
            case -1: {
                mode = 0;
                break;
            }
            case 0: {
                mode = 1;
                break;
            }
            case 1: {
                mode = 1;
                break;
            }
            case 2: {
                mode = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        if (srcX != 0 || srcY != 0 || srcWidth != imgWidth || srcHeight != imgHeight) {
            rect = OS.gcnew_Int32Rect(srcX, srcY, srcWidth, srcHeight);
            imageHandle = OS.gcnew_CroppedBitmap(imageHandle, rect);
            OS.RenderOptions_SetBitmapScalingMode(imageHandle, mode);
            OS.GCHandle_Free(rect);
        } else if (mode != OS.RenderOptions_GetBitmapScalingMode(imageHandle)) {
            imageHandle = OS.Freezable_Clone(imageHandle);
            OS.RenderOptions_SetBitmapScalingMode(imageHandle, mode);
        }
        rect = OS.gcnew_Rect(destX, destY, destWidth, destHeight);
        OS.DrawingContext_DrawImage(this.handle, imageHandle, rect);
        OS.GCHandle_Free(rect);
        if (image.handle != imageHandle) {
            OS.GCHandle_Free(imageHandle);
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(1913);
        double offset = 0.0;
        if (this.data.lineWidth == 0.0f || this.data.lineWidth % 2.0f == 1.0f) {
            offset = 0.5;
        }
        int point0 = OS.gcnew_Point((double)x1 + offset, (double)y1 + offset);
        int point1 = OS.gcnew_Point((double)x2 + offset, (double)y2 + offset);
        OS.DrawingContext_DrawLine(this.handle, this.data.pen, point0, point1);
        OS.GCHandle_Free(point0);
        OS.GCHandle_Free(point1);
    }

    public void drawOval(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(1913);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        double offset = 0.0;
        if (this.data.lineWidth == 0.0f || this.data.lineWidth % 2.0f == 1.0f) {
            offset = 0.5;
        }
        int center = OS.gcnew_Point((double)x + offset + (double)((float)width / 2.0f), (double)y + offset + (double)((float)height / 2.0f));
        OS.DrawingContext_DrawEllipse(this.handle, 0, this.data.pen, center, (float)width / 2.0f, (float)height / 2.0f);
        OS.GCHandle_Free(center);
    }

    public void drawPath(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0) {
            SWT.error(5);
        }
        this.checkGC(1913);
        OS.PathGeometry_FillRule(path.handle, this.data.fillRule == 1 ? 0 : 1);
        OS.DrawingContext_DrawGeometry(this.handle, 0, this.data.pen, path.handle);
    }

    public void drawPoint(int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(1913);
        int rect = OS.gcnew_Rect(x, y, 1.0, 1.0);
        int brush = OS.Pen_Brush(this.data.pen);
        OS.DrawingContext_DrawRectangle(this.handle, brush, 0, rect);
        OS.GCHandle_Free(brush);
        OS.GCHandle_Free(rect);
    }

    public void drawPolygon(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        this.checkGC(1913);
        this.drawPolyLineSegment(pointArray, true, true);
    }

    void drawPolyLineSegment(int[] pointArray, boolean closed, boolean stroked) {
        if (pointArray.length < 4) {
            return;
        }
        int list = OS.gcnew_PointCollection(pointArray.length / 2);
        double offset = 0.0;
        if (stroked && (this.data.lineWidth == 0.0f || this.data.lineWidth % 2.0f == 1.0f)) {
            offset = 0.5;
        }
        int i = 2;
        while (i < pointArray.length) {
            int point = OS.gcnew_Point((double)pointArray[i] + offset, (double)pointArray[i + 1] + offset);
            OS.PointCollection_Add(list, point);
            OS.GCHandle_Free(point);
            i += 2;
        }
        int poly = OS.gcnew_PolyLineSegment(list, stroked);
        OS.GCHandle_Free(list);
        int figure = OS.gcnew_PathFigure();
        int startPoint = OS.gcnew_Point((double)pointArray[0] + offset, (double)pointArray[1] + offset);
        OS.PathFigure_StartPoint(figure, startPoint);
        OS.PathFigure_IsClosed(figure, closed);
        int segments = OS.PathFigure_Segments(figure);
        OS.PathSegmentCollection_Add(segments, poly);
        int path = OS.gcnew_PathGeometry();
        if (!stroked) {
            OS.PathGeometry_FillRule(path, this.data.fillRule == 1 ? 0 : 1);
        }
        int figures = OS.PathGeometry_Figures(path);
        OS.PathFigureCollection_Add(figures, figure);
        OS.DrawingContext_DrawGeometry(this.handle, stroked ? 0 : this.data.currentBrush, stroked ? this.data.pen : 0, path);
        OS.GCHandle_Free(figures);
        OS.GCHandle_Free(path);
        OS.GCHandle_Free(segments);
        OS.GCHandle_Free(figure);
        OS.GCHandle_Free(startPoint);
        OS.GCHandle_Free(poly);
    }

    public void drawPolyline(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        this.checkGC(1913);
        this.drawPolyLineSegment(pointArray, false, true);
    }

    public void drawRectangle(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(1913);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        double offset = 0.0;
        if (this.data.lineWidth == 0.0f || this.data.lineWidth % 2.0f == 1.0f) {
            offset = 0.5;
        }
        int rect = OS.gcnew_Rect((double)x + offset, (double)y + offset, width, height);
        OS.DrawingContext_DrawRectangle(this.handle, 0, this.data.pen, rect);
        OS.GCHandle_Free(rect);
    }

    public void drawRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        this.drawRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (arcWidth < 0 || arcHeight < 0) {
            SWT.error(5);
        }
        this.checkGC(1913);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (arcWidth < 0) {
            arcWidth = -arcWidth;
        }
        if (arcHeight < 0) {
            arcHeight = -arcHeight;
        }
        double offset = 0.0;
        if (this.data.lineWidth == 0.0f || this.data.lineWidth % 2.0f == 1.0f) {
            offset = 0.5;
        }
        int rect = OS.gcnew_Rect((double)x + offset, (double)y + offset, width, height);
        OS.DrawingContext_DrawRoundedRectangle(this.handle, 0, this.data.pen, rect, (float)arcWidth / 2.0f, (float)arcHeight / 2.0f);
        OS.GCHandle_Free(rect);
    }

    public void drawString(String string, int x, int y) {
        this.drawString(string, x, y, false);
    }

    public void drawString(String string, int x, int y, boolean isTransparent) {
        this.drawText(string, x, y, isTransparent ? 1 : 0);
    }

    public void drawText(String string, int x, int y) {
        this.drawText(string, x, y, 6);
    }

    public void drawText(String string, int x, int y, boolean isTransparent) {
        int flags = 6;
        if (isTransparent) {
            flags |= 1;
        }
        this.drawText(string, x, y, flags);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void drawText(String string, int x, int y, int flags) {
        int mnemonic;
        char[] buffer;
        block14: {
            int length;
            if (this.handle == 0) {
                SWT.error(44);
            }
            if (string == null) {
                SWT.error(4);
            }
            if ((length = string.length()) == 0) {
                return;
            }
            this.checkGC(0x705 | ((flags & 1) != 0 ? 0 : 2));
            buffer = new char[length + 1];
            string.getChars(0, length, buffer, 0);
            int mask = 14;
            mnemonic = -1;
            if ((flags & mask) == mask) break block14;
            int i = 0;
            int j = 0;
            while (i < buffer.length) {
                block15: {
                    char c = buffer[i];
                    switch (c) {
                        case '&': {
                            if ((flags & 8) == 0) break;
                            if (i + 1 >= length) break block15;
                            if (buffer[i + 1] == '&') {
                                ++i;
                                break block15;
                            } else if (mnemonic == -1) {
                                mnemonic = j;
                            }
                            break block15;
                        }
                        case '\n': 
                        case '\r': {
                            if ((flags & 2) != 0) break;
                            break block15;
                        }
                        case '\t': {
                            if ((flags & 4) == 0) break block15;
                        }
                    }
                    buffer[j++] = c;
                }
                ++i;
            }
        }
        int str = OS.gcnew_String(buffer);
        int culture = OS.CultureInfo_CurrentUICulture();
        Font font = this.data.font;
        int direction = (this.data.style & 0x4000000) != 0 ? 1 : 0;
        int brush = OS.Pen_Brush(this.data.pen);
        int text = OS.gcnew_FormattedText(str, culture, direction, font.handle, font.size, brush);
        int point = OS.gcnew_Point(x, y);
        if (mnemonic != -1) {
            int underline = OS.TextDecorations_Underline();
            int decorations = OS.gcnew_TextDecorationCollection(1);
            OS.TextDecorationCollection_Add(decorations, underline);
            OS.FormattedText_SetTextDecorations(text, decorations, mnemonic, 1);
            OS.GCHandle_Free(decorations);
            OS.GCHandle_Free(underline);
        }
        if ((flags & 1) == 0) {
            double width = OS.FormattedText_WidthIncludingTrailingWhitespace(text);
            double height = OS.FormattedText_Height(text);
            int rect = OS.gcnew_Rect(x, y, width, height);
            OS.DrawingContext_DrawRectangle(this.handle, this.data.currentBrush, 0, rect);
            OS.GCHandle_Free(rect);
        }
        OS.DrawingContext_DrawText(this.handle, text, point);
        OS.GCHandle_Free(point);
        OS.GCHandle_Free(culture);
        OS.GCHandle_Free(str);
        OS.GCHandle_Free(brush);
        OS.GCHandle_Free(text);
    }

    public boolean equals(Object object) {
        return object == this || object instanceof GC && this.handle == ((GC)object).handle;
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(1794);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        if (arcAngle >= 360 || arcAngle <= -360) {
            int center = OS.gcnew_Point((float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f);
            OS.DrawingContext_DrawEllipse(this.handle, this.data.currentBrush, 0, center, (float)width / 2.0f, (float)height / 2.0f);
            OS.GCHandle_Free(center);
            return;
        }
        boolean isNegative = arcAngle < 0;
        boolean isLargeAngle = arcAngle > 180 || arcAngle < -180;
        arcAngle += startAngle;
        if (isNegative) {
            int tmp = startAngle;
            startAngle = arcAngle;
            arcAngle = tmp;
        }
        double x1 = Math.cos((double)startAngle * Math.PI / 180.0) * (double)width / 2.0 + (double)x + (double)width / 2.0;
        double y1 = -1.0 * Math.sin((double)startAngle * Math.PI / 180.0) * (double)height / 2.0 + (double)y + (double)height / 2.0;
        double x2 = Math.cos((double)arcAngle * Math.PI / 180.0) * (double)width / 2.0 + (double)x + (double)width / 2.0;
        double y2 = -1.0 * Math.sin((double)arcAngle * Math.PI / 180.0) * (double)height / 2.0 + (double)y + (double)height / 2.0;
        int startPoint = OS.gcnew_Point(x1, y1);
        int endPoint = OS.gcnew_Point(x2, y2);
        int center = OS.gcnew_Point((double)x + (double)width / 2.0, (double)y + (double)height / 2.0);
        int size = OS.gcnew_Size((double)width / 2.0, (double)height / 2.0);
        int arc = OS.gcnew_ArcSegment(endPoint, size, 0.0, isLargeAngle, 0, false);
        int line = OS.gcnew_LineSegment(center, false);
        int figure = OS.gcnew_PathFigure();
        OS.PathFigure_StartPoint(figure, startPoint);
        int segments = OS.PathFigure_Segments(figure);
        OS.PathSegmentCollection_Add(segments, arc);
        OS.PathSegmentCollection_Add(segments, line);
        int path = OS.gcnew_PathGeometry();
        int figures = OS.PathGeometry_Figures(path);
        OS.PathFigureCollection_Add(figures, figure);
        OS.DrawingContext_DrawGeometry(this.handle, this.data.currentBrush, 0, path);
        OS.GCHandle_Free(figures);
        OS.GCHandle_Free(path);
        OS.GCHandle_Free(segments);
        OS.GCHandle_Free(figure);
        OS.GCHandle_Free(arc);
        OS.GCHandle_Free(line);
        OS.GCHandle_Free(size);
        OS.GCHandle_Free(endPoint);
        OS.GCHandle_Free(startPoint);
    }

    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width == 0 || height == 0) {
            return;
        }
        this.checkGC(1794);
        int fromColor = this.data.foreground;
        int toColor = this.data.background;
        boolean swapColors = false;
        if (width < 0) {
            x += width;
            width = -width;
            if (!vertical) {
                swapColors = true;
            }
        }
        if (height < 0) {
            y += height;
            height = -height;
            if (vertical) {
                swapColors = true;
            }
        }
        if (swapColors) {
            int temp = fromColor;
            fromColor = toColor;
            toColor = temp;
        }
        int brush = OS.gcnew_LinearGradientBrush(fromColor, toColor, vertical ? 90 : 0);
        int rect = OS.gcnew_Rect(x, y, width, height);
        OS.DrawingContext_DrawRectangle(this.handle, brush, 0, rect);
        OS.GCHandle_Free(rect);
        OS.GCHandle_Free(brush);
    }

    public void fillOval(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(1794);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        int center = OS.gcnew_Point((float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f);
        OS.DrawingContext_DrawEllipse(this.handle, this.data.currentBrush, 0, center, (float)width / 2.0f, (float)height / 2.0f);
        OS.GCHandle_Free(center);
    }

    public void fillPath(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0) {
            SWT.error(5);
        }
        this.checkGC(1794);
        OS.PathGeometry_FillRule(path.handle, this.data.fillRule == 1 ? 0 : 1);
        OS.DrawingContext_DrawGeometry(this.handle, this.data.currentBrush, 0, path.handle);
    }

    public void fillPolygon(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        this.checkGC(1794);
        this.drawPolyLineSegment(pointArray, true, false);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(1794);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        int rect = OS.gcnew_Rect(x, y, width, height);
        OS.DrawingContext_DrawRectangle(this.handle, this.data.currentBrush, 0, rect);
        OS.GCHandle_Free(rect);
    }

    public void fillRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        this.fillRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(1794);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (arcWidth < 0) {
            arcWidth = -arcWidth;
        }
        if (arcHeight < 0) {
            arcHeight = -arcHeight;
        }
        int rect = OS.gcnew_Rect(x, y, width, height);
        OS.DrawingContext_DrawRoundedRectangle(this.handle, this.data.currentBrush, 0, rect, (float)arcWidth / 2.0f, (float)arcHeight / 2.0f);
        OS.GCHandle_Free(rect);
    }

    public int getAdvanceWidth(char ch) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.stringExtent((String)new String((char[])new char[]{ch})).x;
    }

    public boolean getAdvanced() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return true;
    }

    public int getAlpha() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.alpha;
    }

    public int getAntialias() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.antialias;
    }

    public Color getBackground() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return Color.wpf_new(this.data.device, this.data.background);
    }

    public Pattern getBackgroundPattern() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.backgroundPattern;
    }

    public int getCharWidth(char ch) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.stringExtent((String)new String((char[])new char[]{ch})).x;
    }

    public Rectangle getClipping() {
        int rect;
        int drawingVisualType;
        if (this.handle == 0) {
            SWT.error(44);
        }
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        int visualType = OS.Object_GetType(this.data.visual);
        if (OS.Object_Equals(visualType, drawingVisualType = OS.DrawingVisual_typeid())) {
            int clip = OS.ContainerVisual_Clip(this.data.visual);
            rect = OS.Geometry_Bounds(clip);
            width = (int)OS.Rect_Width(rect);
            height = (int)OS.Rect_Height(rect);
            OS.GCHandle_Free(rect);
            OS.GCHandle_Free(clip);
        } else {
            width = (int)OS.FrameworkElement_ActualWidth(this.data.visual);
            height = (int)OS.FrameworkElement_ActualHeight(this.data.visual);
        }
        OS.GCHandle_Free(drawingVisualType);
        OS.GCHandle_Free(visualType);
        if (this.data.clip != 0) {
            int bounds = OS.gcnew_Rect(x, y, width, height);
            rect = OS.Geometry_Bounds(this.data.clip);
            OS.Rect_Intersect(bounds, rect);
            x = (int)OS.Rect_X(bounds);
            y = (int)OS.Rect_Y(bounds);
            width = (int)OS.Rect_Width(bounds);
            height = (int)OS.Rect_Height(bounds);
            OS.GCHandle_Free(rect);
            OS.GCHandle_Free(bounds);
        }
        return new Rectangle(x, y, width, height);
    }

    public void getClipping(Region region) {
        int bounds;
        int drawingVisualType;
        int visualType;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        if (OS.Object_Equals(visualType = OS.Object_GetType(this.data.visual), drawingVisualType = OS.DrawingVisual_typeid())) {
            bounds = OS.ContainerVisual_Clip(this.data.visual);
        } else {
            double width = OS.FrameworkElement_ActualWidth(this.data.visual);
            double height = OS.FrameworkElement_ActualHeight(this.data.visual);
            int rect = OS.gcnew_Rect(0.0, 0.0, width, height);
            bounds = OS.gcnew_RectangleGeometry(rect);
            OS.GCHandle_Free(rect);
        }
        OS.GCHandle_Free(drawingVisualType);
        OS.GCHandle_Free(visualType);
        int geometries = OS.GeometryGroup_Children(region.handle);
        OS.GeometryCollection_Clear(geometries);
        if (this.data.clip != 0) {
            int clip = OS.Geometry_GetFlattenedPathGeometry(this.data.clip);
            int newGeometry = OS.gcnew_CombinedGeometry(1, bounds, clip);
            OS.GeometryCollection_Add(geometries, newGeometry);
            OS.GCHandle_Free(clip);
            OS.GCHandle_Free(newGeometry);
        } else {
            OS.GeometryCollection_Add(geometries, bounds);
        }
        OS.GCHandle_Free(bounds);
        OS.GCHandle_Free(geometries);
    }

    public int getFillRule() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.fillRule;
    }

    public Font getFont() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.font;
    }

    public FontMetrics getFontMetrics() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(4);
        String string = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        int length = string.length();
        char[] buffer = new char[length + 1];
        string.getChars(0, length, buffer, 0);
        int str = OS.gcnew_String(buffer);
        int culture = OS.CultureInfo_CurrentUICulture();
        Font font = this.data.font;
        int direction = (this.data.style & 0x4000000) != 0 ? 1 : 0;
        int brush = OS.Brushes_White();
        int text = OS.gcnew_FormattedText(str, culture, direction, font.handle, font.size, brush);
        double width = OS.FormattedText_WidthIncludingTrailingWhitespace(text);
        double height = OS.FormattedText_Height(text);
        double baseline = OS.FormattedText_Baseline(text);
        OS.GCHandle_Free(text);
        OS.GCHandle_Free(brush);
        OS.GCHandle_Free(culture);
        OS.GCHandle_Free(str);
        return FontMetrics.wpf_new((int)baseline, (int)(height - baseline), (int)width / string.length(), 0, (int)height);
    }

    public Color getForeground() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return Color.wpf_new(this.data.device, this.data.foreground);
    }

    public Pattern getForegroundPattern() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.foregroundPattern;
    }

    public GCData getGCData() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data;
    }

    public int getInterpolation() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.interpolation;
    }

    public LineAttributes getLineAttributes() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        float[] dashes = null;
        if (this.data.lineDashes != null) {
            dashes = new float[this.data.lineDashes.length];
            System.arraycopy(this.data.lineDashes, 0, dashes, 0, dashes.length);
        }
        return new LineAttributes(this.data.lineWidth, this.data.lineCap, this.data.lineJoin, this.data.lineStyle, dashes, this.data.lineDashesOffset, this.data.lineMiterLimit);
    }

    public int getLineCap() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineCap;
    }

    public int[] getLineDash() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineDashes == null) {
            return null;
        }
        int[] lineDashes = new int[this.data.lineDashes.length];
        System.arraycopy(this.data.lineDashes, 0, lineDashes, 0, lineDashes.length);
        return lineDashes;
    }

    public int getLineJoin() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineJoin;
    }

    public int getLineStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineStyle;
    }

    public int getLineWidth() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return (int)this.data.lineWidth;
    }

    public int getStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.style;
    }

    public int getTextAntialias() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.textAntialias;
    }

    public void getTransform(Transform transform) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (transform == null) {
            SWT.error(4);
        }
        if (transform.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.transform != 0) {
            OS.MatrixTransform_Matrix(transform.handle, this.data.transform);
        } else {
            transform.setElements(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
    }

    public boolean getXORMode() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.xorMode;
    }

    void init(Drawable drawable, GCData data, int hDC) {
        Image image;
        Font font;
        int background;
        int foreground = data.foreground;
        if (foreground != -1) {
            data.state &= 0xFFFFFFFE;
        }
        if ((background = data.background) != 0) {
            data.state &= 0xFFFFFFFD;
        }
        if ((font = data.font) != null) {
            data.state &= 0xFFFFFFFB;
        }
        if ((image = data.image) != null) {
            image.memGC = this;
        }
        this.drawable = drawable;
        this.data = data;
        this.handle = hDC;
    }

    public int hashCode() {
        return this.handle;
    }

    public boolean isClipped() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.clip != 0;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public void setAdvanced(boolean advanced) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (!advanced) {
            this.setAlpha(255);
            this.setAntialias(-1);
            this.setBackgroundPattern(null);
            this.setClipping((Rectangle)null);
            this.setForegroundPattern(null);
            this.setInterpolation(-1);
            this.setTextAntialias(-1);
            this.setTransform(null);
        }
    }

    public void setAntialias(int antialias) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        switch (antialias) {
            case -1: 
            case 0: 
            case 1: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.antialias = antialias;
    }

    public void setAlpha(int alpha) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.data.alpha = alpha & 0xFF;
        this.data.state &= 0xFFFFFEFF;
    }

    public void setBackground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.backgroundPattern == null && this.data.background == color.handle) {
            return;
        }
        this.data.backgroundPattern = null;
        this.data.background = color.handle;
        this.data.state &= 0xFFFFFFFD;
    }

    public void setBackgroundPattern(Pattern pattern) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.backgroundPattern == pattern) {
            return;
        }
        this.data.backgroundPattern = pattern;
        this.data.state &= 0xFFFFFFFD;
    }

    public void setClipping(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        int rect = OS.gcnew_Rect(x, y, width, height);
        int clip = OS.gcnew_RectangleGeometry(rect);
        OS.GCHandle_Free(rect);
        if (this.data.clip != 0) {
            OS.GCHandle_Free(this.data.clip);
        }
        this.data.clip = clip;
        this.data.state &= 0xFFFFFDFF;
    }

    public void setClipping(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path != null && path.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.clip != 0) {
            OS.GCHandle_Free(this.data.clip);
        }
        this.data.clip = path != null ? OS.Geometry_Clone(path.handle) : 0;
        this.data.state &= 0xFFFFFDFF;
    }

    public void setClipping(Rectangle rect) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (rect == null) {
            if (this.data.clip != 0) {
                OS.GCHandle_Free(this.data.clip);
            }
            this.data.clip = 0;
            this.data.state &= 0xFFFFFDFF;
        } else {
            this.setClipping(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public void setClipping(Region region) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region != null && region.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.clip != 0) {
            OS.GCHandle_Free(this.data.clip);
        }
        this.data.clip = region != null ? OS.Geometry_Clone(region.handle) : 0;
        this.data.state &= 0xFFFFFDFF;
    }

    public void setFillRule(int rule) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        switch (rule) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.fillRule = rule;
    }

    public void setFont(Font font) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        this.data.font = font != null ? font : this.data.device.systemFont;
        this.data.state &= 0xFFFFFFFB;
    }

    public void setForeground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.foregroundPattern == null && color.handle == this.data.foreground) {
            return;
        }
        this.data.foregroundPattern = null;
        this.data.foreground = color.handle;
        this.data.state &= 0xFFFFFFFE;
    }

    public void setForegroundPattern(Pattern pattern) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.foregroundPattern == pattern) {
            return;
        }
        this.data.foregroundPattern = pattern;
        this.data.state &= 0xFFFFFFFE;
    }

    public void setInterpolation(int interpolation) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        switch (interpolation) {
            case -1: {
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.interpolation = interpolation;
    }

    public void setLineAttributes(LineAttributes attributes) {
        float miterLimit;
        int cap;
        int join;
        int lineStyle;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (attributes == null) {
            SWT.error(4);
        }
        int mask = 0;
        float lineWidth = attributes.width;
        if (lineWidth != this.data.lineWidth) {
            mask |= 0x10;
        }
        if ((lineStyle = attributes.style) != this.data.lineStyle) {
            mask |= 8;
            switch (lineStyle) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    if (attributes.dash != null) break;
                    lineStyle = 1;
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((join = attributes.join) != this.data.lineJoin) {
            mask |= 0x40;
            switch (join) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((cap = attributes.join) != this.data.lineCap) {
            mask |= 0x20;
            switch (cap) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        float[] dashes = attributes.dash;
        float[] lineDashes = this.data.lineDashes;
        if (dashes != null && dashes.length > 0) {
            boolean changed = lineDashes == null || lineDashes.length != dashes.length;
            int i = 0;
            while (i < dashes.length) {
                float dash = dashes[i];
                if (dash <= 0.0f) {
                    SWT.error(5);
                }
                if (!changed && lineDashes[i] != dash) {
                    changed = true;
                }
                ++i;
            }
            if (changed) {
                float[] newDashes = new float[dashes.length];
                System.arraycopy(dashes, 0, newDashes, 0, dashes.length);
                dashes = newDashes;
                mask |= 8;
            } else {
                dashes = lineDashes;
            }
        } else if (lineDashes != null && lineDashes.length > 0) {
            mask |= 8;
        } else {
            dashes = lineDashes;
        }
        float dashOffset = attributes.dashOffset;
        if (dashOffset != this.data.lineDashesOffset) {
            mask |= 8;
        }
        if ((miterLimit = attributes.miterLimit) != this.data.lineMiterLimit) {
            mask |= 0x80;
        }
        if (mask == 0) {
            return;
        }
        this.data.lineWidth = lineWidth;
        this.data.lineStyle = lineStyle;
        this.data.lineCap = cap;
        this.data.lineJoin = join;
        this.data.lineDashes = dashes;
        this.data.lineDashesOffset = dashOffset;
        this.data.lineMiterLimit = miterLimit;
        this.data.state &= ~mask;
    }

    public void setLineCap(int cap) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineCap == cap) {
            return;
        }
        switch (cap) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineCap = cap;
        this.data.state &= 0xFFFFFFDF;
    }

    public void setLineDash(int[] dashes) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        float[] lineDashes = this.data.lineDashes;
        if (dashes != null && dashes.length > 0) {
            boolean changed = this.data.lineStyle != 6 || lineDashes == null || lineDashes.length != dashes.length;
            int i = 0;
            while (i < dashes.length) {
                int dash = dashes[i];
                if (dash <= 0) {
                    SWT.error(5);
                }
                if (!changed && lineDashes[i] != (float)dash) {
                    changed = true;
                }
                ++i;
            }
            if (!changed) {
                return;
            }
            this.data.lineDashes = new float[dashes.length];
            i = 0;
            while (i < dashes.length) {
                this.data.lineDashes[i] = dashes[i];
                ++i;
            }
            this.data.lineStyle = 6;
        } else {
            if (this.data.lineStyle == 1 && (lineDashes == null || lineDashes.length == 0)) {
                return;
            }
            this.data.lineDashes = null;
            this.data.lineStyle = 1;
        }
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineJoin(int join) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineJoin == join) {
            return;
        }
        switch (join) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineJoin = join;
        this.data.state &= 0xFFFFFFBF;
    }

    public void setLineStyle(int lineStyle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineStyle == lineStyle) {
            return;
        }
        switch (lineStyle) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                if (this.data.lineDashes != null) break;
                lineStyle = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineStyle = lineStyle;
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineWidth(int lineWidth) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineWidth == (float)lineWidth) {
            return;
        }
        this.data.lineWidth = lineWidth;
        this.data.state &= 0xFFFFFFEF;
        switch (this.data.lineStyle) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.data.state &= 0xFFFFFFF7;
            }
        }
    }

    public void setXORMode(boolean xor) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.data.xorMode = xor;
    }

    public void setTextAntialias(int antialias) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        switch (antialias) {
            case -1: 
            case 0: 
            case 1: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.textAntialias = antialias;
    }

    public void setTransform(Transform transform) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (transform != null && transform.isDisposed()) {
            SWT.error(5);
        }
        this.data.transform = transform != null ? OS.gcnew_MatrixTransform(transform.handle) : 0;
        this.data.state &= 0xFFFFFBFF;
    }

    public Point stringExtent(String string) {
        return this.textExtent(string, 0);
    }

    public Point textExtent(String string) {
        return this.textExtent(string, 6);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Point textExtent(String string, int flags) {
        char[] buffer;
        block7: {
            if (this.handle == 0) {
                SWT.error(44);
            }
            if (string == null) {
                SWT.error(4);
            }
            this.checkGC(4);
            int length = string.length();
            buffer = new char[length + 1];
            string.getChars(0, length, buffer, 0);
            if ((flags & 6) == 6) break block7;
            int i = 0;
            int j = 0;
            while (i < buffer.length) {
                block8: {
                    char c = buffer[i];
                    switch (c) {
                        case '\n': 
                        case '\r': {
                            if ((flags & 2) != 0) break;
                            break block8;
                        }
                        case '\t': {
                            if ((flags & 4) == 0) break block8;
                        }
                    }
                    buffer[j++] = c;
                }
                ++i;
            }
        }
        int str = OS.gcnew_String(buffer);
        int culture = OS.CultureInfo_CurrentUICulture();
        Font font = this.data.font;
        int direction = (this.data.style & 0x4000000) != 0 ? 1 : 0;
        int brush = OS.Brushes_White();
        int text = OS.gcnew_FormattedText(str, culture, direction, font.handle, font.size, brush);
        double width = OS.FormattedText_WidthIncludingTrailingWhitespace(text);
        double height = OS.FormattedText_Height(text);
        OS.GCHandle_Free(text);
        OS.GCHandle_Free(brush);
        OS.GCHandle_Free(culture);
        OS.GCHandle_Free(str);
        return new Point((int)width, (int)height);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }

    public static GC wpf_new(Drawable drawable, GCData data) {
        GC gc = new GC();
        int hDC = drawable.internal_new_GC(data);
        gc.device = data.device;
        gc.init(drawable, data, hDC);
        return gc;
    }

    public static GC wpf_new(int hDC, GCData data) {
        GC gc = new GC();
        gc.device = data.device;
        gc.init(null, data, hDC);
        return gc;
    }
}

