/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.wpf.OS;

public final class FontData {
    public String fontFamily;
    public int style;
    public int weight;
    public int stretch;
    public int height;
    String lang;
    String country;
    String variant;

    public FontData() {
        this.fontFamily = "";
        this.style = OS.FontStyles_Normal;
        this.weight = OS.FontWeight_ToOpenTypeWeight(OS.FontWeights_Normal);
        this.stretch = OS.FontStretch_ToOpenTypeStretch(OS.FontStretches_Normal);
        this.height = 12;
    }

    public FontData(String string) {
        if (string == null) {
            SWT.error(4);
        }
        int start = 0;
        int end = string.indexOf(124);
        if (end == -1) {
            SWT.error(5);
        }
        String version1 = string.substring(start, end);
        try {
            if (Integer.parseInt(version1) != 1) {
                SWT.error(5);
            }
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(5);
        }
        if ((end = string.indexOf(124, start = end + 1)) == -1) {
            SWT.error(5);
        }
        String name = string.substring(start, end);
        start = end + 1;
        if ((end = string.indexOf(124, start)) == -1) {
            SWT.error(5);
        }
        int height = 0;
        try {
            height = Integer.parseInt(string.substring(start, end));
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(5);
        }
        start = end + 1;
        end = string.indexOf(124, start);
        if (end == -1) {
            SWT.error(5);
        }
        int style = 0;
        try {
            style = Integer.parseInt(string.substring(start, end));
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(5);
        }
        start = end + 1;
        end = string.indexOf(124, start);
        this.setName(name);
        this.setHeight(height);
        this.setStyle(style);
        if (end == -1) {
            return;
        }
        String platform = string.substring(start, end);
        start = end + 1;
        if ((end = string.indexOf(124, start)) == -1) {
            return;
        }
        String version2 = string.substring(start, end);
        this.stretch = OS.FontStretch_ToOpenTypeStretch(OS.FontStretches_Normal);
        if (platform.equals("WPF") && version2.equals("1")) {
            try {
                start = end + 1;
                end = string.indexOf(124, start);
                if (end == -1) {
                    return;
                }
                this.fontFamily = string.substring(start, end);
                start = end + 1;
                if ((end = string.indexOf(124, start)) == -1) {
                    return;
                }
                String styleStr = string.substring(start, end);
                int length = styleStr.length();
                char[] chars = new char[length + 1];
                styleStr.getChars(0, length, chars, 0);
                int str = OS.gcnew_String(chars);
                int converter = OS.TypeDescriptor_GetConverter(OS.FontStyles_Normal);
                this.style = OS.FontStyles_Normal;
                int fontStyle = OS.TypeConverter_ConvertFromString(converter, str);
                if (fontStyle != 0) {
                    if (OS.Object_Equals(OS.FontStyles_Italic, fontStyle)) {
                        this.style = OS.FontStyles_Italic;
                    }
                    if (OS.Object_Equals(OS.FontStyles_Oblique, fontStyle)) {
                        this.style = OS.FontStyles_Oblique;
                    }
                    OS.GCHandle_Free(fontStyle);
                }
                OS.GCHandle_Free(converter);
                OS.GCHandle_Free(str);
                start = end + 1;
                end = string.indexOf(124, start);
                if (end == -1) {
                    return;
                }
                this.weight = Integer.parseInt(string.substring(start, end));
                start = end + 1;
                if ((end = string.indexOf(124, start)) == -1) {
                    end = string.length();
                }
                this.stretch = Integer.parseInt(string.substring(start, end));
            }
            catch (NumberFormatException numberFormatException) {
                this.setName(name);
                this.setHeight(height);
                this.setStyle(style);
                return;
            }
        }
    }

    public FontData(String name, int height, int style) {
        if (name == null) {
            SWT.error(4);
        }
        this.setName(name);
        this.setHeight(height);
        this.setStyle(style);
        this.stretch = OS.FontStretch_ToOpenTypeStretch(OS.FontStretches_Normal);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FontData)) {
            return false;
        }
        FontData fd = (FontData)object;
        return this.style == fd.style && this.height == fd.height && this.weight == fd.weight && this.stretch == fd.stretch && this.getName().equals(fd.getName());
    }

    public int getHeight() {
        return this.height;
    }

    public String getLocale() {
        String result;
        int length;
        StringBuffer buffer = new StringBuffer();
        char sep = '_';
        if (this.lang != null) {
            buffer.append(this.lang);
            buffer.append(sep);
        }
        if (this.country != null) {
            buffer.append(this.country);
            buffer.append(sep);
        }
        if (this.variant != null) {
            buffer.append(this.variant);
        }
        if ((length = (result = buffer.toString()).length()) > 0 && result.charAt(length - 1) == sep) {
            result = result.substring(0, length - 1);
        }
        return result;
    }

    public String getName() {
        return this.fontFamily;
    }

    public int getStyle() {
        int style = 0;
        if (this.weight == OS.FontWeight_ToOpenTypeWeight(OS.FontWeights_Bold)) {
            style |= 1;
        }
        if (style == OS.FontStyles_Italic) {
            style |= 2;
        }
        return style;
    }

    public int hashCode() {
        return this.style ^ this.weight ^ this.stretch ^ this.getName().hashCode();
    }

    public void setHeight(int height) {
        if (height < 0) {
            SWT.error(5);
        }
        this.height = height;
    }

    public void setLocale(String locale) {
        this.variant = null;
        this.country = null;
        this.lang = null;
        if (locale != null) {
            int secondSep;
            int sep = 95;
            int length = locale.length();
            int firstSep = locale.indexOf(sep);
            if (firstSep == -1) {
                firstSep = secondSep = length;
            } else {
                secondSep = locale.indexOf(sep, firstSep + 1);
                if (secondSep == -1) {
                    secondSep = length;
                }
            }
            if (firstSep > 0) {
                this.lang = locale.substring(0, firstSep);
            }
            if (secondSep > firstSep + 1) {
                this.country = locale.substring(firstSep + 1, secondSep);
            }
            if (length > secondSep + 1) {
                this.variant = locale.substring(secondSep + 1);
            }
        }
    }

    public void setName(String name) {
        if (name == null) {
            SWT.error(4);
        }
        this.fontFamily = name;
    }

    public void setStyle(int style) {
        this.weight = (style & 1) == 1 ? OS.FontWeight_ToOpenTypeWeight(OS.FontWeights_Bold) : OS.FontWeight_ToOpenTypeWeight(OS.FontWeights_Normal);
        this.style = (style & 2) == 2 ? OS.FontStyles_Italic : OS.FontStyles_Normal;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("1|");
        buffer.append(this.getName());
        buffer.append("|");
        buffer.append(this.getHeight());
        buffer.append("|");
        buffer.append(this.getStyle());
        buffer.append("|");
        buffer.append("WPF|1|");
        buffer.append(this.fontFamily);
        buffer.append("|");
        int converter = OS.TypeDescriptor_GetConverter(OS.FontStyles_Normal);
        int str = OS.TypeConverter_ConvertToString(converter, this.style != 0 ? this.style : OS.FontStyles_Normal);
        int charArray = OS.String_ToCharArray(str);
        char[] chars = new char[OS.String_Length(str)];
        OS.memcpy(chars, charArray, chars.length * 2);
        OS.GCHandle_Free(charArray);
        OS.GCHandle_Free(str);
        OS.GCHandle_Free(converter);
        buffer.append(chars);
        buffer.append("|");
        buffer.append(this.weight);
        buffer.append("|");
        buffer.append(this.stretch);
        return buffer.toString();
    }

    public static FontData wpf_new(String fontFamily, int style, int weight, int stretch, int height) {
        FontData data = new FontData();
        data.fontFamily = fontFamily;
        data.style = style;
        data.weight = weight;
        data.stretch = stretch;
        data.height = height;
        return data;
    }
}

