/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.util.Tracing;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.services.EvaluationResultCacheComparator;
import org.eclipse.ui.internal.services.ExpressionAuthority;
import org.eclipse.ui.internal.services.IEvaluationResultCache;

final class HandlerAuthority
extends ExpressionAuthority {
    private static final int ACTIVATIONS_BY_SOURCE_SIZE = 256;
    private static final int ACTIVATIONS_TO_RECOMPUTE_SIZE = 1024;
    private static final boolean DEBUG = Policy.DEBUG_HANDLERS;
    private static final boolean DEBUG_PERFORMANCE = Policy.DEBUG_HANDLERS_PERFORMANCE;
    private static final boolean DEBUG_VERBOSE = Policy.DEBUG_HANDLERS && Policy.DEBUG_HANDLERS_VERBOSE;
    private static final String DEBUG_VERBOSE_COMMAND_ID = Policy.DEBUG_HANDLERS_VERBOSE_COMMAND_ID;
    private static final String TRACING_COMPONENT = "HANDLERS";
    private final Map[] activationsByExpressionBySourcePriority = new Map[33];
    private final ICommandService commandService;
    private final Map handlerActivationsByCommandId = new HashMap();
    private Set previousLogs = new HashSet();

    HandlerAuthority(ICommandService commandService) {
        if (commandService == null) {
            throw new NullPointerException("The handler authority needs a command service");
        }
        this.commandService = commandService;
    }

    final void activateHandler(IHandlerActivation activation) {
        TreeSet<IHandlerActivation> handlerActivations;
        String commandId = activation.getCommandId();
        MultiStatus conflicts = new MultiStatus("org.eclipse.ui.workbench", 0, "A handler conflict occurred.  This may disable some commands.", null);
        Object value = this.handlerActivationsByCommandId.get(commandId);
        if (value instanceof SortedSet) {
            handlerActivations = (TreeSet<IHandlerActivation>)value;
            if (!handlerActivations.contains(activation)) {
                handlerActivations.add(activation);
                this.updateCommand(commandId, this.resolveConflicts(commandId, handlerActivations, conflicts));
            }
        } else if (value instanceof IHandlerActivation) {
            if (value != activation) {
                handlerActivations = new TreeSet<IHandlerActivation>(new EvaluationResultCacheComparator());
                handlerActivations.add((IHandlerActivation)value);
                handlerActivations.add(activation);
                this.handlerActivationsByCommandId.put(commandId, handlerActivations);
                this.updateCommand(commandId, this.resolveConflicts(commandId, handlerActivations, conflicts));
            }
        } else {
            this.handlerActivationsByCommandId.put(commandId, activation);
            this.updateCommand(commandId, this.evaluate(activation) ? activation : null);
        }
        if (conflicts.getSeverity() != 0) {
            WorkbenchPlugin.log((IStatus)conflicts);
        }
        int sourcePriority = activation.getSourcePriority();
        int i = 1;
        while (i <= 32) {
            if ((sourcePriority & 1 << i) != 0) {
                Expression expression;
                HashSet<IHandlerActivation> activations;
                HashMap<Expression, HashSet<IHandlerActivation>> activationsByExpression = this.activationsByExpressionBySourcePriority[i];
                if (activationsByExpression == null) {
                    this.activationsByExpressionBySourcePriority[i] = activationsByExpression = new HashMap<Expression, HashSet<IHandlerActivation>>(256);
                }
                if ((activations = (HashSet<IHandlerActivation>)activationsByExpression.get(expression = activation.getExpression())) == null) {
                    activations = new HashSet<IHandlerActivation>();
                    activationsByExpression.put(expression, activations);
                }
                activations.add(activation);
            }
            ++i;
        }
    }

    final void deactivateHandler(IHandlerActivation activation) {
        String commandId = activation.getCommandId();
        MultiStatus conflicts = new MultiStatus("org.eclipse.ui.workbench", 0, "A handler conflict occurred.  This may disable some commands.", null);
        Object value = this.handlerActivationsByCommandId.get(commandId);
        if (value instanceof SortedSet) {
            SortedSet handlerActivations = (SortedSet)value;
            if (handlerActivations.contains(activation)) {
                handlerActivations.remove(activation);
                if (handlerActivations.isEmpty()) {
                    this.handlerActivationsByCommandId.remove(commandId);
                    this.updateCommand(commandId, null);
                } else if (handlerActivations.size() == 1) {
                    IHandlerActivation remainingActivation = (IHandlerActivation)handlerActivations.iterator().next();
                    this.handlerActivationsByCommandId.put(commandId, remainingActivation);
                    this.updateCommand(commandId, this.evaluate(remainingActivation) ? remainingActivation : null);
                } else {
                    this.updateCommand(commandId, this.resolveConflicts(commandId, handlerActivations, conflicts));
                }
            }
        } else if (value instanceof IHandlerActivation && value == activation) {
            this.handlerActivationsByCommandId.remove(commandId);
            this.updateCommand(commandId, null);
        }
        if (conflicts.getSeverity() != 0) {
            WorkbenchPlugin.log((IStatus)conflicts);
        }
        int sourcePriority = activation.getSourcePriority();
        int i = 1;
        while (i <= 32) {
            Map activationsByExpression;
            if ((sourcePriority & 1 << i) != 0 && (activationsByExpression = this.activationsByExpressionBySourcePriority[i]) != null) {
                Expression expression = activation.getExpression();
                Collection activations = (Collection)activationsByExpression.get(expression);
                activations.remove(activation);
                if (activations.isEmpty()) {
                    activationsByExpression.remove(expression);
                }
                if (activationsByExpression.isEmpty()) {
                    this.activationsByExpressionBySourcePriority[i] = null;
                }
            }
            ++i;
        }
    }

    final Shell getActiveShell() {
        return (Shell)this.getVariable("activeShell");
    }

    private final IHandlerActivation resolveConflicts(String commandId, SortedSet activations, MultiStatus conflicts) {
        if (activations.isEmpty()) {
            return null;
        }
        Iterator activationItr = activations.iterator();
        IHandlerActivation bestActivation = null;
        IHandlerActivation currentActivation = null;
        boolean conflict = false;
        while (activationItr.hasNext()) {
            currentActivation = (IHandlerActivation)activationItr.next();
            if (!this.evaluate(currentActivation)) continue;
            if (DEBUG_VERBOSE && (DEBUG_VERBOSE_COMMAND_ID == null || DEBUG_VERBOSE_COMMAND_ID.equals(commandId))) {
                Tracing.printTrace((String)TRACING_COMPONENT, (String)("    resolveConflicts: eval: " + currentActivation));
            }
            if (bestActivation == null) {
                bestActivation = currentActivation;
                conflict = false;
                continue;
            }
            int comparison = bestActivation.compareTo(currentActivation);
            if (comparison < 0) {
                bestActivation = currentActivation;
                conflict = false;
                continue;
            }
            if (comparison != 0) break;
            if (currentActivation.getHandler() == bestActivation.getHandler()) continue;
            conflict = true;
            break;
        }
        if (DEBUG) {
            if (conflict) {
                Tracing.printTrace((String)TRACING_COMPONENT, (String)("Unresolved conflict detected for '" + commandId + '\''));
            } else if (bestActivation != null && DEBUG_VERBOSE && (DEBUG_VERBOSE_COMMAND_ID == null || DEBUG_VERBOSE_COMMAND_ID.equals(commandId))) {
                Tracing.printTrace((String)TRACING_COMPONENT, (String)"Resolved conflict detected.  The following activation won: ");
                Tracing.printTrace((String)TRACING_COMPONENT, (String)("    " + bestActivation));
            }
        }
        if (conflict) {
            if (this.previousLogs.add(commandId)) {
                StringWriter sw = new StringWriter();
                BufferedWriter buffer = new BufferedWriter(sw);
                try {
                    buffer.write("Conflict for '");
                    buffer.write(commandId);
                    buffer.write("':");
                    buffer.newLine();
                    buffer.write(bestActivation.toString());
                    buffer.newLine();
                    buffer.write(currentActivation.toString());
                    buffer.flush();
                }
                catch (IOException iOException) {}
                Status s = new Status(2, "org.eclipse.ui.workbench", sw.toString());
                conflicts.add((IStatus)s);
            }
            return null;
        }
        return bestActivation;
    }

    /*
     * Unable to fully structure code
     */
    protected final void sourceChanged(int sourcePriority) {
        startTime = 0L;
        if (HandlerAuthority.DEBUG_PERFORMANCE) {
            startTime = System.currentTimeMillis();
        }
        changedCommandIds = new HashSet<String>(1024);
        i = 1;
        while (i <= 32) {
            block11: {
                if ((sourcePriority & 1 << i) == 0 || (activationsByExpression = this.activationsByExpressionBySourcePriority[i]) == null) break block11;
                activationByExpressionItr = activationsByExpression.values().iterator();
                while (activationByExpressionItr.hasNext()) {
                    activations = (Collection)activationByExpressionItr.next();
                    activationItr = activations.iterator();
                    if (!activationItr.hasNext()) continue;
                    activation = (IHandlerActivation)activationItr.next();
                    currentActive = this.evaluate(activation);
                    activation.clearResult();
                    newActive = this.evaluate(activation);
                    if (newActive == currentActive) ** GOTO lbl32
                    changedCommandIds.add(activation.getCommandId());
                    while (activationItr.hasNext()) {
                        activation = (IHandlerActivation)activationItr.next();
                        activation.setResult(newActive);
                        changedCommandIds.add(activation.getCommandId());
                    }
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        activation = (IHandlerActivation)activationItr.next();
                        if (newActive == this.evaluate(activation)) continue;
                        activation.setResult(newActive);
                        changedCommandIds.add(activation.getCommandId());
lbl32:
                        // 3 sources

                        ** while (activationItr.hasNext())
                    }
lbl33:
                    // 1 sources

                }
            }
            ++i;
        }
        conflicts = new MultiStatus("org.eclipse.ui.workbench", 0, "A handler conflict occurred.  This may disable some commands.", null);
        changedCommandIdItr = changedCommandIds.iterator();
        while (changedCommandIdItr.hasNext()) {
            commandId = (String)changedCommandIdItr.next();
            value = this.handlerActivationsByCommandId.get(commandId);
            if (value instanceof IHandlerActivation) {
                activation = (IHandlerActivation)value;
                this.updateCommand(commandId, this.evaluate(activation) != false ? activation : null);
                continue;
            }
            if (value instanceof SortedSet) {
                activation = this.resolveConflicts(commandId, (SortedSet)value, conflicts);
                this.updateCommand(commandId, activation);
                continue;
            }
            this.updateCommand(commandId, null);
        }
        if (conflicts.getSeverity() != 0) {
            WorkbenchPlugin.log((IStatus)conflicts);
        }
        if (HandlerAuthority.DEBUG_PERFORMANCE) {
            elapsedTime = System.currentTimeMillis() - startTime;
            size = changedCommandIds.size();
            if (size > 0) {
                Tracing.printTrace((String)"HANDLERS", (String)(String.valueOf(size) + " command ids changed in " + elapsedTime + "ms"));
            }
        }
    }

    private final void updateCommand(String commandId, IHandlerActivation activation) {
        Command command = this.commandService.getCommand(commandId);
        if (activation == null) {
            command.setHandler(null);
        } else {
            command.setHandler(activation.getHandler());
            this.commandService.refreshElements(commandId, null);
        }
    }

    final void updateShellKludge() {
        this.updateCurrentState();
        this.sourceChanged(1024);
    }

    public final IHandler findHandler(String commandId, IEvaluationContext context) {
        Object o = this.handlerActivationsByCommandId.get(commandId);
        if (o instanceof IHandlerActivation) {
            IHandlerActivation activation = (IHandlerActivation)o;
            try {
                if (this.eval(context, activation)) {
                    return activation.getHandler();
                }
            }
            catch (CoreException coreException) {}
        } else if (o instanceof SortedSet) {
            SortedSet activations = (SortedSet)o;
            IEvaluationResultCache lastActivation = null;
            IHandlerActivation currentActivation = null;
            Iterator i = activations.iterator();
            while (i.hasNext() && lastActivation == null) {
                IHandlerActivation activation = (IHandlerActivation)i.next();
                try {
                    if (!this.eval(context, activation)) continue;
                    lastActivation = currentActivation;
                    currentActivation = activation;
                }
                catch (CoreException coreException) {}
            }
            if (currentActivation != null) {
                if (lastActivation == null) {
                    return currentActivation.getHandler();
                }
                if (lastActivation.getSourcePriority() != currentActivation.getSourcePriority()) {
                    return lastActivation.getHandler();
                }
            }
        }
        return null;
    }

    private boolean eval(IEvaluationContext context, IHandlerActivation activation) throws CoreException {
        Expression expression = activation.getExpression();
        if (expression == null) {
            return true;
        }
        return expression.evaluate(context) == EvaluationResult.TRUE;
    }

    public IEvaluationContext getContextSnapshot() {
        return this.fillInContext(false);
    }

    public IEvaluationContext getFullContextSnapshot() {
        return this.fillInContext(true);
    }

    private IEvaluationContext fillInContext(boolean fullContext) {
        IEvaluationContext tmpContext = this.getCurrentState();
        EvaluationContext context = null;
        if (fullContext) {
            context = new EvaluationContext(null, tmpContext.getDefaultVariable());
            this.copyVariable((IEvaluationContext)context, tmpContext, "selection");
            this.copyVariable((IEvaluationContext)context, tmpContext, "activeFocusControlId");
            this.copyVariable((IEvaluationContext)context, tmpContext, "activeFocusControl");
            this.copyVariable((IEvaluationContext)context, tmpContext, "activeMenuEditorInput");
            this.copyVariable((IEvaluationContext)context, tmpContext, "activeMenu");
            this.copyVariable((IEvaluationContext)context, tmpContext, "activeMenuSelection");
        } else {
            context = new EvaluationContext(null, (Object)Collections.EMPTY_LIST);
        }
        this.copyVariable((IEvaluationContext)context, tmpContext, "activeActionSets");
        this.copyVariable((IEvaluationContext)context, tmpContext, "activeContexts");
        this.copyVariable((IEvaluationContext)context, tmpContext, "activeEditorId");
        this.copyVariable((IEvaluationContext)context, tmpContext, "activeEditor");
        this.copyVariable((IEvaluationContext)context, tmpContext, "activePartId");
        this.copyVariable((IEvaluationContext)context, tmpContext, "activePart");
        this.copyVariable((IEvaluationContext)context, tmpContext, "activeSite");
        this.copyVariable((IEvaluationContext)context, tmpContext, "activeWorkbenchWindow.isCoolbarVisible");
        this.copyVariable((IEvaluationContext)context, tmpContext, "activeWorkbenchWindow.isPerspectiveBarVisible");
        this.copyVariable((IEvaluationContext)context, tmpContext, "activeWorkbenchWindow");
        this.copyVariable((IEvaluationContext)context, tmpContext, "activeWorkbenchWindowShell");
        this.copyVariable((IEvaluationContext)context, tmpContext, "activeShell");
        return context;
    }

    private void copyVariable(IEvaluationContext context, IEvaluationContext tmpContext, String var) {
        Object o = tmpContext.getVariable(var);
        if (o != null) {
            context.addVariable(var, o);
        }
    }
}

