/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XFocusChangeEvent;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XRectangle;
import org.eclipse.swt.internal.motif.XmAnyCallbackStruct;
import org.eclipse.swt.internal.motif.XmSpinBoxCallbackStruct;
import org.eclipse.swt.internal.motif.XmTextBlockRec;
import org.eclipse.swt.internal.motif.XmTextVerifyCallbackStruct;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Spinner
extends Composite {
    public Spinner(Composite parent, int style) {
        super(parent, Spinner.checkStyle(style));
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    static int checkStyle(int style) {
        return style & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        int width = wHint;
        int height = hHint;
        if (wHint == -1) {
            Object buffer;
            width = 64;
            int[] nArray = new int[4];
            nArray[0] = OS.XmNmaximumValue;
            nArray[2] = OS.XmNdecimalPoints;
            int[] argList = nArray;
            OS.XtGetValues(this.handle, argList, argList.length / 2);
            String string = String.valueOf(argList[1]);
            if (argList[3] > 0) {
                buffer = new StringBuffer();
                ((StringBuffer)buffer).append(string);
                ((StringBuffer)buffer).append(this.getDecimalSeparator());
                int count = argList[3] - string.length();
                while (count >= 0) {
                    ((StringBuffer)buffer).append("0");
                    --count;
                }
                string = ((StringBuffer)buffer).toString();
            }
            buffer = Converter.wcsToMbcs(this.getCodePage(), string, true);
            int xmString = OS.XmStringCreateLocalized((byte[])buffer);
            int fontList = this.font.handle;
            width = OS.XmStringWidth(fontList, xmString);
            OS.XmStringFree(xmString);
        }
        if (hHint == -1) {
            height = this.getFontHeight(this.font.handle);
        }
        Rectangle trim = this.computeTrim(0, 0, width, height);
        if (hHint == -1) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNarrowSize;
            int[] argList = nArray;
            OS.XtGetValues(this.handle, argList, argList.length / 2);
            trim.height = Math.max(trim.height, argList[1] * 2);
        }
        return new Point(trim.width, trim.height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int[] nArray = new int[8];
        nArray[0] = OS.XmNtextField;
        nArray[2] = OS.XmNarrowSize;
        nArray[4] = OS.XmNmarginWidth;
        nArray[6] = OS.XmNmarginHeight;
        int[] argList1 = nArray;
        OS.XtGetValues(this.handle, argList1, argList1.length / 2);
        int[] nArray2 = new int[4];
        nArray2[0] = OS.XmNshadowThickness;
        nArray2[2] = OS.XmNhighlightThickness;
        int[] argList2 = nArray2;
        OS.XtGetValues(argList1[1], argList2, argList2.length / 2);
        XRectangle rect = new XRectangle();
        OS.XmWidgetGetDisplayRect(argList1[1], rect);
        return new Rectangle(x -= argList1[5] + argList2[1] + argList2[3] + rect.x, y -= argList1[7] + argList2[1] + argList2[3] + rect.y, width += (argList1[5] + argList2[1] + argList2[3] + rect.x) * 2 + argList1[3], height += (argList1[7] + argList2[1] + argList2[3] + rect.y) * 2);
    }

    public void copy() {
        this.checkWidget();
        int xDisplay = OS.XtDisplay(this.handle);
        if (xDisplay == 0) {
            return;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        OS.XmTextCopy(argList[1], OS.XtLastTimestampProcessed(xDisplay));
    }

    void createHandle(int index) {
        int[] nArray = new int[18];
        nArray[0] = OS.XmNcolumns;
        nArray[1] = 2;
        nArray[2] = OS.XmNdecimalPoints;
        nArray[4] = OS.XmNincrementValue;
        nArray[5] = 1;
        nArray[6] = OS.XmNminimumValue;
        nArray[8] = OS.XmNmaximumValue;
        nArray[9] = 100;
        nArray[10] = OS.XmNspinBoxChildType;
        nArray[11] = 3;
        nArray[12] = OS.XmNeditable;
        nArray[13] = (this.style & 8) != 0 ? 0 : 1;
        nArray[14] = OS.XmNshadowThickness;
        nArray[16] = OS.XmNancestorSensitive;
        nArray[17] = 1;
        int[] argList1 = nArray;
        int parentHandle = this.parent.handle;
        this.handle = OS.XmCreateSimpleSpinBox(parentHandle, null, argList1, argList1.length / 2);
        int[] nArray2 = new int[2];
        nArray2[0] = OS.XmNtextField;
        int[] argList2 = nArray2;
        OS.XtGetValues(this.handle, argList2, argList2.length / 2);
        int textHandle = argList2[1];
        int[] nArray3 = new int[4];
        nArray3[0] = OS.XmNverifyBell;
        nArray3[2] = OS.XmNcursorPositionVisible;
        nArray3[3] = (this.style & 8) != 0 ? 0 : 1;
        int[] argList3 = nArray3;
        OS.XtSetValues(textHandle, argList3, argList3.length / 2);
        if ((this.style & 0x800) == 0) {
            int[] nArray4 = new int[4];
            nArray4[0] = OS.XmNmarginHeight;
            nArray4[2] = OS.XmNshadowThickness;
            int[] argList4 = nArray4;
            OS.XtSetValues(textHandle, argList4, argList4.length / 2);
        }
        OS.XmDropSiteUnregister(textHandle);
    }

    public void cut() {
        this.checkWidget();
        int xDisplay = OS.XtDisplay(this.handle);
        if (xDisplay == 0) {
            return;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        OS.XmTextCut(argList[1], OS.XtLastTimestampProcessed(xDisplay));
    }

    void deregister() {
        super.deregister();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        this.display.removeWidget(argList[1]);
    }

    int fontHandle() {
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    public int getDigits() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNdecimalPoints;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    String getDecimalSeparator() {
        int ptr = OS.localeconv_decimal_point();
        int length = OS.strlen(ptr);
        byte[] buffer = new byte[length];
        OS.memmove(buffer, ptr, length);
        return new String(Converter.mbcsToWcs(null, buffer));
    }

    public int getIncrement() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNincrementValue;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    public int getMaximum() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNmaximumValue;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    public int getMinimum() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNminimumValue;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    public int getPageIncrement() {
        this.checkWidget();
        return 1;
    }

    public int getSelection() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNposition;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    void hookEvents() {
        super.hookEvents();
        int windowProc = this.display.windowProc;
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int textHandle = argList[1];
        OS.XtAddCallback(this.handle, OS.XmNvalueChangedCallback, windowProc, 24);
        OS.XtAddCallback(this.handle, OS.XmNmodifyVerifyCallback, windowProc, 19);
        OS.XtAddCallback(textHandle, OS.XmNactivateCallback, windowProc, 9);
        OS.XtAddCallback(textHandle, OS.XmNvalueChangedCallback, windowProc, 24);
        OS.XtAddCallback(textHandle, OS.XmNmodifyVerifyCallback, windowProc, 19);
        OS.XtAddEventHandler(textHandle, 4, false, windowProc, 1);
        OS.XtAddEventHandler(textHandle, 8, false, windowProc, 2);
        OS.XtAddEventHandler(textHandle, 16, false, windowProc, 4);
        OS.XtAddEventHandler(textHandle, 32, false, windowProc, 8);
        OS.XtAddEventHandler(textHandle, 1, false, windowProc, 6);
        OS.XtAddEventHandler(textHandle, 2, false, windowProc, 7);
        OS.XtInsertEventHandler(textHandle, 0x200000, false, windowProc, 5, 1);
    }

    public void paste() {
        this.checkWidget();
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        OS.XmTextFieldPaste(argList[1]);
        this.display.setWarnings(warnings);
    }

    void register() {
        super.register();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        this.display.addWidget(argList[1], this);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    void setBackgroundPixel(int pixel) {
        super.setBackgroundPixel(pixel);
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] argList1 = nArray;
        OS.XtGetValues(this.handle, argList1, argList1.length / 2);
        int textHandle = argList1[1];
        int[] nArray2 = new int[4];
        nArray2[0] = OS.XmNforeground;
        nArray2[2] = OS.XmNhighlightColor;
        int[] argList2 = nArray2;
        OS.XtGetValues(textHandle, argList2, argList2.length / 2);
        OS.XmChangeColor(textHandle, pixel);
        OS.XtSetValues(textHandle, argList2, argList2.length / 2);
    }

    boolean setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        if (resize) {
            int[] nArray = new int[8];
            nArray[0] = OS.XmNtextField;
            nArray[2] = OS.XmNarrowSize;
            nArray[4] = OS.XmNmarginWidth;
            nArray[6] = OS.XmNmarginHeight;
            int[] argList1 = nArray;
            OS.XtGetValues(this.handle, argList1, argList1.length / 2);
            int[] nArray2 = new int[6];
            nArray2[0] = OS.XmNwidth;
            nArray2[2] = OS.XmNheight;
            nArray2[4] = OS.XmNborderWidth;
            int[] argList2 = nArray2;
            OS.XtGetValues(argList1[1], argList2, argList2.length / 2);
            int textWidth = Math.max(width - argList1[3] - 2 * argList1[5], 0);
            int textHeight = Math.max(height - 2 * argList1[7], 0);
            if (textWidth != argList2[1] || textHeight != argList2[3]) {
                OS.XtResizeWidget(argList1[1], textWidth, textHeight, argList2[5]);
            }
        }
        return super.setBounds(x, y, width, height, move, resize);
    }

    public void setDigits(int value) {
        this.checkWidget();
        if (value < 0) {
            this.error(5);
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNposition;
        int[] argList1 = nArray;
        OS.XtGetValues(this.handle, argList1, argList1.length / 2);
        int[] argList2 = new int[]{OS.XmNdecimalPoints, value, OS.XmNposition, argList1[1]};
        OS.XtSetValues(this.handle, argList2, argList2.length / 2);
    }

    void setForegroundPixel(int pixel) {
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] argList1 = nArray;
        OS.XtGetValues(this.handle, argList1, argList1.length / 2);
        int[] argList2 = new int[]{OS.XmNforeground, pixel};
        OS.XtSetValues(argList1[1], argList2, argList2.length / 2);
        super.setForegroundPixel(pixel);
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        int[] argList = new int[]{OS.XmNincrementValue, value};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNminimumValue;
        nArray[2] = OS.XmNposition;
        int[] argList1 = nArray;
        OS.XtGetValues(this.handle, argList1, argList1.length / 2);
        if (value <= argList1[1]) {
            return;
        }
        int position = argList1[3];
        if (value < position) {
            position = value;
        }
        int[] argList2 = new int[]{OS.XmNposition, position, OS.XmNmaximumValue, value};
        OS.XtSetValues(this.handle, argList2, argList2.length / 2);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNmaximumValue;
        nArray[2] = OS.XmNposition;
        int[] argList1 = nArray;
        OS.XtGetValues(this.handle, argList1, argList1.length / 2);
        if (value >= argList1[1]) {
            return;
        }
        int position = argList1[3];
        if (value > position) {
            position = value;
        }
        int[] argList2 = new int[]{OS.XmNposition, position, OS.XmNminimumValue, value};
        OS.XtSetValues(this.handle, argList2, argList2.length / 2);
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
    }

    public void setSelection(int value) {
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNmaximumValue;
        nArray[2] = OS.XmNminimumValue;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        value = Math.min(Math.max(argList[3], value), argList[1]);
        int[] argList1 = new int[]{OS.XmNposition, value};
        OS.XtSetValues(this.handle, argList1, argList1.length / 2);
    }

    public void setValues(int selection, int minimum, int maximum, int digits, int increment, int pageIncrement) {
        this.checkWidget();
        if (minimum < 0) {
            return;
        }
        if (maximum <= minimum) {
            return;
        }
        if (digits < 0) {
            return;
        }
        if (increment < 1) {
            return;
        }
        if (pageIncrement < 1) {
            return;
        }
        selection = Math.min(Math.max(minimum, selection), maximum);
        int[] argList = new int[]{OS.XmNposition, selection, OS.XmNmaximumValue, maximum, OS.XmNminimumValue, minimum, OS.XmNincrementValue, increment, OS.XmNdecimalPoints, digits};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
    }

    void updateText() {
        byte[] buffer;
        int[] nArray = new int[10];
        nArray[0] = OS.XmNtextField;
        nArray[2] = OS.XmNminimumValue;
        nArray[4] = OS.XmNmaximumValue;
        nArray[6] = OS.XmNposition;
        nArray[8] = OS.XmNdecimalPoints;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int ptr = OS.XmTextGetString(argList[1]);
        int position = argList[7];
        int digits = argList[9];
        if (ptr != 0) {
            int length = OS.strlen(ptr);
            buffer = new byte[length];
            OS.memmove(buffer, ptr, length);
            OS.XtFree(ptr);
            String string = new String(Converter.mbcsToWcs(this.getCodePage(), buffer));
            try {
                int value;
                if (digits > 0) {
                    String decimalSeparator = this.getDecimalSeparator();
                    int index = string.indexOf(decimalSeparator);
                    if (index != -1) {
                        String wholePart = string.substring(0, index);
                        String decimalPart = string.substring(index + 1);
                        if (decimalPart.length() > digits) {
                            decimalPart = decimalPart.substring(0, digits);
                        } else {
                            int i = digits - decimalPart.length();
                            int j = 0;
                            while (j < i) {
                                decimalPart = String.valueOf(decimalPart) + "0";
                                ++j;
                            }
                        }
                        int wholeValue = Integer.parseInt(wholePart);
                        int decimalValue = Integer.parseInt(decimalPart);
                        int i = 0;
                        while (i < digits) {
                            wholeValue *= 10;
                            ++i;
                        }
                        value = wholeValue + decimalValue;
                    } else {
                        value = Integer.parseInt(string);
                    }
                } else {
                    value = Integer.parseInt(string);
                }
                if (argList[3] <= value && value <= argList[5]) {
                    position = value;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (position == argList[7]) {
            String string = String.valueOf(position);
            if (digits > 0) {
                String decimalSeparator = this.getDecimalSeparator();
                int index = string.length() - digits;
                StringBuffer buffer2 = new StringBuffer();
                if (index > 0) {
                    buffer2.append(string.substring(0, index));
                    buffer2.append(decimalSeparator);
                    buffer2.append(string.substring(index));
                } else {
                    buffer2.append("0");
                    buffer2.append(decimalSeparator);
                    while (index++ < 0) {
                        buffer2.append("0");
                    }
                    buffer2.append(string);
                }
                string = buffer2.toString();
            }
            buffer = Converter.wcsToMbcs(this.getCodePage(), string, true);
            boolean warnings = this.display.getWarnings();
            this.display.setWarnings(false);
            OS.XmTextSetString(argList[1], buffer);
            this.display.setWarnings(warnings);
        } else {
            int[] argList2 = new int[]{OS.XmNposition, position};
            OS.XtSetValues(this.handle, argList2, argList2.length / 2);
        }
    }

    int XmNactivateCallback(int w, int client_data, int call_data) {
        this.postEvent(14);
        this.updateText();
        return 0;
    }

    int xFocusOut(XFocusChangeEvent xEvent) {
        this.updateText();
        return super.xFocusOut(xEvent);
    }

    int XmNmodifyVerifyCallback(int w, int client_data, int call_data) {
        if (w == this.handle) {
            if ((this.style & 0x40) == 0) {
                XmSpinBoxCallbackStruct struct = new XmSpinBoxCallbackStruct();
                OS.memmove(struct, call_data, 28);
                if (struct.crossed_boundary != 0) {
                    struct.doit = 0;
                    OS.memmove(call_data, struct, 28);
                }
            }
            return 0;
        }
        int result = super.XmNmodifyVerifyCallback(w, client_data, call_data);
        if (result != 0) {
            return result;
        }
        if (this.font == null) {
            return result;
        }
        XmTextVerifyCallbackStruct textVerify = new XmTextVerifyCallbackStruct();
        OS.memmove(textVerify, call_data, 32);
        XmTextBlockRec textBlock = new XmTextBlockRec();
        OS.memmove(textBlock, textVerify.text, 12);
        byte[] buffer = new byte[textBlock.length];
        OS.memmove(buffer, textBlock.ptr, textBlock.length);
        String codePage = this.getCodePage();
        String text = new String(Converter.mbcsToWcs(codePage, buffer));
        Event event = new Event();
        if (textVerify.event != 0) {
            XKeyEvent xEvent = new XKeyEvent();
            OS.memmove(xEvent, textVerify.event, 60);
            event.time = xEvent.time;
            this.setKeyState(event, xEvent);
        }
        event.start = textVerify.startPos;
        event.end = textVerify.endPos;
        event.text = text;
        String string = text;
        int index = 0;
        int[] nArray = new int[2];
        nArray[0] = OS.XmNdecimalPoints;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (argList[1] > 0) {
            String decimalSeparator = this.getDecimalSeparator();
            index = string.indexOf(decimalSeparator);
            if (index != -1) {
                string = String.valueOf(string.substring(0, index)) + string.substring(index + 1);
            }
            index = 0;
        }
        while (index < string.length()) {
            if (!Character.isDigit(string.charAt(index))) break;
            ++index;
        }
        event.doit = index == string.length();
        this.sendEvent(25, event);
        String newText = event.text;
        textVerify.doit = (byte)(event.doit && newText != null ? 1 : 0);
        if (newText != null && newText != text) {
            OS.XtFree(textBlock.ptr);
            byte[] buffer2 = Converter.wcsToMbcs(codePage, newText, true);
            int length = buffer2.length;
            int ptr = OS.XtMalloc(length);
            OS.memmove(ptr, buffer2, length);
            textBlock.ptr = ptr;
            textBlock.length = buffer2.length - 1;
            OS.memmove(textVerify.text, textBlock, 12);
        }
        OS.memmove(call_data, textVerify, 32);
        return result;
    }

    int XmNvalueChangedCallback(int w, int client_data, int call_data) {
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (w == argList[1]) {
            this.sendEvent(24);
        } else {
            XmAnyCallbackStruct struct = new XmAnyCallbackStruct();
            OS.memmove(struct, call_data, 8);
            if (struct.reason == 31) {
                this.postEvent(13);
            }
        }
        return 0;
    }
}

