/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class MessageBox
extends Dialog {
    int button;
    String message = "";

    public MessageBox(Shell parent) {
        this(parent, 65570);
    }

    public MessageBox(Shell parent, int style) {
        super(parent, MessageBox.checkStyle(style));
        this.checkSubclass();
    }

    int activate(int widget, int client, int call) {
        OS.XtUnmanageChild(widget);
        this.button = client;
        return 0;
    }

    static int checkStyle(int style) {
        int mask;
        int bits;
        if ((style & 0x38000) == 0) {
            style |= 0x10000;
        }
        if ((bits = style & (mask = 4064)) == 32 || bits == 256 || bits == 288) {
            return style;
        }
        if (bits == 64 || bits == 128 || bits == 192 || bits == 448) {
            return style;
        }
        if (bits == 1280 || bits == 3584) {
            return style;
        }
        style = style & ~mask | 0x20;
        return style;
    }

    int createHandle(int parentHandle, int[] argList) {
        if ((this.style & 1) != 0) {
            return OS.XmCreateErrorDialog(parentHandle, null, argList, argList.length / 2);
        }
        if ((this.style & 2) != 0) {
            return OS.XmCreateInformationDialog(parentHandle, null, argList, argList.length / 2);
        }
        if ((this.style & 4) != 0) {
            return OS.XmCreateQuestionDialog(parentHandle, null, argList, argList.length / 2);
        }
        if ((this.style & 8) != 0) {
            return OS.XmCreateWarningDialog(parentHandle, null, argList, argList.length / 2);
        }
        if ((this.style & 0x10) != 0) {
            return OS.XmCreateWorkingDialog(parentHandle, null, argList, argList.length / 2);
        }
        return OS.XmCreateMessageDialog(parentHandle, null, argList, argList.length / 2);
    }

    public String getMessage() {
        return this.message;
    }

    public int open() {
        String string = this.title;
        if (string.length() == 0) {
            string = " ";
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        int xmStringPtr = OS.XmStringParseText(buffer, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
        int dialogStyle = 0;
        if ((this.style & 0x8000) != 0) {
            dialogStyle = 1;
        }
        if ((this.style & 0x10000) != 0) {
            dialogStyle = 2;
        }
        if ((this.style & 0x20000) != 0) {
            dialogStyle = 3;
        }
        if (dialogStyle == 0) {
            dialogStyle = 1;
        }
        boolean defaultPos = this.parent.isVisible();
        int[] nArray = new int[10];
        nArray[0] = OS.XmNnoResize;
        nArray[1] = 1;
        nArray[2] = OS.XmNresizePolicy;
        nArray[4] = OS.XmNdialogStyle;
        nArray[5] = dialogStyle;
        nArray[6] = OS.XmNdialogTitle;
        nArray[7] = xmStringPtr;
        nArray[8] = OS.XmNdefaultPosition;
        nArray[9] = defaultPos ? 1 : 0;
        int parentHandle = this.parent.shellHandle;
        int[] argList = nArray;
        int dialog = this.createHandle(parentHandle, argList);
        if (dialog == 0) {
            this.error(2);
        }
        OS.XmStringFree(xmStringPtr);
        this.setMessage(dialog);
        this.setButtons(dialog);
        Callback callback = new Callback(this, "activate", 3);
        int address = callback.getAddress();
        if (address == 0) {
            SWT.error(3);
        }
        OS.XtAddCallback(dialog, OS.XmNokCallback, address, 4);
        OS.XtAddCallback(dialog, OS.XmNcancelCallback, address, 2);
        OS.XtAddCallback(dialog, OS.XmNhelpCallback, address, 7);
        if (!defaultPos) {
            OS.XtRealizeWidget(dialog);
            int[] nArray2 = new int[4];
            nArray2[0] = OS.XmNwidth;
            nArray2[2] = OS.XmNheight;
            int[] argList1 = nArray2;
            OS.XtGetValues(dialog, argList1, argList1.length / 2);
            Monitor monitor = this.parent.getMonitor();
            Rectangle bounds = monitor.getBounds();
            int x = bounds.x + (bounds.width - argList1[1]) / 2;
            int y = bounds.y + (bounds.height - argList1[3]) / 2;
            int[] argList2 = new int[]{OS.XmNx, x, OS.XmNy, y};
            OS.XtSetValues(dialog, argList2, argList2.length / 2);
        }
        OS.XtManageChild(dialog);
        Display display = this.parent.display;
        while (OS.XtIsRealized(dialog) && OS.XtIsManaged(dialog)) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (OS.XtIsRealized(dialog)) {
            OS.XtDestroyWidget(dialog);
        }
        callback.dispose();
        if ((this.style & 0x1C0) == 448) {
            if (this.button == 4) {
                return 64;
            }
            if (this.button == 2) {
                return 128;
            }
            return 256;
        }
        if ((this.style & 0xC0) == 192) {
            return this.button == 4 ? 64 : 128;
        }
        if ((this.style & 0x120) == 288) {
            return this.button == 4 ? 32 : 256;
        }
        if ((this.style & 0x20) == 32) {
            return 32;
        }
        if ((this.style & 0x500) == 1280) {
            return this.button == 4 ? 1024 : 256;
        }
        if ((this.style & 0xE00) == 3584) {
            if (this.button == 4) {
                return 512;
            }
            if (this.button == 2) {
                return 1024;
            }
            return 2048;
        }
        return 256;
    }

    void setButtons(int dialogHandle) {
        OS.XmMessageBoxGetChild(dialogHandle, 4);
        int cancel = OS.XmMessageBoxGetChild(dialogHandle, 2);
        int help = OS.XmMessageBoxGetChild(dialogHandle, 7);
        OS.XtUnmanageChild(help);
        if ((this.style & 0x120) == 288) {
            return;
        }
        if ((this.style & 0x20) == 32) {
            OS.XtUnmanageChild(cancel);
            return;
        }
        if ((this.style & 0x1C0) == 448) {
            OS.XtManageChild(help);
            byte[] buffer1 = Converter.wcsToMbcs(null, SWT.getMessage("SWT_Yes"), true);
            int xmString1 = OS.XmStringParseText(buffer1, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
            byte[] buffer2 = Converter.wcsToMbcs(null, SWT.getMessage("SWT_No"), true);
            int xmString2 = OS.XmStringParseText(buffer2, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
            byte[] buffer3 = Converter.wcsToMbcs(null, SWT.getMessage("SWT_Cancel"), true);
            int xmString3 = OS.XmStringParseText(buffer3, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
            int[] argList = new int[]{OS.XmNokLabelString, xmString1, OS.XmNcancelLabelString, xmString2, OS.XmNhelpLabelString, xmString3};
            OS.XtSetValues(dialogHandle, argList, argList.length / 2);
            OS.XmStringFree(xmString1);
            OS.XmStringFree(xmString2);
            OS.XmStringFree(xmString3);
            return;
        }
        if ((this.style & 0xC0) == 192) {
            byte[] buffer1 = Converter.wcsToMbcs(null, SWT.getMessage("SWT_Yes"), true);
            int xmString1 = OS.XmStringParseText(buffer1, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
            byte[] buffer2 = Converter.wcsToMbcs(null, SWT.getMessage("SWT_No"), true);
            int xmString2 = OS.XmStringParseText(buffer2, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
            int[] argList = new int[]{OS.XmNokLabelString, xmString1, OS.XmNcancelLabelString, xmString2};
            OS.XtSetValues(dialogHandle, argList, argList.length / 2);
            OS.XmStringFree(xmString1);
            OS.XmStringFree(xmString2);
            return;
        }
        if ((this.style & 0x500) == 1280) {
            byte[] buffer1 = Converter.wcsToMbcs(null, SWT.getMessage("SWT_Retry"), true);
            int xmString1 = OS.XmStringParseText(buffer1, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
            byte[] buffer2 = Converter.wcsToMbcs(null, SWT.getMessage("SWT_Cancel"), true);
            int xmString2 = OS.XmStringParseText(buffer2, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
            int[] argList = new int[]{OS.XmNokLabelString, xmString1, OS.XmNcancelLabelString, xmString2};
            OS.XtSetValues(dialogHandle, argList, argList.length / 2);
            OS.XmStringFree(xmString1);
            OS.XmStringFree(xmString2);
            return;
        }
        if ((this.style & 0xE00) == 3584) {
            OS.XtManageChild(help);
            byte[] buffer1 = Converter.wcsToMbcs(null, SWT.getMessage("SWT_Abort"), true);
            int xmString1 = OS.XmStringParseText(buffer1, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
            byte[] buffer2 = Converter.wcsToMbcs(null, SWT.getMessage("SWT_Retry"), true);
            int xmString2 = OS.XmStringParseText(buffer2, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
            byte[] buffer3 = Converter.wcsToMbcs(null, SWT.getMessage("SWT_Ignore"), true);
            int xmString3 = OS.XmStringParseText(buffer3, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
            int[] argList = new int[]{OS.XmNokLabelString, xmString1, OS.XmNcancelLabelString, xmString2, OS.XmNhelpLabelString, xmString3};
            OS.XtSetValues(dialogHandle, argList, argList.length / 2);
            OS.XmStringFree(xmString1);
            OS.XmStringFree(xmString2);
            OS.XmStringFree(xmString3);
            return;
        }
    }

    void setMessage(int dialogHandle) {
        String text = this.message;
        int label = OS.XmMessageBoxGetChild(dialogHandle, 10);
        if (label != 0) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNfontList;
            int[] argList = nArray;
            OS.XtGetValues(label, argList, argList.length / 2);
            int fontList = argList[1];
            if (fontList != 0) {
                Display display = this.parent.display;
                int xDisplay = display.xDisplay;
                int screen = OS.XDefaultScreen(xDisplay);
                int width = OS.XDisplayWidth(xDisplay, screen);
                Font font = Font.motif_new(display, fontList);
                text = display.wrapText(this.message, font, width * 3 / 5);
            }
        }
        byte[] buffer = Converter.wcsToMbcs(null, text, true);
        int xmString = OS.XmStringGenerate(buffer, null, 0, null);
        int[] argList = new int[]{OS.XmNmessageString, xmString};
        OS.XtSetValues(dialogHandle, argList, argList.length / 2);
        OS.XmStringFree(xmString);
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }
}

