/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.wizard;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ProgressMonitorPart
extends Composite
implements IProgressMonitorWithBlocking {
    protected Label fLabel;
    protected String fTaskName;
    protected String fSubTaskName;
    protected ProgressIndicator fProgressIndicator;
    protected Control fCancelComponent;
    protected boolean fIsCanceled;
    protected IStatus blockedStatus;
    protected Listener fCancelListener = new Listener(){

        public void handleEvent(Event e) {
            ProgressMonitorPart.this.setCanceled(true);
            if (ProgressMonitorPart.this.fCancelComponent != null) {
                ProgressMonitorPart.this.fCancelComponent.setEnabled(false);
            }
        }
    };

    public ProgressMonitorPart(Composite parent, Layout layout) {
        this(parent, layout, -1);
    }

    public ProgressMonitorPart(Composite parent, Layout layout, int progressIndicatorHeight) {
        super(parent, 0);
        this.initialize(layout, progressIndicatorHeight);
    }

    public void attachToCancelComponent(Control cancelComponent) {
        Assert.isNotNull((Object)cancelComponent);
        this.fCancelComponent = cancelComponent;
        this.fCancelComponent.addListener(13, this.fCancelListener);
    }

    public void beginTask(String name, int totalWork) {
        this.fTaskName = name;
        this.updateLabel();
        if (totalWork == -1 || totalWork == 0) {
            this.fProgressIndicator.beginAnimatedTask();
        } else {
            this.fProgressIndicator.beginTask(totalWork);
        }
    }

    public void done() {
        this.fLabel.setText("");
        this.fProgressIndicator.sendRemainingWork();
        this.fProgressIndicator.done();
    }

    protected static String escapeMetaCharacters(String in) {
        if (in == null || in.indexOf(38) < 0) {
            return in;
        }
        int length = in.length();
        StringBuffer out = new StringBuffer(length + 1);
        int i = 0;
        while (i < length) {
            char c = in.charAt(i);
            if (c == '&') {
                out.append("&&");
            } else {
                out.append(c);
            }
            ++i;
        }
        return out.toString();
    }

    protected void initialize(Layout layout, int progressIndicatorHeight) {
        if (layout == null) {
            GridLayout l = new GridLayout();
            l.marginWidth = 0;
            l.marginHeight = 0;
            l.numColumns = 1;
            layout = l;
        }
        this.setLayout(layout);
        this.fLabel = new Label((Composite)this, 16384);
        this.fLabel.setLayoutData((Object)new GridData(768));
        if (progressIndicatorHeight == -1) {
            GC gc = new GC((Drawable)this.fLabel);
            FontMetrics fm = gc.getFontMetrics();
            gc.dispose();
            progressIndicatorHeight = fm.getHeight();
        }
        this.fProgressIndicator = new ProgressIndicator(this);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 2;
        gd.heightHint = progressIndicatorHeight;
        this.fProgressIndicator.setLayoutData(gd);
    }

    public void internalWorked(double work) {
        this.fProgressIndicator.worked(work);
    }

    public boolean isCanceled() {
        return this.fIsCanceled;
    }

    public void removeFromCancelComponent(Control cc) {
        Assert.isTrue((this.fCancelComponent == cc && this.fCancelComponent != null ? 1 : 0) != 0);
        this.fCancelComponent.removeListener(13, this.fCancelListener);
        this.fCancelComponent = null;
    }

    public void setCanceled(boolean b) {
        this.fIsCanceled = b;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fLabel.setFont(font);
        this.fProgressIndicator.setFont(font);
    }

    public void setTaskName(String name) {
        this.fTaskName = name;
        this.updateLabel();
    }

    public void subTask(String name) {
        this.fSubTaskName = name;
        this.updateLabel();
    }

    protected void updateLabel() {
        if (this.blockedStatus == null) {
            String text = this.taskLabel();
            this.fLabel.setText(text);
        } else {
            this.fLabel.setText(this.blockedStatus.getMessage());
        }
        this.fLabel.update();
    }

    private String taskLabel() {
        String text;
        String string = text = this.fSubTaskName == null ? "" : this.fSubTaskName;
        if (this.fTaskName != null && this.fTaskName.length() > 0) {
            text = JFaceResources.format("Set_SubTask", new Object[]{this.fTaskName, text});
        }
        return ProgressMonitorPart.escapeMetaCharacters(text);
    }

    public void worked(int work) {
        this.internalWorked(work);
    }

    public void clearBlocked() {
        this.blockedStatus = null;
        this.updateLabel();
    }

    public void setBlocked(IStatus reason) {
        this.blockedStatus = reason;
        this.updateLabel();
    }
}

