/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.tadotter.actions;

import com.hisagisoft.common.IMonitor;
import com.hisagisoft.eclipse.tadotter.Activator;
import com.hisagisoft.eclipse.tadotter.views.TrackView;
import com.hisagisoft.tadotter.Service;
import com.hisagisoft.tadotter.model.Twitter;
import com.hisagisoft.tadotter.model.TwitterList;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class RefreshAction
extends Action {
    private static Logger logger = Logger.getLogger(RefreshAction.class.getName());
    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd EEEE HH:mm:ss");
    private TrackView view;
    private IStatusLineManager statusLine;
    private TwitterList list;
    private TwitterList cancelMessageList;

    public RefreshAction() {
        this.setText("\u30bf\u30c9\u308a\u307e\u3059");
        this.setToolTipText("\u30bf\u30c9\u308a\u307e\u3059");
        this.setImageDescriptor(Activator.getImageDescriptor("icons/e16/run.gif"));
        this.setDisabledImageDescriptor(Activator.getImageDescriptor("icons/d16/run.gif"));
    }

    private void init() {
        if (this.cancelMessageList == null) {
            this.cancelMessageList = new TwitterList();
            Twitter t = new Twitter();
            t.setSeq(-1);
            t.setMessage("\u30ad\u30e3\u30f3\u30bb\u30eb\u3055\u308c\u307e\u3057\u305f");
            this.cancelMessageList.add((Object)t);
        }
    }

    public void run() {
        block7: {
            logger.fine("Refresh Action - START");
            this.init();
            IWorkbenchWindow window = null;
            try {
                window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                this.view = (TrackView)window.getActivePage().showView("com.hisagisoft.eclipse.tadotter.TrackView");
                this.statusLine = this.view.getViewSite().getActionBars().getStatusLineManager();
                this.setEnabled(false);
                this.statusLine.setMessage("");
                window.run(true, true, new IRunnableWithProgress(){

                    public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        Service service = Service.getInstance();
                        service.setMonitor(new IMonitor(){

                            public boolean isCanceled() {
                                return monitor.isCanceled();
                            }

                            public void setTaskName(String name) {
                                monitor.setTaskName(name);
                            }

                            public void subTask(String name) {
                                monitor.subTask(name);
                            }

                            public void worked(int work) {
                                monitor.worked(work);
                            }
                        });
                        service.setJPNOnly(true);
                        service.setMaxSize(30);
                        monitor.beginTask("\u30bf\u30c9\u3063\u3066\u3044\u307e\u3059", service.getMaxSize());
                        try {
                            try {
                                service.trackFromRoot();
                                RefreshAction.this.list = service.getTwitterList();
                            }
                            catch (InterruptedException e) {
                                RefreshAction.this.list = RefreshAction.this.cancelMessageList;
                                throw e;
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                this.setEnabled(true);
                window.getActivePage().activate((IWorkbenchPart)this.view);
                break block7;
            }
            catch (Throwable e) {
                try {
                    e.printStackTrace();
                    MessageDialog.openError((Shell)this.view.getSite().getShell(), (String)"Error", (String)("Error refreshing view:" + e.getMessage()));
                    break block7;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.setEnabled(true);
                    window.getActivePage().activate((IWorkbenchPart)this.view);
                }
            }
            this.setEnabled(true);
            window.getActivePage().activate((IWorkbenchPart)this.view);
        }
        this.view.setInput(this.list);
        String now = DATE_FORMAT.format(new Date());
        this.statusLine.setMessage(String.valueOf(this.list.size()) + "\u4ef6\u30bf\u30c9\u30c3\u30bf\u30fc " + now);
        logger.fine("Refresh Action - END");
    }
}

