/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.tadotter.views;

import com.hisagisoft.eclipse.tadotter.views.DoubleClickListener;
import com.hisagisoft.tadotter.model.Twitter;
import com.hisagisoft.tadotter.model.TwitterList;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.part.ViewPart;

public class TrackView
extends ViewPart {
    private static Logger logger = Logger.getLogger(TrackView.class.getName());
    public static final String ID = "com.hisagisoft.eclipse.tadotter.TrackView";
    private TableViewer viewer;

    public void createPartControl(Composite parent) {
        logger.fine("createPartControl - START");
        this.viewer = new TableViewer(parent, 68352);
        Table table = this.viewer.getTable();
        table.setLinesVisible(true);
        table.setFont(new Font(null, "Verdana", 9, 0));
        TableColumn col = new TableColumn(table, 16384);
        col.setText("");
        col.setWidth(30);
        TableColumn col1 = new TableColumn(table, 16384);
        col1.setText("Name");
        col1.setWidth(100);
        TableColumn col2 = new TableColumn(table, 16384);
        col2.setText("Message");
        col2.setWidth(448);
        table.setHeaderVisible(true);
        this.viewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.viewer.addDoubleClickListener((IDoubleClickListener)new DoubleClickListener());
        logger.fine("createPartControl - END");
    }

    public void setInput(Object input) {
        this.viewer.setInput(input);
    }

    public void setFocus() {
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return null;
            }
            return ((TwitterList)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TableLabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Twitter t = (Twitter)element;
            switch (columnIndex) {
                case 0: {
                    return String.valueOf(t.getSeq() + 1);
                }
                case 1: {
                    return t.getUserName();
                }
                case 2: {
                    return t.getMessage();
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

