/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;

public abstract class Binding {
    protected DataBindingContext context;
    private IObservable target;
    private IObservable model;
    protected boolean disposed = false;

    public Binding(IObservable target, IObservable model) {
        this.target = target;
        this.model = model;
    }

    public final void init(DataBindingContext context) {
        this.context = context;
        this.preInit();
        context.addBinding(this);
        this.postInit();
    }

    protected abstract void preInit();

    protected abstract void postInit();

    public abstract IObservableValue getValidationStatus();

    public abstract void updateTargetToModel();

    public abstract void updateModelToTarget();

    public abstract void validateTargetToModel();

    public abstract void validateModelToTarget();

    public void dispose() {
        if (this.context != null) {
            this.context.removeBinding(this);
        }
        this.context = null;
        this.target = null;
        this.model = null;
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    void setDataBindingContext(DataBindingContext context) {
        this.context = context;
    }

    public IObservable getTarget() {
        return this.target;
    }

    public IObservable getModel() {
        return this.model;
    }
}

