/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.tstruts.util;

import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceManager;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.tstruts.action.ejb.ServiceNameReference;
import jp.ossc.tstruts.config.SystemConfig;

public class MyServiceUtil {
    private MyServiceUtil() {
    }

    public static Object getServiceObjectBySystemConfigProperty(String propertyName) {
        SystemConfig config = SystemConfig.getConfig();
        String serviceNameString = config.getProperty(propertyName);
        if (serviceNameString == null) {
            return null;
        }
        return MyServiceUtil.getServiceObject(serviceNameString);
    }

    public static Object getServiceObject(String name) {
        ServiceName serviceName = MyServiceUtil.createServiceName(name);
        return MyServiceUtil.getServiceObject(serviceName);
    }

    public static Object getServiceObjectByServiceNameRef(Service service, String name) {
        ServiceNameReference ref = (ServiceNameReference)MyServiceUtil.getServiceObject(service != null ? service.getServiceManagerName() : null, "ServiceNameRef");
        if (ref == null) {
            return null;
        }
        return MyServiceUtil.getServiceObject(ref.getServiceName(name));
    }

    public static Object getServiceObject(ServiceManager manager, String refName) {
        ServiceNameReference referer = (ServiceNameReference)manager.getServiceObject("ServiceNameRef");
        ServiceName serviceName = referer.getServiceName(refName);
        return MyServiceUtil.getServiceObject(serviceName);
    }

    public static Object getServiceObject(String managerName, String serviceName) {
        Object service = null;
        try {
            service = ServiceManagerFactory.getServiceObject((String)managerName, (String)serviceName);
        }
        catch (ServiceNotFoundException e) {
            return null;
        }
        return service;
    }

    public static Object getServiceObject(ServiceName serviceName) {
        Object service = null;
        try {
            service = ServiceManagerFactory.getServiceObject((ServiceName)serviceName);
        }
        catch (ServiceNotFoundException e) {
            return null;
        }
        return service;
    }

    public static ServiceName createServiceName(String name) {
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(name);
        ServiceName serviceName = (ServiceName)editor.getValue();
        return serviceName;
    }
}

